/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.local;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.tycho.p2.maven.repository.Activator;
import org.eclipse.tycho.p2.maven.repository.xmlio.ArtifactsIO;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.LocalRepositoryP2Indices;
import org.eclipse.tycho.p2.repository.LocalRepositoryReader;
import org.eclipse.tycho.p2.repository.RepositoryLayoutHelper;
import org.eclipse.tycho.p2.repository.RepositoryReader;
import org.eclipse.tycho.p2.repository.TychoRepositoryIndex;
import org.eclipse.tycho.repository.local.GAVArtifactDescriptor;
import org.eclipse.tycho.repository.p2base.artifact.provider.formats.ArtifactTransferPolicies;
import org.eclipse.tycho.repository.p2base.artifact.repository.ArtifactRepositoryBaseImpl;

public class LocalArtifactRepository
extends ArtifactRepositoryBaseImpl<GAVArtifactDescriptor> {
    private Set<IArtifactDescriptor> descriptorsOnLastSave;
    private final LocalRepositoryP2Indices localRepoIndices;
    private final RepositoryReader contentLocator;
    private final Map<IArtifactKey, Lock> downloadLocks = new ConcurrentHashMap<IArtifactKey, Lock>();

    public LocalArtifactRepository(LocalRepositoryP2Indices localRepoIndices) {
        this(Activator.getProvisioningAgent(), localRepoIndices);
    }

    public LocalArtifactRepository(LocalRepositoryP2Indices localRepoIndices, RepositoryReader contentLocator) {
        this(Activator.getProvisioningAgent(), localRepoIndices, contentLocator);
    }

    public LocalArtifactRepository(IProvisioningAgent agent, LocalRepositoryP2Indices localRepoIndices) {
        this(agent, localRepoIndices, (RepositoryReader)new LocalRepositoryReader(localRepoIndices.getBasedir()));
    }

    public LocalArtifactRepository(IProvisioningAgent agent, LocalRepositoryP2Indices localRepoIndices, RepositoryReader contentLocator) {
        super(agent, localRepoIndices.getBasedir().toURI(), ArtifactTransferPolicies.forLocalArtifacts());
        this.localRepoIndices = localRepoIndices;
        this.contentLocator = contentLocator;
        this.loadMaven();
    }

    private void loadMaven() {
        ArtifactsIO io = new ArtifactsIO();
        TychoRepositoryIndex index = this.localRepoIndices.getArtifactsIndex();
        for (GAV gav : index.getProjectGAVs()) {
            try {
                File localArtifactFileLocation = this.contentLocator.getLocalArtifactLocation(gav, "p2artifacts", "xml");
                if (!localArtifactFileLocation.exists()) {
                    index.removeGav(gav);
                    continue;
                }
                Throwable throwable = null;
                Object var7_9 = null;
                try (FileInputStream is = new FileInputStream(this.contentLocator.getLocalArtifactLocation(gav, "p2artifacts", "xml"));){
                    Set<IArtifactDescriptor> gavDescriptors = io.readXML(is);
                    for (IArtifactDescriptor descriptor : gavDescriptors) {
                        this.internalAddDescriptor(descriptor);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.descriptorsOnLastSave = this.flattenedValues().collect(Collectors.toSet());
    }

    private synchronized void saveMaven() {
        File location = this.getBasedir();
        TychoRepositoryIndex index = this.localRepoIndices.getArtifactsIndex();
        ArtifactsIO io = new ArtifactsIO();
        Set descriptors = this.flattenedValues().collect(Collectors.toSet());
        HashSet changedDescriptors = new HashSet(descriptors);
        changedDescriptors.removeAll(this.descriptorsOnLastSave);
        HashSet<IArtifactKey> changedKeys = new HashSet<IArtifactKey>();
        for (IArtifactDescriptor changedDescriptor : changedDescriptors) {
            changedKeys.add(changedDescriptor.getArtifactKey());
        }
        for (IArtifactKey key : changedKeys) {
            Set keyDescriptors = (Set)this.descriptorsMap.get(key);
            if (keyDescriptors == null || keyDescriptors.isEmpty()) continue;
            GAVArtifactDescriptor anyDescriptorOfKey = (GAVArtifactDescriptor)((Object)keyDescriptors.iterator().next());
            GAV gav = anyDescriptorOfKey.getMavenCoordinates().getGav();
            index.addGav(gav);
            String relpath = this.getMetadataRelpath(gav);
            File file = new File(location, relpath);
            file.getParentFile().mkdirs();
            try {
                Throwable throwable = null;
                Object var15_18 = null;
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
                    io.writeXML((Set<? extends IArtifactDescriptor>)keyDescriptors, os);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            index.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.descriptorsOnLastSave = new HashSet(descriptors);
    }

    private String getMetadataRelpath(GAV gav) {
        String relpath = RepositoryLayoutHelper.getRelativePath((GAV)gav, (String)"p2artifacts", (String)"xml");
        return relpath;
    }

    public void save() {
        this.saveMaven();
    }

    @Override
    protected File internalGetArtifactStorageLocation(IArtifactDescriptor descriptor) {
        String relativePath = this.toInternalDescriptor(descriptor).getMavenCoordinates().getLocalRepositoryPath();
        return new File(this.getBasedir(), relativePath);
    }

    public IArtifactDescriptor createArtifactDescriptor(IArtifactKey key) {
        return new GAVArtifactDescriptor(key);
    }

    @Override
    protected IArtifactDescriptor getComparableDescriptor(IArtifactDescriptor descriptor) {
        return this.toInternalDescriptor(descriptor);
    }

    @Override
    protected GAVArtifactDescriptor getInternalDescriptorForAdding(IArtifactDescriptor descriptor) {
        return this.toInternalDescriptor(descriptor);
    }

    private GAVArtifactDescriptor toInternalDescriptor(IArtifactDescriptor descriptor) {
        if (descriptor instanceof GAVArtifactDescriptor && descriptor.getRepository() == this) {
            return (GAVArtifactDescriptor)descriptor;
        }
        GAVArtifactDescriptor internalDescriptor = new GAVArtifactDescriptor(descriptor);
        internalDescriptor.setRepository((IArtifactRepository)this);
        return internalDescriptor;
    }

    private File getBasedir() {
        return new File(this.getLocation());
    }

    public boolean isModifiable() {
        return true;
    }

    @Override
    public boolean isFileAlreadyAvailable(IArtifactKey artifactKey) {
        return this.contains(artifactKey);
    }

    Lock getLockForDownload(IArtifactKey key) {
        return this.downloadLocks.computeIfAbsent(key, k -> new ReentrantLock());
    }
}

