/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.ee.ExecutionEnvironmentUtils;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironment;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.osgi.framework.BundleException;

@Component(role=EquinoxResolver.class)
public class EquinoxResolver {
    public static final String SYSTEM_BUNDLE_SYMBOLIC_NAME = "system.bundle";
    public static final long SYSTEM_BUNDLE_ID = 0L;
    private static StateObjectFactory factory = StateObjectFactory.defaultFactory;
    @Requirement
    private BundleReader manifestReader;
    @Requirement
    private Logger logger;

    public State newResolvedState(MavenProject project, ExecutionEnvironment ee, boolean ignoreEE, DependencyArtifacts artifacts) throws BundleException {
        Properties properties = this.getPlatformProperties(project, ee);
        State state = this.newState(artifacts, properties, ignoreEE);
        this.resolveState(state);
        BundleDescription bundleDescription = state.getBundleByLocation(EquinoxResolver.getNormalizedPath(project.getBasedir()));
        this.assertResolved(state, bundleDescription);
        return state;
    }

    public State newResolvedState(File basedir, ExecutionEnvironment ee, DependencyArtifacts artifacts) throws BundleException {
        Properties properties = this.getPlatformProperties(new Properties(), null, ee);
        State state = this.newState(artifacts, properties, false);
        this.resolveState(state);
        BundleDescription bundleDescription = state.getBundleByLocation(EquinoxResolver.getNormalizedPath(basedir));
        this.assertResolved(state, bundleDescription);
        return state;
    }

    protected void resolveState(State state) {
        state.resolve(false);
        Object[] bundles = state.getBundles(SYSTEM_BUNDLE_SYMBOLIC_NAME);
        if (bundles == null || bundles.length == 0) {
            this.logger.warn("No system.bundle");
        } else if (bundles.length > 1) {
            this.logger.warn("Multiple system.bundles " + Arrays.toString(bundles));
        } else if (bundles[0].getBundleId() != 0L) {
            this.logger.warn("system.bundle bundleId == " + bundles[0].getBundleId());
        }
    }

    public String toDebugString(State state) {
        StringBuilder sb = new StringBuilder("Resolved OSGi state\n");
        for (BundleDescription otherBundle : state.getBundles()) {
            if (!otherBundle.isResolved()) {
                sb.append("NOT ");
            }
            sb.append("RESOLVED ");
            sb.append(otherBundle.toString()).append(" : ").append(otherBundle.getLocation());
            sb.append('\n');
            for (ResolverError error : state.getResolverErrors(otherBundle)) {
                sb.append('\t').append(error.toString()).append('\n');
            }
        }
        return sb.toString();
    }

    protected Properties getPlatformProperties(MavenProject project, ExecutionEnvironment ee) {
        TargetPlatformConfiguration configuration = TychoProjectUtils.getTargetPlatformConfiguration(project);
        TargetEnvironment environment = configuration.getEnvironments().get(0);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)((Properties)project.getContextValue(TychoConstants.CTX_MERGED_PROPERTIES)));
        return this.getPlatformProperties(properties, environment, ee);
    }

    protected Properties getPlatformProperties(Properties properties, TargetEnvironment environment, ExecutionEnvironment ee) {
        if (environment != null) {
            properties.put("osgi.os", environment.getOs());
            properties.put("osgi.ws", environment.getWs());
            properties.put("osgi.arch", environment.getArch());
        }
        ExecutionEnvironmentUtils.applyProfileProperties(properties, ee.getProfileProperties());
        properties.put("osgi.resolverMode", "development");
        return properties;
    }

    protected State newState(DependencyArtifacts artifacts, Properties properties, boolean ignoreEE) throws BundleException {
        State state = factory.createState(true);
        LinkedHashMap systemBundles = new LinkedHashMap();
        LinkedHashMap externalBundles = new LinkedHashMap();
        LinkedHashMap projects = new LinkedHashMap();
        for (ArtifactDescriptor artifact : artifacts.getArtifacts("eclipse-plugin")) {
            Dictionary<String, String> mf;
            File location = artifact.getLocation();
            if (this.isFrameworkImplementation(location, mf = this.loadManifest(location))) {
                systemBundles.put(location, mf);
                continue;
            }
            if (artifact.getMavenProject() != null) {
                projects.put(location, mf);
                continue;
            }
            externalBundles.put(location, mf);
        }
        long id = 0L;
        if (systemBundles.isEmpty()) {
            state.addBundle(factory.createBundleDescription(state, this.getSystemBundleManifest(properties), "", id++));
        } else {
            for (Map.Entry entry : systemBundles.entrySet()) {
                this.addBundle(state, id++, (File)entry.getKey(), (Dictionary)entry.getValue(), false);
            }
        }
        for (Map.Entry entry : externalBundles.entrySet()) {
            this.addBundle(state, id++, (File)entry.getKey(), (Dictionary)entry.getValue(), false);
        }
        for (Map.Entry entry : projects.entrySet()) {
            this.addBundle(state, id++, (File)entry.getKey(), (Dictionary)entry.getValue(), true);
        }
        ArrayList allProps = new ArrayList();
        Hashtable<Object, Object> platformProperties = new Hashtable<Object, Object>(properties);
        platformProperties.put("osgi.system.bundle", state.getBundle(0L).getSymbolicName());
        allProps.add(platformProperties);
        if (ignoreEE) {
            for (String profile : ExecutionEnvironmentUtils.getProfileNames()) {
                Properties envProps = ExecutionEnvironmentUtils.getExecutionEnvironment(profile).getProfileProperties();
                String systemPackages = envProps.getProperty("org.osgi.framework.system.packages");
                String execEnv = envProps.getProperty("org.osgi.framework.executionenvironment");
                Hashtable<String, String> prop = new Hashtable<String, String>();
                ((Dictionary)prop).put("org.osgi.framework.system.packages", systemPackages);
                ((Dictionary)prop).put("org.osgi.framework.executionenvironment", execEnv);
                allProps.add(prop);
            }
        }
        Dictionary[] stateProperties = allProps.toArray(new Dictionary[allProps.size()]);
        state.setPlatformProperties(stateProperties);
        return state;
    }

    private boolean isFrameworkImplementation(File location, Dictionary<String, String> mf) {
        String value = mf.get("Export-Package");
        if (value != null) {
            try {
                ManifestElement[] exports;
                for (ManifestElement export : exports = ManifestElement.parseHeader((String)"Export-Package", (String)value)) {
                    if (!"org.osgi.framework".equals(export.getValue())) continue;
                    return true;
                }
            }
            catch (BundleException bundleException) {
                // empty catch block
            }
        }
        return false;
    }

    public void addBundle(State state, long id, File bundleLocation, Dictionary<String, String> mf, boolean override) throws BundleException {
        BundleDescription[] conflicts;
        BundleDescription descriptor = factory.createBundleDescription(state, mf, EquinoxResolver.getNormalizedPath(bundleLocation), id);
        if (override && (conflicts = state.getBundles(descriptor.getSymbolicName())) != null) {
            for (BundleDescription conflict : conflicts) {
                state.removeBundle(conflict);
                this.logger.warn(conflict.toString() + " has been replaced by another bundle with the same symbolic name " + descriptor.toString());
            }
        }
        state.addBundle(descriptor);
    }

    private static String getNormalizedPath(File file) throws BundleException {
        return file.getAbsolutePath();
    }

    private Dictionary<String, String> loadManifest(File bundleLocation) {
        if (bundleLocation == null || !bundleLocation.exists()) {
            throw new IllegalArgumentException("bundleLocation not found: " + bundleLocation);
        }
        return this.manifestReader.loadManifest(bundleLocation).getHeaders();
    }

    private Dictionary<String, String> getSystemBundleManifest(Properties properties) {
        String systemPackages = properties.getProperty("org.osgi.framework.system.packages");
        Hashtable<String, String> systemBundleManifest = new Hashtable<String, String>();
        ((Dictionary)systemBundleManifest).put("Bundle-SymbolicName", SYSTEM_BUNDLE_SYMBOLIC_NAME);
        ((Dictionary)systemBundleManifest).put("Bundle-Version", "0.0.0");
        ((Dictionary)systemBundleManifest).put("Bundle-ManifestVersion", "2");
        if (systemPackages != null && systemPackages.trim().length() > 0) {
            ((Dictionary)systemBundleManifest).put("Export-Package", systemPackages);
        } else {
            this.logger.warn("Undefined or empty org.osgi.framework.system.packages system property, system.bundle does not export any packages.");
        }
        return systemBundleManifest;
    }

    public void assertResolved(State state, BundleDescription desc) throws BundleException {
        if (!desc.isResolved()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Equinox resolver state:\n" + this.toDebugString(state));
            }
            StringBuffer msg = new StringBuffer();
            msg.append("Bundle ").append(desc.getSymbolicName()).append(" cannot be resolved\n");
            msg.append("Resolution errors:\n");
            ResolverError[] errors = this.getResolverErrors(state, desc);
            for (int i = 0; i < errors.length; ++i) {
                ResolverError error = errors[i];
                msg.append("   Bundle ").append(error.getBundle().getSymbolicName()).append(" - ").append(error.toString()).append("\n");
            }
            throw new BundleException(msg.toString());
        }
    }

    public ResolverError[] getResolverErrors(State state, BundleDescription bundle) {
        LinkedHashSet<ResolverError> errors = new LinkedHashSet<ResolverError>();
        this.getRelevantErrors(state, errors, bundle);
        return errors.toArray(new ResolverError[errors.size()]);
    }

    private void getRelevantErrors(State state, Set<ResolverError> errors, BundleDescription bundle) {
        ResolverError[] bundleErrors = state.getResolverErrors(bundle);
        for (int j = 0; j < bundleErrors.length; ++j) {
            ResolverError error = bundleErrors[j];
            errors.add(error);
            VersionConstraint constraint = error.getUnsatisfiedConstraint();
            if (!(constraint instanceof BundleSpecification) && !(constraint instanceof HostSpecification)) continue;
            BundleDescription[] requiredBundles = state.getBundles(constraint.getName());
            for (int i = 0; i < requiredBundles.length; ++i) {
                if (bundle.equals(requiredBundles[i])) continue;
                this.getRelevantErrors(state, errors, requiredBundles[i]);
            }
        }
    }
}

