/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.image.awt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import org.jemmy.image.awt.ImageTool;
import org.jemmy.image.awt.StrictImageComparator;

public class DiffDialog
extends JDialog {
    private static final StrictImageComparator comparator = new StrictImageComparator();
    private double scale = 1.0;
    private int imageWidth;
    private int imageHeight;
    private int scaledWidth;
    private int scaledHeight;
    private ImagePane left = null;
    private ImagePane right = null;
    private ImagePane diff = null;
    int status = 0;
    private JPanel controlPane;
    private JButton copyBtn;
    private JSplitPane dcSplit;
    private JPanel diffPane;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton6;
    private JButton jButton7;
    private JPanel leftPane;
    private JSplitPane lrSplit;
    private JButton removeBtn;
    private JPanel rightPane;
    private JSplitPane tbSplit;

    DiffDialog() {
        super((Dialog)null, true);
        this.initComponents();
        this.leftPane.setLayout(new BorderLayout());
        this.leftPane.add((Component)new JLabel("Golden"), "North");
        this.rightPane.setLayout(new BorderLayout());
        this.rightPane.add((Component)new JLabel("Result"), "North");
        this.diffPane.setLayout(new BorderLayout());
        this.diffPane.add((Component)new JLabel("Diff"), "North");
        this.getContentPane().addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                DiffDialog.this.lrSplit.setDividerLocation(0.5);
                DiffDialog.this.dcSplit.setDividerLocation(0.5);
                DiffDialog.this.tbSplit.setDividerLocation(0.5);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void componentShown(ComponentEvent e) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        this.setSize(400, 300);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = this.getSize().width;
        int h = this.getSize().height;
        int x = (dim.width - w) / 2;
        int y = (dim.height - h) / 2;
        this.setLocation(x, y);
    }

    void setImages(BufferedImage leftImage, BufferedImage rightImage) {
        if (leftImage != null && rightImage != null) {
            this.copyBtn.setEnabled(true);
            this.removeBtn.setEnabled(false);
            this.imageWidth = leftImage.getWidth();
            this.imageHeight = leftImage.getHeight();
        } else if (leftImage == null) {
            this.copyBtn.setEnabled(true);
            this.removeBtn.setEnabled(false);
            this.imageWidth = rightImage.getWidth();
            this.imageHeight = rightImage.getHeight();
        } else if (rightImage == null) {
            this.copyBtn.setEnabled(false);
            this.removeBtn.setEnabled(true);
            this.imageWidth = leftImage.getWidth();
            this.imageHeight = leftImage.getHeight();
        }
        if (this.left == null) {
            this.left = new ImagePane(leftImage);
        } else {
            this.left.setImage(leftImage);
        }
        this.leftPane.add((Component)this.left, "Center");
        if (this.right == null) {
            this.right = new ImagePane(rightImage);
        } else {
            this.right.setImage(rightImage);
        }
        this.rightPane.add((Component)this.right, "Center");
        if (this.diff == null) {
            this.diff = new ImagePane(this.subtract(leftImage, rightImage));
        } else {
            this.diff.setImage(this.subtract(leftImage, rightImage));
        }
        this.diffPane.add((Component)this.diff, "Center");
        this.rescaleAll();
    }

    private BufferedImage subtract(BufferedImage left, BufferedImage right) {
        if (left != null && right != null) {
            return ImageTool.subtractImage(left, right);
        }
        return null;
    }

    private void initComponents() {
        this.tbSplit = new JSplitPane();
        this.lrSplit = new JSplitPane();
        this.leftPane = new JPanel();
        this.rightPane = new JPanel();
        this.dcSplit = new JSplitPane();
        this.diffPane = new JPanel();
        this.controlPane = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.copyBtn = new JButton();
        this.removeBtn = new JButton();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.tbSplit.setDividerLocation(200);
        this.tbSplit.setOrientation(0);
        this.lrSplit.setDividerLocation(250);
        GroupLayout leftPaneLayout = new GroupLayout(this.leftPane);
        this.leftPane.setLayout(leftPaneLayout);
        leftPaneLayout.setHorizontalGroup(leftPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 250, Short.MAX_VALUE));
        leftPaneLayout.setVerticalGroup(leftPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 200, Short.MAX_VALUE));
        this.lrSplit.setLeftComponent(this.leftPane);
        GroupLayout rightPaneLayout = new GroupLayout(this.rightPane);
        this.rightPane.setLayout(rightPaneLayout);
        rightPaneLayout.setHorizontalGroup(rightPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 293, Short.MAX_VALUE));
        rightPaneLayout.setVerticalGroup(rightPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 200, Short.MAX_VALUE));
        this.lrSplit.setRightComponent(this.rightPane);
        this.tbSplit.setTopComponent(this.lrSplit);
        GroupLayout diffPaneLayout = new GroupLayout(this.diffPane);
        this.diffPane.setLayout(diffPaneLayout);
        diffPaneLayout.setHorizontalGroup(diffPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        diffPaneLayout.setVerticalGroup(diffPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 255, Short.MAX_VALUE));
        this.dcSplit.setLeftComponent(this.diffPane);
        this.jButton1.setMnemonic('+');
        this.jButton1.setText("+");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiffDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setMnemonic('-');
        this.jButton2.setText("-");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiffDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.copyBtn.setText("Copy to golgen");
        this.copyBtn.setEnabled(false);
        this.copyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiffDialog.this.copyBtnActionPerformed(evt);
            }
        });
        this.removeBtn.setText("Remove from golden");
        this.removeBtn.setEnabled(false);
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiffDialog.this.removeBtnActionPerformed(evt);
            }
        });
        this.jButton6.setText("Next");
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiffDialog.this.jButton6ActionPerformed(evt);
            }
        });
        this.jButton7.setText("Exit");
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiffDialog.this.jButton7ActionPerformed(evt);
            }
        });
        GroupLayout controlPaneLayout = new GroupLayout(this.controlPane);
        this.controlPane.setLayout(controlPaneLayout);
        controlPaneLayout.setHorizontalGroup(controlPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPaneLayout.createSequentialGroup().addContainerGap(289, Short.MAX_VALUE).addGroup(controlPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, controlPaneLayout.createSequentialGroup().addComponent(this.jButton6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton7)).addGroup(GroupLayout.Alignment.TRAILING, controlPaneLayout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2)).addComponent(this.copyBtn, GroupLayout.Alignment.TRAILING).addComponent(this.removeBtn, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        controlPaneLayout.setVerticalGroup(controlPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPaneLayout.createSequentialGroup().addContainerGap().addGroup(controlPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 107, Short.MAX_VALUE).addGroup(controlPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton7).addComponent(this.jButton6)).addContainerGap()));
        this.dcSplit.setRightComponent(this.controlPane);
        this.tbSplit.setRightComponent(this.dcSplit);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tbSplit, -1, 549, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tbSplit, -1, 461, Short.MAX_VALUE));
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.scale *= 0.9;
        this.rescaleAll();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.scale *= 1.1;
        this.rescaleAll();
    }

    private void rescaleAll() {
        this.scaledWidth = (int)((double)this.imageWidth * this.scale);
        this.scaledHeight = (int)((double)this.imageHeight * this.scale);
        this.left.reScale();
        this.right.reScale();
        this.diff.reScale();
        this.getContentPane().repaint();
    }

    private void copyBtnActionPerformed(ActionEvent evt) {
        this.status = -1;
        this.setVisible(false);
    }

    private void removeBtnActionPerformed(ActionEvent evt) {
        this.status = 1;
        this.setVisible(false);
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        this.status = -2;
        this.setVisible(false);
    }

    private class ImagePane
    extends JPanel {
        BufferedImage img;
        Image scaled;

        public ImagePane(BufferedImage img) {
            this.img = img;
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.img != null) {
                g.drawImage(this.scaled, 0, 0, this);
            } else {
                super.paintComponent(g);
            }
        }

        void setImage(BufferedImage img) {
            this.img = img;
            this.reScale();
        }

        void reScale() {
            if (this.img != null) {
                this.scaled = this.img.getScaledInstance(DiffDialog.this.scaledWidth, DiffDialog.this.scaledHeight, 1);
            }
        }
    }
}

