/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer.api;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import org.openjdk.jmc.flightrecorder.writer.RecordingImpl;
import org.openjdk.jmc.flightrecorder.writer.RecordingSettingsBuilderImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Recording;
import org.openjdk.jmc.flightrecorder.writer.api.RecordingSettingsBuilder;

public final class Recordings {
    public static Recording newRecording(String path) throws IOException {
        return Recordings.newRecording(Paths.get(path, new String[0]));
    }

    public static Recording newRecording(String path, Consumer<RecordingSettingsBuilder> settingsCallback) throws IOException {
        return Recordings.newRecording(Paths.get(path, new String[0]), settingsCallback);
    }

    public static Recording newRecording(Path path) throws IOException {
        return Recordings.newRecording(path.toFile());
    }

    public static Recording newRecording(Path path, Consumer<RecordingSettingsBuilder> settingsCallback) throws IOException {
        return Recordings.newRecording(path.toFile(), settingsCallback);
    }

    public static Recording newRecording(File path) throws IOException {
        return Recordings.newRecording(new FileOutputStream(path));
    }

    public static Recording newRecording(File path, Consumer<RecordingSettingsBuilder> settingsCallback) throws IOException {
        return Recordings.newRecording(new FileOutputStream(path), settingsCallback);
    }

    public static Recording newRecording(OutputStream recordingStream) {
        return Recordings.newRecording(recordingStream, RecordingSettingsBuilder::withJdkTypeInitialization);
    }

    public static Recording newRecording(OutputStream recordingStream, Consumer<RecordingSettingsBuilder> settingsCallback) {
        RecordingSettingsBuilderImpl builder = new RecordingSettingsBuilderImpl();
        if (settingsCallback != null) {
            settingsCallback.accept(builder);
        }
        return new RecordingImpl(new BufferedOutputStream(recordingStream), builder.build());
    }
}

