/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.List;
import java.util.function.Consumer;
import org.openjdk.jmc.flightrecorder.writer.BaseType;
import org.openjdk.jmc.flightrecorder.writer.MetadataImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueBuilderImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Annotation;
import org.openjdk.jmc.flightrecorder.writer.api.NamedType;
import org.openjdk.jmc.flightrecorder.writer.api.Type;
import org.openjdk.jmc.flightrecorder.writer.api.TypedValueBuilder;
import org.openjdk.jmc.flightrecorder.writer.util.NonZeroHashCode;

public final class ResolvableType
implements TypeImpl {
    private final String typeName;
    private final MetadataImpl metadata;
    private volatile TypeImpl delegate;

    ResolvableType(String typeName, MetadataImpl metadata) {
        this.typeName = typeName;
        this.metadata = metadata;
        this.metadata.addUnresolved(this);
    }

    @Override
    public boolean isResolved() {
        return this.delegate != null;
    }

    private void checkResolved() {
        if (this.delegate == null) {
            throw new IllegalStateException();
        }
    }

    @Override
    public long getId() {
        this.checkResolved();
        return this.delegate.getId();
    }

    @Override
    public boolean hasConstantPool() {
        this.checkResolved();
        return this.delegate.hasConstantPool();
    }

    @Override
    public TypedValueImpl asValue(String value) {
        this.checkResolved();
        return this.delegate.asValue(value);
    }

    @Override
    public TypedValueImpl asValue(byte value) {
        this.checkResolved();
        return this.delegate.asValue(value);
    }

    @Override
    public TypedValueImpl asValue(char value) {
        this.checkResolved();
        return this.delegate.asValue(value);
    }

    @Override
    public TypedValueImpl asValue(short value) {
        this.checkResolved();
        return this.delegate.asValue(value);
    }

    @Override
    public TypedValueImpl asValue(int value) {
        this.checkResolved();
        return this.delegate.asValue(value);
    }

    @Override
    public TypedValueImpl asValue(long value) {
        this.checkResolved();
        return this.delegate.asValue(value);
    }

    @Override
    public TypedValueImpl asValue(float value) {
        this.checkResolved();
        return this.delegate.asValue(value);
    }

    @Override
    public TypedValueImpl asValue(double value) {
        this.checkResolved();
        return this.delegate.asValue(value);
    }

    @Override
    public TypedValueImpl asValue(boolean value) {
        this.checkResolved();
        return this.delegate.asValue(value);
    }

    @Override
    public TypedValueImpl asValue(Consumer<TypedValueBuilder> builderCallback) {
        this.checkResolved();
        return this.delegate.asValue((Consumer)builderCallback);
    }

    @Override
    public TypedValueImpl asValue(Object value) {
        this.checkResolved();
        return this.delegate.asValue(value);
    }

    @Override
    public TypedValueImpl nullValue() {
        this.checkResolved();
        return this.delegate.nullValue();
    }

    @Override
    public boolean isBuiltin() {
        this.checkResolved();
        return this.delegate.isBuiltin();
    }

    @Override
    public boolean isSimple() {
        this.checkResolved();
        return this.delegate.isSimple();
    }

    @Override
    public String getSupertype() {
        this.checkResolved();
        return this.delegate.getSupertype();
    }

    @Override
    public List<TypedFieldImpl> getFields() {
        this.checkResolved();
        return this.delegate.getFields();
    }

    @Override
    public TypedFieldImpl getField(String name) {
        this.checkResolved();
        return this.delegate.getField(name);
    }

    @Override
    public List<Annotation> getAnnotations() {
        this.checkResolved();
        return this.delegate.getAnnotations();
    }

    @Override
    public boolean canAccept(Object value) {
        this.checkResolved();
        return this.delegate.canAccept(value);
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public boolean isSame(NamedType other) {
        this.checkResolved();
        return this.delegate.isSame(other);
    }

    @Override
    public boolean isUsedBy(Type other) {
        this.checkResolved();
        return this.delegate.isUsedBy(other);
    }

    @Override
    public TypesImpl getTypes() {
        return null;
    }

    @Override
    public TypedValueBuilderImpl valueBuilder() {
        this.checkResolved();
        return this.delegate.valueBuilder();
    }

    boolean resolve() {
        TypeImpl resolved = this.metadata.getType(this.typeName, false);
        if (resolved instanceof BaseType) {
            this.delegate = resolved;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvableType that = (ResolvableType)o;
        return this.typeName.equals(that.typeName);
    }

    public int hashCode() {
        return NonZeroHashCode.hash(this.typeName);
    }

    public String toString() {
        return "ResolvableType [typeName=" + this.typeName + ", metadata=" + this.metadata + ", delegate=" + this.delegate + "]";
    }
}

