/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.HashMap;
import java.util.Map;
import org.openjdk.jmc.flightrecorder.writer.LEB128Writer;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueImpl;
import org.openjdk.jmc.flightrecorder.writer.api.TypedValue;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

final class ConstantPool {
    private final TypeImpl type;
    private final Map<Object, TypedValueImpl> constantMap = new HashMap<Object, TypedValueImpl>();
    private final Map<Long, TypedValueImpl> reverseMap = new HashMap<Long, TypedValueImpl>();

    ConstantPool(TypeImpl type) {
        this.type = type;
    }

    TypedValueImpl addOrGet(Object value) {
        if (value == null) {
            return this.type.nullValue();
        }
        return this.constantMap.computeIfAbsent(value, v -> {
            long index = this.constantMap.size() + 1;
            TypedValueImpl tValue = v instanceof TypedValue ? new TypedValueImpl((TypedValueImpl)v, index) : new TypedValueImpl(this.type, v, index);
            this.reverseMap.put(index, tValue);
            return tValue;
        });
    }

    TypedValueImpl get(long index) {
        return this.reverseMap.get(index);
    }

    void writeTo(LEB128Writer writer) {
        writer.writeLong(this.type.getId());
        writer.writeInt(this.constantMap.size());
        this.reverseMap.forEach((k, v) -> {
            writer.writeLong((long)k);
            this.writeValueType(writer, (TypedValueImpl)v, false);
        });
    }

    void writeValueType(LEB128Writer writer, TypedValueImpl typedValue, boolean useConstantPoolReferences) {
        if (typedValue == null) {
            throw new NullPointerException();
        }
        TypeImpl type = typedValue.getType();
        if (type.isBuiltin()) {
            this.writeBuiltinType(writer, typedValue, useConstantPoolReferences);
        } else if (typedValue.isNull()) {
            writer.writeLong(0L);
        } else if (useConstantPoolReferences) {
            writer.writeLong(typedValue.getConstantPoolIndex());
        } else {
            for (TypedFieldValueImpl fieldValue : typedValue.getFieldValues()) {
                TypedFieldImpl field = fieldValue.getField();
                if (field.isArray()) {
                    writer.writeInt(fieldValue.getValues().length);
                    for (TypedValueImpl t : fieldValue.getValues()) {
                        this.writeValueType(writer, t, t.getType().hasConstantPool());
                    }
                    continue;
                }
                this.writeValueType(writer, fieldValue.getValue(), field.getType().hasConstantPool());
            }
        }
    }

    void writeBuiltinType(LEB128Writer writer, TypedValueImpl typedValue, boolean useCp) {
        if (typedValue == null) {
            throw new NullPointerException();
        }
        if (!typedValue.getType().isBuiltin()) {
            throw new IllegalArgumentException();
        }
        TypeImpl type = typedValue.getType();
        Object value = typedValue.getValue();
        Types.Builtin builtin = Types.Builtin.ofType(type);
        switch (builtin) {
            case STRING: {
                if (useCp) {
                    if (typedValue.isNull()) {
                        writer.writeByte((byte)0);
                        break;
                    }
                    if (((String)typedValue.getValue()).isEmpty()) {
                        writer.writeByte((byte)1);
                        break;
                    }
                    writer.writeByte((byte)2).writeLong(typedValue.getConstantPoolIndex());
                    break;
                }
                writer.writeCompactUTF((String)value);
                break;
            }
            case BYTE: {
                writer.writeBytes(value != null ? (Byte)value : (byte)0);
                break;
            }
            case CHAR: {
                writer.writeChar(value != null ? ((Character)value).charValue() : (char)'\u0000');
                break;
            }
            case SHORT: {
                writer.writeShort(value != null ? (Short)value : (short)0);
                break;
            }
            case INT: {
                writer.writeInt(value != null ? (Integer)value : 0);
                break;
            }
            case LONG: {
                writer.writeLong(value != null ? (Long)value : 0L);
                break;
            }
            case FLOAT: {
                writer.writeFloat(value != null ? ((Float)value).floatValue() : 0.0f);
                break;
            }
            case DOUBLE: {
                writer.writeDouble(value != null ? (Double)value : 0.0);
                break;
            }
            case BOOLEAN: {
                writer.writeBoolean(value != null && (Boolean)value != false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported built-in type " + type.getTypeName());
            }
        }
    }

    public String toString() {
        return "ConstantPool [type=" + this.type + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constantMap == null ? 0 : this.constantMap.hashCode());
        result = 31 * result + (this.reverseMap == null ? 0 : this.reverseMap.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantPool other = (ConstantPool)obj;
        if (this.constantMap == null ? other.constantMap != null : !this.constantMap.equals(other.constantMap)) {
            return false;
        }
        if (this.reverseMap == null ? other.reverseMap != null : !this.reverseMap.equals(other.reverseMap)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

