/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openjdk.jmc.flightrecorder.writer.BaseType;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.SelfType;
import org.openjdk.jmc.flightrecorder.writer.TypeStructureImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Annotation;
import org.openjdk.jmc.flightrecorder.writer.util.NonZeroHashCode;

final class CompositeTypeImpl
extends BaseType {
    private int hashCode = 0;
    private final Map<String, TypedFieldImpl> fieldMap;
    private final List<TypedFieldImpl> fields;
    private final List<Annotation> annotations;

    CompositeTypeImpl(long id, String name, String supertype, TypeStructureImpl typeStructure, ConstantPools constantPools, TypesImpl types) {
        super(id, name, supertype, constantPools, types);
        this.fields = this.collectFields(typeStructure);
        this.annotations = typeStructure == null ? Collections.emptyList() : Collections.unmodifiableList(typeStructure.getAnnotations());
        this.fieldMap = this.fields.stream().collect(Collectors.toMap(TypedFieldImpl::getName, f -> f));
    }

    private List<TypedFieldImpl> collectFields(TypeStructureImpl typeStructure) {
        if (typeStructure == null) {
            return Collections.emptyList();
        }
        ArrayList<TypedFieldImpl> fields = new ArrayList<TypedFieldImpl>();
        for (TypedFieldImpl field : typeStructure.fields) {
            if (field.getType() == SelfType.INSTANCE) {
                fields.add(new TypedFieldImpl(this, field.getName(), field.isArray()));
                continue;
            }
            fields.add(field);
        }
        return fields;
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    public List<TypedFieldImpl> getFields() {
        return this.fields;
    }

    @Override
    public TypedFieldImpl getField(String name) {
        return this.fieldMap.get(name);
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public boolean canAccept(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof TypedValueImpl && ((TypedValueImpl)value).getType().equals(this)) {
            return true;
        }
        if (this.isSimple() && this.fields.get(0).getType().canAccept(value)) {
            return true;
        }
        return value instanceof Map;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CompositeTypeImpl that = (CompositeTypeImpl)o;
        return this.fields.equals(that.fields) && this.annotations.equals(that.annotations);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            ArrayList<TypedFieldImpl> nonRecursiveFields = new ArrayList<TypedFieldImpl>(this.fields.size());
            for (TypedFieldImpl typedField : this.fields) {
                if (typedField.getType() == this) continue;
                nonRecursiveFields.add(typedField);
            }
            this.hashCode = NonZeroHashCode.hash(super.hashCode(), nonRecursiveFields, this.annotations);
        }
        return this.hashCode;
    }

    @Override
    public String toString() {
        return "CompositeType(" + this.getTypeName() + ")";
    }
}

