/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg.command.changelog;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.hg.command.HgConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgChangeLogConsumer
extends HgConsumer {
    private static final String TIME_PATTERN = "yyyy-MM-dd HH:mm:ss Z";
    private static final String REVNO_TAG = "changeset:";
    private static final String TAG_TAG = "tag:";
    private static final String BRANCH_TAG = "branch:";
    private static final String AUTHOR_TAG = "user:";
    private static final String TIME_STAMP_TOKEN = "date:";
    private static final String MESSAGE_TOKEN = "description:";
    private static final String FILES_TOKEN = "files:";
    private List<ChangeSet> logEntries = new ArrayList<ChangeSet>();
    private ChangeSet currentChange;
    private String currentRevision;
    private String currentTag;
    private String currentBranch;
    private String userDatePattern;

    public HgChangeLogConsumer(ScmLogger logger, String userDatePattern) {
        super(logger);
        this.userDatePattern = userDatePattern;
    }

    public List<ChangeSet> getModifications() {
        return this.logEntries;
    }

    @Override
    public void consumeLine(String line) {
        String trimmedLine = line.trim();
        this.doConsume(null, trimmedLine);
    }

    @Override
    public void doConsume(ScmFileStatus status, String line) {
        if (line.startsWith(REVNO_TAG)) {
            this.currentChange = new ChangeSet();
            this.currentChange.setFiles(new ArrayList(0));
            this.logEntries.add(this.currentChange);
            String tmpLine = line.substring(REVNO_TAG.length()).trim();
            this.currentRevision = tmpLine.substring(tmpLine.indexOf(58) + 1);
            this.currentChange.setRevision(this.currentRevision);
        } else if (line.startsWith(BRANCH_TAG)) {
            String tmpLine;
            this.currentBranch = tmpLine = line.substring(BRANCH_TAG.length()).trim();
        } else if (line.startsWith(AUTHOR_TAG)) {
            String tmpLine = line.substring(AUTHOR_TAG.length()).trim();
            this.currentChange.setAuthor(tmpLine);
        } else if (line.startsWith(TIME_STAMP_TOKEN)) {
            String tmpLine = line.substring(TIME_STAMP_TOKEN.length()).trim();
            Date date = this.parseDate(tmpLine, this.userDatePattern, TIME_PATTERN, Locale.ENGLISH);
            this.currentChange.setDate(date);
        } else if (line.startsWith(TAG_TAG)) {
            String tmpLine;
            this.currentTag = tmpLine = line.substring(TAG_TAG.length()).trim();
        } else if (line.startsWith(FILES_TOKEN)) {
            String tmpLine = line.substring(FILES_TOKEN.length()).trim();
            String[] files = tmpLine.split(" ");
            for (int i = 0; i < files.length; ++i) {
                String file = files[i];
                ChangeFile changeFile = new ChangeFile(file, this.currentRevision);
                this.currentChange.addFile(changeFile);
            }
        } else if (line.startsWith(MESSAGE_TOKEN)) {
            this.currentChange.setComment("");
        } else {
            StringBuilder comment = new StringBuilder(this.currentChange.getComment());
            comment.append(line);
            comment.append('\n');
            this.currentChange.setComment(comment.toString());
        }
    }
}

