/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test.rules.jdk.general;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.ResultProvider;
import org.openjdk.jmc.flightrecorder.rules.ResultToolkit;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.jdk.general.PasswordsInArgumentsRule;
import org.openjdk.jmc.flightrecorder.test.rules.jdk.MockEventCollection;
import org.openjdk.jmc.flightrecorder.test.rules.jdk.TestEvent;
import org.openjdk.jmc.flightrecorder.test.rules.jdk.VMInfoTestEvent;

public class PasswordsInArgumentsRuleTest {
    @Test
    public void containsPassword() {
        TestEvent[] testEvents = new TestEvent[]{new VMInfoTestEvent("", "-Dpassword=foo")};
        this.testPasswordsInArgsRule(testEvents, "The following suspicious application arguments were found in this recording: -Dpassword=[...]. The following regular expression was used to exclude strings from this rule: ''.*(passworld|passwise).*''.If you do not want to have your passwords directly as arguments to the Java process, there are usually other means to provide them to your software. If you wish to keep using passwords as arguments, but want to be able to share recordings without also sharing the passwords, please disable the ''JVM Information'' event. Note that disabling the ''JVM Information'' event can limit functionality in the Flight Recorder automated analysis.");
    }

    @Test
    public void NotContainPassword() {
        TestEvent[] testEvents = new TestEvent[]{new VMInfoTestEvent("", "-Dpaswrd=foo")};
        this.testPasswordsInArgsRule(testEvents, "The recording does not seem to contain passwords in the application arguments.");
    }

    @Test
    public void containsExcludedStrings() {
        TestEvent[] testEvents = new TestEvent[]{new VMInfoTestEvent("", "-Dpassworld=foo")};
        this.testPasswordsInArgsRule(testEvents, "The recording does not seem to contain passwords in the application arguments.");
    }

    private void testPasswordsInArgsRule(TestEvent[] testEvents, String descriptionExpected) {
        MockEventCollection events = new MockEventCollection(testEvents);
        PasswordsInArgumentsRule passwordsInArgsRule = new PasswordsInArgumentsRule();
        RunnableFuture future = passwordsInArgsRule.createEvaluation((IItemCollection)events, IPreferenceValueProvider.DEFAULT_VALUES, (IResultValueProvider)new ResultProvider());
        try {
            future.run();
            IResult res = (IResult)future.get();
            String message = res.getSeverity() == Severity.OK ? res.getSummary() : ResultToolkit.populateMessage((IResult)res, (String)res.getExplanation(), (boolean)false) + res.getSolution();
            Assert.assertEquals((Object)descriptionExpected, (Object)message);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }
}

