/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.sisu.equinox.embedder.EmbeddedEquinox;
import org.eclipse.sisu.equinox.embedder.EquinoxLifecycleListener;
import org.eclipse.tycho.core.maven.MavenArtifactFacade;
import org.eclipse.tycho.core.shared.MavenArtifactRepositoryReference;
import org.eclipse.tycho.core.shared.MavenDependenciesResolver;

@Component(role=EquinoxLifecycleListener.class, hint="MavenDependenciesResolver")
public class MavenDependenciesResolverConfigurer
extends EquinoxLifecycleListener
implements MavenDependenciesResolver {
    @Requirement
    private Logger logger;
    @Requirement
    private LegacySupport context;
    @Requirement
    private RepositorySystem repositorySystem;

    public Collection<?> resolve(String groupId, String artifactId, String version, String packaging, String classifier, String dependencyScope, Collection<MavenArtifactRepositoryReference> additionalRepositories, Object session) {
        Artifact artifact;
        if (classifier != null && !classifier.isEmpty()) {
            artifact = this.repositorySystem.createArtifactWithClassifier(groupId, artifactId, version, packaging, classifier);
            artifact.setScope(dependencyScope);
        } else {
            artifact = this.repositorySystem.createArtifact(groupId, artifactId, version, dependencyScope, packaging);
        }
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        MavenSession mavenSession = this.getMavenSession(session);
        request.setOffline(mavenSession.isOffline());
        request.setLocalRepository(mavenSession.getLocalRepository());
        request.setResolveTransitively(dependencyScope != null && !dependencyScope.isEmpty());
        if (additionalRepositories != null && additionalRepositories.size() > 0) {
            ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>(mavenSession.getCurrentProject().getRemoteArtifactRepositories());
            for (MavenArtifactRepositoryReference reference : additionalRepositories) {
                repositories.add(this.repositorySystem.createArtifactRepository(reference.getId(), reference.getUrl(), null, null, null));
            }
            request.setRemoteRepositories(this.repositorySystem.getEffectiveRepositories(repositories));
        } else {
            request.setRemoteRepositories(mavenSession.getCurrentProject().getRemoteArtifactRepositories());
        }
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        Set artifacts = result.getArtifacts();
        ArrayList<MavenArtifactFacade> list = new ArrayList<MavenArtifactFacade>();
        for (Artifact a : artifacts) {
            list.add(new MavenArtifactFacade(a));
        }
        return list;
    }

    protected MavenSession getMavenSession(Object session) {
        MavenSession mavenSession = session instanceof MavenSession ? (MavenSession)session : Objects.requireNonNull(this.context.getSession(), "Can't acquire maven session from context, called outside maven thread context?");
        return mavenSession;
    }

    public void afterFrameworkStarted(EmbeddedEquinox framework) {
        framework.registerService(MavenDependenciesResolver.class, (Object)this);
    }

    public File getRepositoryRoot() {
        return new File(this.getMavenSession(null).getLocalRepository().getBasedir());
    }
}

