/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.ArtifactDependencyWalker;
import org.eclipse.tycho.core.osgitools.DefaultFeatureDescription;
import org.eclipse.tycho.core.osgitools.DefaultPluginDescription;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.model.Feature;
import org.eclipse.tycho.model.FeatureRef;
import org.eclipse.tycho.model.PluginRef;
import org.eclipse.tycho.model.ProductConfiguration;
import org.eclipse.tycho.model.UpdateSite;

public abstract class AbstractArtifactDependencyWalker
implements ArtifactDependencyWalker {
    private final DependencyArtifacts artifacts;
    private final TargetEnvironment[] environments;

    public AbstractArtifactDependencyWalker(DependencyArtifacts artifacts) {
        this(artifacts, null);
    }

    public AbstractArtifactDependencyWalker(DependencyArtifacts artifacts, TargetEnvironment[] environments) {
        this.artifacts = artifacts;
        this.environments = environments;
    }

    @Override
    public void traverseUpdateSite(UpdateSite site, ArtifactDependencyVisitor visitor) {
        WalkbackPath visited = new WalkbackPath();
        for (FeatureRef ref : site.getFeatures()) {
            this.traverseFeature(ref, visitor, visited);
        }
    }

    @Override
    public void traverseFeature(File location, Feature feature, ArtifactDependencyVisitor visitor) {
        this.traverseFeature(location, feature, null, visitor, new WalkbackPath());
    }

    protected void traverseFeature(File location, Feature feature, FeatureRef featureRef, ArtifactDependencyVisitor visitor, WalkbackPath visited) {
        Set installableUnits;
        String classifier;
        ReactorProject project;
        ArtifactDescriptor artifact = this.getArtifact(location, feature.getId());
        if (artifact == null) {
            throw new IllegalStateException("Feature " + location + " with id " + feature.getId() + " is not part of the project build target platform");
        }
        ArtifactKey key = artifact.getKey();
        DefaultFeatureDescription description = new DefaultFeatureDescription(key, location, project = artifact.getMavenProject(), classifier = artifact.getClassifier(), feature, featureRef, installableUnits = artifact.getInstallableUnits());
        if (visitor.visitFeature(description)) {
            for (PluginRef ref : feature.getPlugins()) {
                this.traversePlugin(ref, visitor, visited);
            }
            for (PluginRef ref : feature.getIncludedFeatures()) {
                this.traverseFeature((FeatureRef)ref, visitor, visited);
            }
        }
    }

    protected ArtifactDescriptor getArtifact(File location, String id) {
        Map artifacts = this.artifacts.getArtifact(location);
        if (artifacts != null) {
            for (ArtifactDescriptor artifact : artifacts.values()) {
                if (!id.equals(artifact.getKey().getId())) continue;
                return artifact;
            }
        }
        return null;
    }

    @Override
    public void traverseProduct(ProductConfiguration product, ArtifactDependencyVisitor visitor) {
        this.traverseProduct(product, visitor, new WalkbackPath());
    }

    protected void traverseProduct(ProductConfiguration product, ArtifactDependencyVisitor visitor, WalkbackPath visited) {
        if (product.useFeatures()) {
            for (FeatureRef ref : product.getFeatures()) {
                this.traverseFeature(ref, visitor, visited);
            }
        } else {
            for (FeatureRef ref : product.getPlugins()) {
                this.traversePlugin((PluginRef)ref, visitor, visited);
            }
        }
        HashSet<String> bundles = new HashSet<String>();
        for (ArtifactDescriptor artifact : visited.getVisited()) {
            ArtifactKey key = artifact.getKey();
            if (!"eclipse-plugin".equals(key.getType())) continue;
            bundles.add(key.getId());
        }
        if (this.environments != null && product.includeLaunchers()) {
            for (TargetEnvironment environment : this.environments) {
                String os = environment.getOs();
                String ws = environment.getWs();
                String arch = environment.getArch();
                String id = "macosx".equals(os) && ("x86".equals(arch) || "ppc".equals(arch)) ? "org.eclipse.equinox.launcher." + ws + "." + os : "org.eclipse.equinox.launcher." + ws + "." + os + "." + arch;
                if (bundles.contains(id)) continue;
                PluginRef ref = new PluginRef("plugin");
                ref.setId(id);
                ref.setOs(os);
                ref.setWs(ws);
                ref.setArch(arch);
                ref.setUnpack(true);
                this.traversePlugin(ref, visitor, visited);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void traverseFeature(FeatureRef ref, ArtifactDependencyVisitor visitor, WalkbackPath visited) {
        ArtifactDescriptor artifact = this.artifacts.getArtifact("eclipse-feature", ref.getId(), ref.getVersion());
        if (artifact != null) {
            if (visited.visited(artifact.getKey())) {
                return;
            }
            visited.enter(artifact);
            try {
                File location = artifact.getLocation(true);
                Feature feature = Feature.loadFeature((File)location);
                this.traverseFeature(location, feature, ref, visitor, visited);
            }
            finally {
                visited.leave(artifact);
            }
        } else {
            visitor.missingFeature(ref, visited.getWalkback());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traversePlugin(PluginRef ref, ArtifactDependencyVisitor visitor, WalkbackPath visited) {
        if (!this.matchTargetEnvironment(ref)) {
            return;
        }
        ArtifactDescriptor artifact = this.artifacts.getArtifact("eclipse-plugin", ref.getId(), ref.getVersion());
        if (artifact != null) {
            ArtifactKey key = artifact.getKey();
            if (visited.visited(key)) {
                return;
            }
            File location = artifact.getLocation(true);
            ReactorProject project = artifact.getMavenProject();
            String classifier = artifact.getClassifier();
            Set installableUnits = artifact.getInstallableUnits();
            DefaultPluginDescription description = new DefaultPluginDescription(key, location, project, classifier, ref, installableUnits);
            visited.enter(description);
            try {
                visitor.visitPlugin(description);
            }
            finally {
                visited.leave(description);
            }
        } else {
            visitor.missingPlugin(ref, visited.getWalkback());
        }
    }

    private boolean matchTargetEnvironment(PluginRef pluginRef) {
        String pluginOs = pluginRef.getOs();
        String pluginWs = pluginRef.getWs();
        String pluginArch = pluginRef.getArch();
        if (this.environments == null) {
            return true;
        }
        for (TargetEnvironment environment : this.environments) {
            if (!environment.match(pluginOs, pluginWs, pluginArch)) continue;
            return true;
        }
        return false;
    }

    protected static class WalkbackPath {
        private Map<ArtifactKey, ArtifactDescriptor> visited = new HashMap<ArtifactKey, ArtifactDescriptor>();
        private Stack<ArtifactDescriptor> walkback = new Stack();

        protected WalkbackPath() {
        }

        boolean visited(ArtifactKey key) {
            return this.visited.containsKey(key);
        }

        public List<ArtifactDescriptor> getWalkback() {
            return new ArrayList<ArtifactDescriptor>(this.walkback);
        }

        void enter(ArtifactDescriptor artifact) {
            this.visited.put(artifact.getKey(), artifact);
            this.walkback.push(artifact);
        }

        void leave(ArtifactDescriptor artifact) {
            this.walkback.pop();
        }

        Collection<ArtifactDescriptor> getVisited() {
            return this.visited.values();
        }
    }
}

