/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.ee;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.osgi.framework.Version;

public class EEVersion
implements Comparable<EEVersion> {
    private static final Version JAVA8 = Version.parseVersion((String)"1.8");
    @Nonnull
    private final Version version;
    @Nonnull
    private final EEType type;

    public EEVersion(@Nonnull Version version, @Nonnull EEType type) {
        this.version = version;
        this.type = type;
    }

    @Override
    public int compareTo(EEVersion other) {
        if (this.type.equals((Object)EEType.JAVA_SE) && this.version.compareTo(JAVA8) >= 0 && other.type.profileName.contains("JavaSE/compact")) {
            return 1;
        }
        if (other.type.equals((Object)EEType.JAVA_SE) && other.version.compareTo(JAVA8) >= 0 && this.type.profileName.contains("JavaSE/compact")) {
            return -1;
        }
        int result = this.type.compareTo(other.type);
        if (result != 0) {
            return result;
        }
        return this.version.compareTo(other.version);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof EEVersion)) {
            return false;
        }
        EEVersion o = (EEVersion)other;
        return this.version.equals((Object)o.version) && this.type.equals((Object)o.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.version});
    }

    public static enum EEType {
        OSGI_MINIMUM("OSGi/Minimum"),
        CDC_FOUNDATION("CDC/Foundation"),
        JRE("JRE"),
        JAVA_SE("JavaSE"),
        JAVA_SE_COMPACT1("JavaSE/compact1"),
        JAVA_SE_COMPACT2("JavaSE/compact2"),
        JAVA_SE_COMPACT3("JavaSE/compact3");

        private final String profileName;

        private EEType(String profileName) {
            this.profileName = profileName;
        }

        public static EEType fromName(String profileName) {
            for (EEType type : EEType.values()) {
                if (!type.profileName.equals(profileName)) continue;
                return type;
            }
            return null;
        }
    }
}

