/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.buildversion;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimestampFinder {
    private final Map<SimpleDateFormat, Pattern> datePatternsByRegularExpressions = TimestampFinder.defaultPatterns();

    private static Map<SimpleDateFormat, Pattern> defaultPatterns() {
        LinkedHashMap<SimpleDateFormat, Pattern> result = new LinkedHashMap<SimpleDateFormat, Pattern>();
        result.put(TimestampFinder.utcFormat("yyyyMMddHHmm"), Pattern.compile("([0-9]{12})"));
        result.put(TimestampFinder.utcFormat("yyyyMMdd-HHmm"), Pattern.compile("([0-9]{8})-([0-9]{4})"));
        result.put(TimestampFinder.utcFormat("yyyyMMdd"), Pattern.compile("([0-9]{8})"));
        return result;
    }

    private static SimpleDateFormat utcFormat(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }

    public Date findInString(String string) {
        for (Map.Entry<SimpleDateFormat, Pattern> e : this.datePatternsByRegularExpressions.entrySet()) {
            String group;
            Date timestamp;
            Matcher matcher = e.getValue().matcher(string);
            if (!matcher.find() || (timestamp = this.parseTimestamp(group = matcher.group(), e.getKey())) == null) continue;
            return timestamp;
        }
        return null;
    }

    private Date parseTimestamp(String timestampString, SimpleDateFormat format) {
        ParsePosition pos = new ParsePosition(0);
        Date timestamp = format.parse(timestampString, pos);
        if (timestamp != null && pos.getIndex() == timestampString.length()) {
            return timestamp;
        }
        return null;
    }
}

