/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumOutputStream;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback2;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackResult;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffSource;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgRemoteDiffEditor2
implements ISVNEditor {
    private long revision;
    private long targetRevision;
    private SVNRepository repository;
    private ISvnDiffCallback2 callback;
    private SvnDiffCallbackResult result;
    private SVNDeltaProcessor deltaProcessor;
    private boolean textDeltas;
    private DirBaton dirBaton;
    private FileBaton fileBaton;
    private Set<File> tempFiles;

    public SvnNgRemoteDiffEditor2(long revision, boolean textDeltas, SVNRepository repository, ISvnDiffCallback2 callback) {
        this.revision = revision;
        this.repository = repository;
        this.callback = callback;
        this.result = new SvnDiffCallbackResult();
        this.textDeltas = textDeltas;
        this.deltaProcessor = new SVNDeltaProcessor();
        this.tempFiles = new HashSet<File>();
    }

    public void targetRevision(long revision) throws SVNException {
        this.targetRevision = revision;
    }

    public void openRoot(long revision) throws SVNException {
        this.dirBaton = new DirBaton("", null, false, revision);
        this.dirBaton.leftSource = new SvnDiffSource(this.revision);
        this.dirBaton.rightSource = new SvnDiffSource(this.targetRevision);
        this.result.reset();
        this.callback.dirOpened(this.result, SVNFileUtil.createFilePath(""), this.dirBaton.leftSource, this.dirBaton.rightSource, null, null);
        this.dirBaton.skip = this.result.skip;
        this.dirBaton.skipChildren = this.result.skipChildren;
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        DirBaton pb = this.dirBaton;
        if (pb.skipChildren) {
            return;
        }
        SVNNodeKind kind = this.repository.checkPath(path, this.revision);
        if (kind == SVNNodeKind.FILE) {
            this.diffDeletedFile(path);
        } else if (kind == SVNNodeKind.DIR) {
            this.diffDeletedDirectory(path);
        }
    }

    public void absentDir(String path) throws SVNException {
        this.result.reset();
        this.callback.nodeAbsent(this.result, SVNFileUtil.createFilePath(path), null);
        this.dirBaton.skip = this.result.skip;
        this.dirBaton.skipChildren = this.result.skipChildren;
    }

    public void absentFile(String path) throws SVNException {
        this.result.reset();
        this.callback.nodeAbsent(this.result, SVNFileUtil.createFilePath(path), null);
        this.dirBaton.skip = this.result.skip;
        this.dirBaton.skipChildren = this.result.skipChildren;
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        DirBaton pb = this.dirBaton;
        this.dirBaton = new DirBaton(path, pb, true, -1L);
        if (pb.skipChildren) {
            this.dirBaton.skip = true;
            this.dirBaton.skipChildren = true;
            return;
        }
        this.dirBaton.rightSource = new SvnDiffSource(this.targetRevision);
        this.result.reset();
        this.callback.dirOpened(this.result, SVNFileUtil.createFilePath(this.dirBaton.path), null, this.dirBaton.rightSource, null, null);
        this.dirBaton.skip = this.result.skip;
        this.dirBaton.skipChildren = this.result.skipChildren;
    }

    public void openDir(String path, long revision) throws SVNException {
        DirBaton pb = this.dirBaton;
        this.dirBaton = new DirBaton(path, pb, false, revision);
        if (pb.skipChildren) {
            this.dirBaton.skip = true;
            this.dirBaton.skipChildren = true;
            return;
        }
        this.dirBaton.leftSource = new SvnDiffSource(this.revision);
        this.dirBaton.rightSource = new SvnDiffSource(this.targetRevision);
        this.result.reset();
        this.callback.dirOpened(this.result, SVNFileUtil.createFilePath(this.dirBaton.path), this.dirBaton.leftSource, this.dirBaton.rightSource, null, null);
        this.dirBaton.skip = this.result.skip;
        this.dirBaton.skipChildren = this.result.skipChildren;
    }

    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (this.dirBaton.skip) {
            return;
        }
        if (SVNProperty.isWorkingCopyProperty(name)) {
            return;
        }
        if (SVNProperty.isRegularProperty(name)) {
            this.dirBaton.hasPropChange = true;
        }
        this.dirBaton.propChanges.put(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDir() throws SVNException {
        try {
            boolean sendChanged = false;
            SVNProperties pristineProps = new SVNProperties();
            if ((this.dirBaton.hasPropChange || this.dirBaton.added) && !this.dirBaton.skip) {
                if (!this.dirBaton.added) {
                    this.repository.getDir(this.dirBaton.path, this.dirBaton.baseRevision, pristineProps, (ISVNDirEntryHandler)null);
                }
                if (this.dirBaton.propChanges.size() > 0) {
                    this.dirBaton.propChanges = this.removeNonPropChanges(pristineProps, this.dirBaton.propChanges);
                }
                if (this.dirBaton.propChanges.size() > 0 || this.dirBaton.added) {
                    SVNProperties rightProps = new SVNProperties(pristineProps);
                    rightProps.putAll(this.dirBaton.propChanges);
                    rightProps.removeNullValues();
                    if (this.dirBaton.added) {
                        this.result.reset();
                        this.callback.dirAdded(this.result, SVNFileUtil.createFilePath(this.dirBaton.path), null, this.dirBaton.rightSource, null, rightProps, null);
                        this.dirBaton.skip = this.result.skip;
                        this.dirBaton.skipChildren = this.result.skipChildren;
                    } else {
                        this.result.reset();
                        this.callback.dirChanged(this.result, SVNFileUtil.createFilePath(this.dirBaton.path), this.dirBaton.leftSource, this.dirBaton.rightSource, pristineProps, rightProps, this.dirBaton.propChanges, null);
                        this.dirBaton.skip = this.result.skip;
                        this.dirBaton.skipChildren = this.result.skipChildren;
                    }
                    sendChanged = true;
                }
            }
            if (!this.dirBaton.skip && !sendChanged) {
                this.result.reset();
                this.callback.dirClosed(this.result, SVNFileUtil.createFilePath(this.dirBaton.path), this.dirBaton.leftSource, this.dirBaton.rightSource, null);
                this.dirBaton.skip = this.result.skip;
                this.dirBaton.skipChildren = this.result.skipChildren;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.dirBaton = this.dirBaton.parentBaton;
            throw throwable;
        }
        this.dirBaton = this.dirBaton.parentBaton;
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        DirBaton pb = this.dirBaton;
        FileBaton fb = this.fileBaton = new FileBaton(path, pb, true);
        if (pb.skipChildren) {
            fb.skip = true;
            return;
        }
        fb.pristineProps = new SVNProperties();
        fb.rightSource = new SvnDiffSource(this.targetRevision);
        this.result.reset();
        this.callback.fileOpened(this.result, SVNFileUtil.createFilePath(fb.path), null, fb.rightSource, null, false, null);
        fb.skip = this.result.skip;
    }

    public void openFile(String path, long revision) throws SVNException {
        DirBaton pb = this.dirBaton;
        FileBaton fb = this.fileBaton = new FileBaton(path, pb, false);
        if (pb.skipChildren) {
            fb.skip = true;
            return;
        }
        fb.baseRevision = revision;
        fb.leftSource = new SvnDiffSource(this.revision);
        fb.rightSource = new SvnDiffSource(this.targetRevision);
        this.result.reset();
        this.callback.fileOpened(this.result, SVNFileUtil.createFilePath(fb.path), fb.leftSource, fb.rightSource, null, false, null);
        fb.skip = this.result.skip;
    }

    public void changeFileProperty(String path, String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        FileBaton fb = this.fileBaton;
        if (fb.skip) {
            return;
        }
        if (SVNProperty.isWorkingCopyProperty(propertyName)) {
            return;
        }
        if (SVNProperty.isRegularProperty(propertyName)) {
            fb.hasPropChanges = true;
        }
        fb.propChanges.put(propertyName, propertyValue);
    }

    public void closeFile(String path, String textChecksum) throws SVNException {
        FileBaton fb = this.fileBaton;
        if (fb.skip) {
            return;
        }
        if (textChecksum != null && this.textDeltas && fb.resultMd5Checksum != null && !textChecksum.equals(fb.resultMd5Checksum)) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''", (Object)fb.path);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        if (fb.added || fb.pathEndRevision != null || !this.textDeltas || fb.hasPropChanges) {
            if (!fb.added && fb.pristineProps == null) {
                this.getFileFromRa(fb, true);
            }
            String oldChecksum = fb.pristineProps.getStringValue("svn:entry:checksum");
            if (fb.pristineProps != null) {
                fb.propChanges = this.removeNonPropChanges(fb.pristineProps, fb.propChanges);
            }
            SVNProperties rightProps = new SVNProperties(fb.pristineProps);
            rightProps.putAll(fb.propChanges);
            rightProps.removeNullValues();
            if (fb.added) {
                this.result.reset();
                this.callback.fileAdded(this.result, SVNFileUtil.createFilePath(fb.path), null, fb.rightSource, null, fb.pathEndRevision, null, rightProps);
            } else {
                boolean fileModified;
                this.result.reset();
                boolean bl = fileModified = fb.pathEndRevision != null;
                if (textChecksum != null && oldChecksum != null) {
                    boolean bl2 = fileModified = !textChecksum.equals(oldChecksum);
                }
                if (fileModified && !this.textDeltas) {
                    fb.pathStartRevision = this.getEmptyFile();
                    fb.pathEndRevision = this.getEmptyFile();
                }
                this.callback.fileChanged(this.result, SVNFileUtil.createFilePath(fb.path), fb.leftSource, fb.rightSource, fb.pathEndRevision != null ? fb.pathStartRevision : null, fb.pathEndRevision, fb.pristineProps, rightProps, fileModified, fb.propChanges);
            }
        }
    }

    private File getEmptyFile() throws SVNException {
        return SVNFileUtil.createTempFile("", "");
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        return null;
    }

    public void abortEdit() throws SVNException {
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        FileBaton fb = this.fileBaton;
        if (fb.skip) {
            return;
        }
        if (!this.textDeltas) {
            fb.pathStartRevision = null;
            fb.pathEndRevision = null;
            return;
        }
        if (!fb.added) {
            this.getFileFromRa(fb, false);
        } else {
            fb.pathStartRevision = null;
        }
        if (baseChecksum != null && !fb.startMd5Checksum.equals(baseChecksum)) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Base checksum mismatch for ''{0}''", (Object)fb.path);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        if (fb.pathEndRevision == null) {
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            fb.pathEndRevision = SVNFileUtil.createUniqueFile(tmpDir, "svn", "tmp", false);
            this.tempFiles.add(fb.pathEndRevision);
        }
        if (fb.pathStartRevision == null) {
            this.deltaProcessor.applyTextDelta(SVNFileUtil.DUMMY_IN, fb.pathEndRevision, true);
        } else {
            this.deltaProcessor.applyTextDelta(fb.pathStartRevision, fb.pathEndRevision, true);
        }
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        if (!this.textDeltas) {
            return null;
        }
        return this.deltaProcessor.textDeltaChunk(diffWindow);
    }

    public void textDeltaEnd(String path) throws SVNException {
        if (!this.textDeltas) {
            return;
        }
        FileBaton fb = this.fileBaton;
        fb.resultMd5Checksum = this.deltaProcessor.textDeltaEnd();
    }

    public void cleanup() {
        for (File tempFile : this.tempFiles) {
            try {
                SVNFileUtil.deleteFile(tempFile);
            }
            catch (SVNException sVNException) {}
        }
    }

    private void diffDeletedFile(String path) throws SVNException {
        FileBaton fb = new FileBaton(path, this.dirBaton, false);
        boolean skip = false;
        SvnDiffSource leftSource = new SvnDiffSource(this.revision);
        this.result.reset();
        this.callback.fileOpened(this.result, SVNFileUtil.createFilePath(path), leftSource, null, null, false, null);
        skip = this.result.skip;
        if (skip) {
            return;
        }
        this.getFileFromRa(fb, !this.textDeltas);
        this.result.reset();
        this.callback.fileDeleted(this.result, SVNFileUtil.createFilePath(fb.path), leftSource, fb.pathStartRevision, fb.pristineProps);
    }

    private void diffDeletedDirectory(String path) throws SVNException {
        boolean skip = false;
        boolean skipChildren = false;
        SvnDiffSource leftSource = new SvnDiffSource(this.revision);
        DirBaton pb = this.dirBaton;
        DirBaton db = new DirBaton(path, pb, false, -1L);
        assert (SVNRevision.isValidRevisionNumber(this.revision));
        this.result.reset();
        this.callback.dirOpened(this.result, SVNFileUtil.createFilePath(path), leftSource, null, null, null);
        skip = this.result.skip;
        skipChildren = this.result.skipChildren;
        SVNProperties leftProps = new SVNProperties();
        ArrayList dirEntries = new ArrayList();
        if (!skip || !skipChildren) {
            this.repository.getDir(path, this.revision, skip ? null : leftProps, skipChildren ? null : dirEntries);
        }
        if (!skipChildren) {
            for (SVNDirEntry dirEntry : dirEntries) {
                String name = dirEntry.getName();
                String childPath = SVNPathUtil.append(path, name);
                if (dirEntry.getKind() == SVNNodeKind.FILE) {
                    this.diffDeletedFile(childPath);
                    continue;
                }
                if (dirEntry.getKind() != SVNNodeKind.DIR) continue;
                this.diffDeletedDirectory(childPath);
            }
        }
        if (!skip) {
            this.result.reset();
            this.callback.dirDeleted(this.result, SVNFileUtil.createFilePath(path), leftSource, leftProps, null);
        }
    }

    private SVNProperties removeNonPropChanges(SVNProperties pristineProps, SVNProperties changes) {
        SVNProperties newChanges = new SVNProperties();
        for (Map.Entry<String, SVNPropertyValue> entry : changes.asMap().entrySet()) {
            SVNPropertyValue oldValue;
            String name = entry.getKey();
            SVNPropertyValue value = entry.getValue();
            boolean remove = false;
            if (value != null && (oldValue = pristineProps.getSVNPropertyValue(name)) != null && oldValue.equals(value)) {
                remove = true;
            }
            if (remove) continue;
            newChanges.put(name, value);
        }
        return newChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFileFromRa(FileBaton fb, boolean propsOnly) throws SVNException {
        block4: {
            if (fb.pristineProps == null) {
                fb.pristineProps = new SVNProperties();
            }
            if (!propsOnly) {
                File tmpDir = new File(System.getProperty("java.io.tmpdir"));
                fb.pathStartRevision = SVNFileUtil.createUniqueFile(tmpDir, "svn", "tmp", false);
                this.tempFiles.add(fb.pathStartRevision);
                OutputStream outputStream = null;
                SVNChecksumOutputStream checksumOutputStream = null;
                try {
                    outputStream = SVNFileUtil.openFileForWriting(fb.pathStartRevision);
                    checksumOutputStream = new SVNChecksumOutputStream(outputStream, "MD5", false);
                    this.repository.getFile(fb.path, fb.baseRevision, fb.pristineProps, checksumOutputStream);
                    fb.startMd5Checksum = checksumOutputStream.getDigest();
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    SVNFileUtil.closeFile(checksumOutputStream);
                    SVNFileUtil.closeFile(outputStream);
                    throw throwable;
                }
                SVNFileUtil.closeFile(checksumOutputStream);
                SVNFileUtil.closeFile(outputStream);
                {
                    break block4;
                }
            }
            this.repository.getFile(fb.path, fb.baseRevision, fb.pristineProps, null);
        }
    }

    private class FileBaton {
        private boolean added;
        private boolean treeConflicted;
        private boolean skip;
        private String path;
        private File pathStartRevision;
        private SVNProperties pristineProps;
        private long baseRevision;
        private File pathEndRevision;
        private String startMd5Checksum;
        private String resultMd5Checksum;
        private SVNProperties propChanges;
        private boolean hasPropChanges;
        private SvnDiffSource leftSource;
        private SvnDiffSource rightSource;
        private DirBaton parentBaton;

        public FileBaton(String path, DirBaton parentBaton, boolean added) {
            this.path = path;
            this.parentBaton = parentBaton;
            this.added = added;
            this.propChanges = new SVNProperties();
            this.baseRevision = SvnNgRemoteDiffEditor2.this.revision;
        }
    }

    private static class DirBaton {
        private boolean added;
        private boolean treeConflicted;
        private boolean skip;
        private boolean skipChildren;
        private String path;
        private DirBaton parentBaton;
        private long baseRevision;
        private SvnDiffSource leftSource;
        private SvnDiffSource rightSource;
        public boolean hasPropChange;
        public SVNProperties propChanges;

        public DirBaton(String path, DirBaton parentBaton, boolean added, long baseRevision) {
            this.path = path;
            this.parentBaton = parentBaton;
            this.added = added;
            this.baseRevision = baseRevision;
            this.propChanges = new SVNProperties();
        }
    }
}

