/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.equinox.launching.internal;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.sisu.equinox.launching.EquinoxLauncher;
import org.eclipse.sisu.equinox.launching.EquinoxLaunchingException;
import org.eclipse.tycho.launching.LaunchConfiguration;

@Component(role=EquinoxLauncher.class)
public class DefaultEquinoxLauncher
implements EquinoxLauncher {
    @Requirement
    private Logger log;

    @Override
    public int execute(LaunchConfiguration configuration, int forkedProcessTimeoutInSeconds) throws EquinoxLaunchingException {
        Object executable = configuration.getJvmExecutable();
        if (executable == null || "".equals(executable)) {
            executable = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            if (File.separatorChar == '\\') {
                executable = (String)executable + ".exe";
            }
        }
        CommandLine cli = new CommandLine((String)executable);
        boolean handleQuotes = false;
        cli.addArguments(configuration.getVMArguments(), false);
        cli.addArguments(new String[]{"-jar", this.getCanonicalPath(configuration.getLauncherJar())}, false);
        cli.addArguments(configuration.getProgramArguments(), false);
        DefaultExecutor executor = new DefaultExecutor();
        ExecuteWatchdog watchdog = null;
        if (forkedProcessTimeoutInSeconds > 0) {
            long timeoutInMilliseconds = (long)forkedProcessTimeoutInSeconds * 1000L;
            cli.addArguments(new String[]{"-timeout ", String.valueOf(timeoutInMilliseconds)});
            watchdog = new ExecuteWatchdog(timeoutInMilliseconds);
            executor.setWatchdog(watchdog);
        }
        this.log.info("Command line:\n\t" + cli.toString());
        executor.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
        executor.setWorkingDirectory(configuration.getWorkingDirectory());
        try {
            return executor.execute(cli, DefaultEquinoxLauncher.getMergedEnvironment(configuration));
        }
        catch (ExecuteException e) {
            if (watchdog != null && watchdog.killedProcess()) {
                this.log.error("Timeout " + forkedProcessTimeoutInSeconds + " s exceeded. Process was killed.");
            }
            return e.getExitValue();
        }
        catch (IOException e) {
            throw new EquinoxLaunchingException(e);
        }
    }

    private static Map<String, String> getMergedEnvironment(LaunchConfiguration configuration) throws IOException {
        Map currentEnv = EnvironmentUtils.getProcEnvironment();
        currentEnv.putAll(configuration.getEnvironment());
        return currentEnv;
    }

    private String getCanonicalPath(File file) throws EquinoxLaunchingException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new EquinoxLaunchingException(e);
        }
    }
}

