/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.test.unit;

import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.test.MCTestCase;
import org.openjdk.jmc.common.unit.BinaryPrefix;
import org.openjdk.jmc.common.unit.BinaryScaleFactor;
import org.openjdk.jmc.common.unit.DecimalPrefix;
import org.openjdk.jmc.common.unit.DecimalScaleFactor;
import org.openjdk.jmc.common.unit.IScalarAffineTransform;
import org.openjdk.jmc.common.unit.ImpreciseScaleFactor;

public class TransformTest
extends MCTestCase {
    @Test
    public void testBinaryUnityEqualsDecimal() {
        BinaryScaleFactor bin1 = BinaryScaleFactor.get((int)0);
        DecimalScaleFactor dec1 = DecimalScaleFactor.get((int)0);
        Assert.assertTrue((boolean)bin1.isUnity());
        Assert.assertTrue((boolean)dec1.isUnity());
        Assert.assertEquals((Object)bin1, (Object)dec1);
        Assert.assertEquals((Object)dec1, (Object)bin1);
        Assert.assertEquals((long)bin1.hashCode(), (long)dec1.hashCode());
    }

    @Test
    public void testLinearScaling() {
        ImpreciseScaleFactor mmToM = new ImpreciseScaleFactor((Number)0.001);
        Assert.assertEquals((long)1L, (long)mmToM.targetValue(1000L));
    }

    public static void assertInRange(long value, IScalarAffineTransform factor) {
        Assert.assertFalse((String)("Out of range :" + factor.targetValue(value)), (boolean)factor.targetOutOfRange(value, Long.MAX_VALUE));
    }

    public static void assertInRange(double value, IScalarAffineTransform factor) {
        Assert.assertFalse((String)("Out of range :" + factor.targetValue(value)), (boolean)factor.targetOutOfRange(value, Long.MAX_VALUE));
    }

    public static void assertOutOfRange(long value, IScalarAffineTransform factor) {
        Assert.assertTrue((String)("Not out of range :" + factor.targetValue(value)), (boolean)factor.targetOutOfRange(value, Long.MAX_VALUE));
    }

    public static void assertOutOfRange(double value, IScalarAffineTransform factor) {
        Assert.assertTrue((String)("Not out of range :" + factor.targetValue(value)), (boolean)factor.targetOutOfRange(value, Long.MAX_VALUE));
    }

    public static void assertInIntRange(long value, IScalarAffineTransform factor) {
        Assert.assertFalse((String)("Out of range :" + factor.targetValue(value)), (boolean)factor.targetOutOfRange(value, Integer.MAX_VALUE));
    }

    public static void assertInIntRange(double value, IScalarAffineTransform factor) {
        Assert.assertFalse((String)("Out of range :" + factor.targetValue(value)), (boolean)factor.targetOutOfRange(value, Integer.MAX_VALUE));
    }

    public static void assertOutOfIntRange(long value, IScalarAffineTransform factor) {
        Assert.assertTrue((String)("Not out of range :" + factor.targetValue(value)), (boolean)factor.targetOutOfRange(value, Integer.MAX_VALUE));
    }

    public static void assertOutOfIntRange(double value, IScalarAffineTransform factor) {
        Assert.assertTrue((String)("Not out of range :" + factor.targetValue(value)), (boolean)factor.targetOutOfRange(value, Integer.MAX_VALUE));
    }

    @Test
    public void testBinaryTooHighLong() {
        BinaryScaleFactor factor = BinaryPrefix.YOBI.valueFactorTo(BinaryPrefix.KIBI);
        TransformTest.assertInRange(0L, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfRange(17L, (IScalarAffineTransform)factor);
        factor = BinaryPrefix.TEBI.valueFactorTo(BinaryPrefix.KIBI);
        TransformTest.assertInIntRange(1L, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(2L, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfIntRange(2L, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfIntRange(3L, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(0x100000000L, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(0x1FFFFFFFFL, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfRange(0x200000000L, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfRange(0x400000000L, (IScalarAffineTransform)factor);
        Assert.assertEquals((long)0x4000000000000000L, (long)factor.targetValue(0x100000000L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)factor.targetValue(0x200000000L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)factor.targetValue(0x400000000L));
    }

    @Test
    public void testBinaryTooHighDouble() {
        BinaryScaleFactor factor = BinaryPrefix.YOBI.valueFactorTo(BinaryPrefix.KIBI);
        TransformTest.assertInRange(0.0, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfRange(17.0, (IScalarAffineTransform)factor);
        factor = BinaryPrefix.TEBI.valueFactorTo(BinaryPrefix.KIBI);
        TransformTest.assertInIntRange(1.0, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(2.0, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfIntRange(2.0, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfIntRange(3.0, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(4.294967296E9, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(8.589934591E9, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfRange(8.589934592E9, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfRange(1.7179869184E10, (IScalarAffineTransform)factor);
        Assert.assertEquals((long)0x4000000000000000L, (long)((long)factor.targetValue(4.294967296E9)));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((long)factor.targetValue(8.589934592E9)));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((long)factor.targetValue(1.7179869184E10)));
    }

    @Test
    public void testBinaryTooLowLong() {
        BinaryScaleFactor factor = BinaryPrefix.YOBI.valueFactorTo(BinaryPrefix.KIBI);
        TransformTest.assertInRange(0L, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfRange(-17L, (IScalarAffineTransform)factor);
        factor = BinaryPrefix.TEBI.valueFactorTo(BinaryPrefix.KIBI);
        TransformTest.assertInIntRange(-1L, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(-2L, (IScalarAffineTransform)factor);
        TransformTest.assertInIntRange(-2L, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfIntRange(-3L, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(-4294967296L, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(-8589934592L, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfRange(-8589934593L, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfRange(-17179869184L, (IScalarAffineTransform)factor);
        Assert.assertEquals((long)-4611686018427387904L, (long)factor.targetValue(-4294967296L));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)factor.targetValue(-8589934592L));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)factor.targetValue(-17179869184L));
    }

    @Test
    public void testBinaryTooLowDouble() {
        BinaryScaleFactor factor = BinaryPrefix.YOBI.valueFactorTo(BinaryPrefix.KIBI);
        TransformTest.assertInRange(-0.0, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfRange(-17.0, (IScalarAffineTransform)factor);
        factor = BinaryPrefix.TEBI.valueFactorTo(BinaryPrefix.KIBI);
        TransformTest.assertInIntRange(-1.0, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(-2.0, (IScalarAffineTransform)factor);
        TransformTest.assertInIntRange(-2.0, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfIntRange(-3.0, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(-4.294967296E9, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(-8.589934592E9, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfRange(-8.589934593E9, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfRange(-1.7179869184E10, (IScalarAffineTransform)factor);
        Assert.assertEquals((long)-4611686018427387904L, (long)((long)factor.targetValue(-4.294967296E9)));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((long)factor.targetValue(-8.589934592E9)));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((long)factor.targetValue(-1.7179869184E10)));
    }

    @Test
    public void testBinaryNotTooHighLong() {
        BinaryScaleFactor factor = BinaryPrefix.EXBI.valueFactorTo(BinaryPrefix.KIBI);
        TransformTest.assertInRange(0L, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(17L, (IScalarAffineTransform)factor);
    }

    @Test
    public void testBinaryNotTooHighDouble() {
        BinaryScaleFactor factor = BinaryPrefix.EXBI.valueFactorTo(BinaryPrefix.KIBI);
        TransformTest.assertInRange(0.0, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(17.0, (IScalarAffineTransform)factor);
    }

    @Test
    public void testBinaryNotTooLowLong() {
        BinaryScaleFactor factor = BinaryPrefix.EXBI.valueFactorTo(BinaryPrefix.KIBI);
        TransformTest.assertInRange(0L, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(-17L, (IScalarAffineTransform)factor);
    }

    @Test
    public void testBinaryNotTooLowDouble() {
        BinaryScaleFactor factor = BinaryPrefix.EXBI.valueFactorTo(BinaryPrefix.KIBI);
        TransformTest.assertInRange(-0.0, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(-17.0, (IScalarAffineTransform)factor);
    }

    @Test
    public void testBinaryPrecisionLong() {
        BinaryScaleFactor factor = BinaryPrefix.NOBI.valueFactorTo(BinaryPrefix.KIBI);
        TransformTest.assertInRange(0L, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(1023L, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(1024L, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(1025L, (IScalarAffineTransform)factor);
        TransformTest.assertInIntRange(1023L, (IScalarAffineTransform)factor);
        TransformTest.assertInIntRange(1024L, (IScalarAffineTransform)factor);
        TransformTest.assertInIntRange(1025L, (IScalarAffineTransform)factor);
    }

    @Test
    public void testBinaryPrecisionNegativeLong() {
        BinaryScaleFactor factor = BinaryPrefix.NOBI.valueFactorTo(BinaryPrefix.KIBI);
        TransformTest.assertInRange(0L, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(-1023L, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(-1024L, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(-1025L, (IScalarAffineTransform)factor);
        TransformTest.assertInIntRange(-1023L, (IScalarAffineTransform)factor);
        TransformTest.assertInIntRange(-1024L, (IScalarAffineTransform)factor);
        TransformTest.assertInIntRange(-1025L, (IScalarAffineTransform)factor);
    }

    @Test
    public void testBinaryPrecisionDouble() {
        BinaryScaleFactor factor = BinaryPrefix.NOBI.valueFactorTo(BinaryPrefix.KIBI);
        TransformTest.assertInRange(0.0, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(1023.0, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(1024.0, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(1025.0, (IScalarAffineTransform)factor);
        TransformTest.assertInIntRange(1023.0, (IScalarAffineTransform)factor);
        TransformTest.assertInIntRange(1024.0, (IScalarAffineTransform)factor);
        TransformTest.assertInIntRange(1025.0, (IScalarAffineTransform)factor);
    }

    @Test
    public void testBinaryPrecisionNegativeDouble() {
        BinaryScaleFactor factor = BinaryPrefix.NOBI.valueFactorTo(BinaryPrefix.KIBI);
        TransformTest.assertInRange(-0.0, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(-1023.0, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(-1024.0, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(-1025.0, (IScalarAffineTransform)factor);
        TransformTest.assertInIntRange(-1023.0, (IScalarAffineTransform)factor);
        TransformTest.assertInIntRange(-1024.0, (IScalarAffineTransform)factor);
        TransformTest.assertInIntRange(-1025.0, (IScalarAffineTransform)factor);
    }

    @Test
    public void testDecimalTooHighLong() {
        DecimalScaleFactor factor = DecimalPrefix.YOTTA.valueFactorTo(DecimalPrefix.KILO);
        TransformTest.assertInRange(0L, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfRange(17L, (IScalarAffineTransform)factor);
    }

    @Test
    public void testDecimalTooHighDouble() {
        DecimalScaleFactor factor = DecimalPrefix.YOTTA.valueFactorTo(DecimalPrefix.KILO);
        TransformTest.assertInRange(0.0, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfRange(17.0, (IScalarAffineTransform)factor);
    }

    @Test
    public void testDecimalTooLowLong() {
        DecimalScaleFactor factor = DecimalPrefix.YOTTA.valueFactorTo(DecimalPrefix.KILO);
        TransformTest.assertInRange(0L, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfRange(-17L, (IScalarAffineTransform)factor);
    }

    @Test
    public void testDecimalTooLowDouble() {
        DecimalScaleFactor factor = DecimalPrefix.YOTTA.valueFactorTo(DecimalPrefix.KILO);
        TransformTest.assertInRange(-0.0, (IScalarAffineTransform)factor);
        TransformTest.assertOutOfRange(-17.0, (IScalarAffineTransform)factor);
    }

    @Test
    public void testDecimalNotTooHighLong() {
        DecimalScaleFactor factor = DecimalPrefix.EXA.valueFactorTo(DecimalPrefix.KILO);
        TransformTest.assertInRange(0L, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(17L, (IScalarAffineTransform)factor);
    }

    @Test
    public void testDecimalNotTooHighDouble() {
        DecimalScaleFactor factor = DecimalPrefix.EXA.valueFactorTo(DecimalPrefix.KILO);
        TransformTest.assertInRange(0.0, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(17.0, (IScalarAffineTransform)factor);
    }

    @Test
    public void testDecimalNotTooLowLong() {
        DecimalScaleFactor factor = DecimalPrefix.EXA.valueFactorTo(DecimalPrefix.KILO);
        TransformTest.assertInRange(0L, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(-17L, (IScalarAffineTransform)factor);
    }

    @Test
    public void testDecimalNotTooLowDouble() {
        DecimalScaleFactor factor = DecimalPrefix.EXA.valueFactorTo(DecimalPrefix.KILO);
        TransformTest.assertInRange(-0.0, (IScalarAffineTransform)factor);
        TransformTest.assertInRange(-17.0, (IScalarAffineTransform)factor);
    }

    @Test
    public void testBinaryRounding() {
        BinaryScaleFactor factor = BinaryPrefix.NOBI.valueFactorTo(BinaryPrefix.KIBI);
        Assert.assertEquals((long)0L, (long)factor.targetValue(511L));
        Assert.assertEquals((long)1L, (long)factor.targetValue(512L));
        Assert.assertEquals((long)1L, (long)factor.targetValue(513L));
        Assert.assertEquals((long)1L, (long)factor.targetValue(1023L));
        Assert.assertEquals((long)1L, (long)factor.targetValue(1024L));
        Assert.assertEquals((long)1L, (long)factor.targetValue(1025L));
        Assert.assertEquals((long)0L, (long)factor.targetValue(-511L));
        Assert.assertEquals((long)0L, (long)factor.targetValue(-512L));
        Assert.assertEquals((long)-1L, (long)factor.targetValue(-513L));
        Assert.assertEquals((long)-1L, (long)factor.targetValue(-1023L));
        Assert.assertEquals((long)-1L, (long)factor.targetValue(-1024L));
        Assert.assertEquals((long)-1L, (long)factor.targetValue(-1025L));
    }

    @Test
    public void testBinaryFlooring() {
        BinaryScaleFactor factor = BinaryPrefix.NOBI.valueFactorTo(BinaryPrefix.KIBI);
        Assert.assertEquals((long)0L, (long)factor.targetFloor(511L));
        Assert.assertEquals((long)0L, (long)factor.targetFloor(512L));
        Assert.assertEquals((long)0L, (long)factor.targetFloor(513L));
        Assert.assertEquals((long)0L, (long)factor.targetFloor(1023L));
        Assert.assertEquals((long)1L, (long)factor.targetFloor(1024L));
        Assert.assertEquals((long)1L, (long)factor.targetFloor(1025L));
        Assert.assertEquals((long)-1L, (long)factor.targetFloor(-511L));
        Assert.assertEquals((long)-1L, (long)factor.targetFloor(-512L));
        Assert.assertEquals((long)-1L, (long)factor.targetFloor(-513L));
        Assert.assertEquals((long)-1L, (long)factor.targetFloor(-1023L));
        Assert.assertEquals((long)-1L, (long)factor.targetFloor(-1024L));
        Assert.assertEquals((long)-2L, (long)factor.targetFloor(-1025L));
    }

    @Test
    public void testDecimalRounding() {
        DecimalScaleFactor factor = DecimalPrefix.NONE.valueFactorTo(DecimalPrefix.KILO);
        Assert.assertEquals((long)0L, (long)factor.targetValue(499L));
        Assert.assertEquals((long)1L, (long)factor.targetValue(500L));
        Assert.assertEquals((long)1L, (long)factor.targetValue(501L));
        Assert.assertEquals((long)1L, (long)factor.targetValue(999L));
        Assert.assertEquals((long)1L, (long)factor.targetValue(1000L));
        Assert.assertEquals((long)1L, (long)factor.targetValue(1001L));
        Assert.assertEquals((long)0L, (long)factor.targetValue(-499L));
        Assert.assertEquals((long)0L, (long)factor.targetValue(-500L));
        Assert.assertEquals((long)-1L, (long)factor.targetValue(-501L));
        Assert.assertEquals((long)-1L, (long)factor.targetValue(-999L));
        Assert.assertEquals((long)-1L, (long)factor.targetValue(-1000L));
        Assert.assertEquals((long)-1L, (long)factor.targetValue(-1001L));
    }

    @Test
    public void testDecimalFlooring() {
        DecimalScaleFactor factor = DecimalPrefix.NONE.valueFactorTo(DecimalPrefix.KILO);
        Assert.assertEquals((long)0L, (long)factor.targetFloor(499L));
        Assert.assertEquals((long)0L, (long)factor.targetFloor(500L));
        Assert.assertEquals((long)0L, (long)factor.targetFloor(501L));
        Assert.assertEquals((long)0L, (long)factor.targetFloor(999L));
        Assert.assertEquals((long)1L, (long)factor.targetFloor(1000L));
        Assert.assertEquals((long)1L, (long)factor.targetFloor(1001L));
        Assert.assertEquals((long)-1L, (long)factor.targetFloor(-499L));
        Assert.assertEquals((long)-1L, (long)factor.targetFloor(-500L));
        Assert.assertEquals((long)-1L, (long)factor.targetFloor(-501L));
        Assert.assertEquals((long)-1L, (long)factor.targetFloor(-999L));
        Assert.assertEquals((long)-1L, (long)factor.targetFloor(-1000L));
        Assert.assertEquals((long)-2L, (long)factor.targetFloor(-1001L));
    }
}

