/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.collection;

import java.util.Collection;
import java.util.Collections;
import org.sonatype.aether.RepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsolvableVersionConflictException
extends RepositoryException {
    private final Object dependencyConflictId;
    private final Collection<String> versions;

    public UnsolvableVersionConflictException(Object dependencyConflictId, Collection<String> versions) {
        super("Could not resolve version conflict for " + dependencyConflictId + " with requested versions " + UnsolvableVersionConflictException.toList(versions));
        this.dependencyConflictId = dependencyConflictId != null ? dependencyConflictId : "";
        this.versions = versions != null ? versions : Collections.emptyList();
    }

    private static String toList(Collection<String> versions) {
        StringBuilder buffer = new StringBuilder(256);
        if (versions != null) {
            for (String version : versions) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append(version);
            }
        }
        return buffer.toString();
    }

    public Object getDependencyConflictId() {
        return this.dependencyConflictId;
    }

    public Collection<String> getVersions() {
        return this.versions;
    }
}

