/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.maven.plugin.surefire.report.PrettyPrintXMLWriter;
import org.apache.maven.plugin.surefire.report.ReportEntryType;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.plugin.surefire.report.plexus.util.xml.Xpp3Dom;
import org.apache.maven.plugin.surefire.report.plexus.util.xml.Xpp3DomWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.SafeThrowable;
import org.codehaus.plexus.util.IOUtil;

public class StatelessXmlReporter {
    private static final String LS = System.getProperty("line.separator");
    private final File reportsDirectory;
    private final String reportNameSuffix;
    private final boolean trimStackTrace;

    public StatelessXmlReporter(File reportsDirectory, String reportNameSuffix, boolean trimStackTrace) {
        this.reportsDirectory = reportsDirectory;
        this.reportNameSuffix = reportNameSuffix;
        this.trimStackTrace = trimStackTrace;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSetCompleted(WrappedReportEntry testSetReportEntry, TestSetStats testSetStats) throws ReporterException {
        Xpp3Dom testSuite = StatelessXmlReporter.createTestSuiteElement(testSetReportEntry, testSetStats, this.reportNameSuffix);
        this.showProperties(testSuite);
        testSuite.setAttribute("tests", String.valueOf(testSetStats.getCompletedCount()));
        testSuite.setAttribute("errors", String.valueOf(testSetStats.getErrors()));
        testSuite.setAttribute("skipped", String.valueOf(testSetStats.getSkipped()));
        testSuite.setAttribute("failures", String.valueOf(testSetStats.getFailures()));
        for (WrappedReportEntry entry : testSetStats.getReportEntries()) {
            if (ReportEntryType.success.equals((Object)entry.getReportEntryType())) {
                testSuite.addChild(StatelessXmlReporter.createTestElement(entry, this.reportNameSuffix));
                continue;
            }
            testSuite.addChild(this.getTestProblems(entry, this.trimStackTrace, this.reportNameSuffix));
        }
        File reportFile = this.getReportFile(testSetReportEntry, this.reportsDirectory, this.reportNameSuffix);
        File reportDir = reportFile.getParentFile();
        reportDir.mkdirs();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile), "UTF-8")));
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + LS);
            Xpp3DomWriter.write(new PrettyPrintXMLWriter(writer), testSuite);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new ReporterException("Unable to use UTF-8 encoding", (Exception)e);
                catch (FileNotFoundException e2) {
                    throw new ReporterException("Unable to create file: " + e2.getMessage(), (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close(writer);
    }

    private File getReportFile(ReportEntry report, File reportsDirectory, String reportNameSuffix) {
        File reportFile = reportNameSuffix != null && reportNameSuffix.length() > 0 ? new File(reportsDirectory, "TEST-" + report.getName() + "-" + reportNameSuffix + ".xml") : new File(reportsDirectory, "TEST-" + report.getName() + ".xml");
        return reportFile;
    }

    private static Xpp3Dom createTestElement(WrappedReportEntry report, String reportNameSuffix) {
        Xpp3Dom testCase = new Xpp3Dom("testcase");
        testCase.setAttribute("name", report.getReportName());
        if (report.getGroup() != null) {
            testCase.setAttribute("group", report.getGroup());
        }
        if (report.getSourceName() != null) {
            if (reportNameSuffix != null && reportNameSuffix.length() > 0) {
                testCase.setAttribute("classname", report.getSourceName() + "(" + reportNameSuffix + ")");
            } else {
                testCase.setAttribute("classname", report.getSourceName());
            }
        }
        testCase.setAttribute("time", report.elapsedTimeAsString());
        return testCase;
    }

    private static Xpp3Dom createTestSuiteElement(WrappedReportEntry report, TestSetStats testSetStats, String reportNameSuffix1) {
        Xpp3Dom testCase = new Xpp3Dom("testsuite");
        testCase.setAttribute("name", report.getReportName(reportNameSuffix1));
        if (report.getGroup() != null) {
            testCase.setAttribute("group", report.getGroup());
        }
        testCase.setAttribute("time", testSetStats.getElapsedForTestSet());
        return testCase;
    }

    private Xpp3Dom getTestProblems(WrappedReportEntry report, boolean trimStackTrace, String reportNameSuffix) {
        SafeThrowable t;
        Xpp3Dom testCase = StatelessXmlReporter.createTestElement(report, reportNameSuffix);
        Xpp3Dom element = this.createElement(testCase, report.getReportEntryType().name());
        String stackTrace = report.getStackTrace(trimStackTrace);
        if (report.getMessage() != null && report.getMessage().length() > 0) {
            element.setAttribute("message", report.getMessage());
        }
        if (report.getStackTraceWriter() != null && (t = report.getStackTraceWriter().getThrowable()) != null) {
            if (t.getMessage() != null) {
                element.setAttribute("type", stackTrace.contains(":") ? stackTrace.substring(0, stackTrace.indexOf(":")) : stackTrace);
            } else {
                element.setAttribute("type", new StringTokenizer(stackTrace).nextToken());
            }
        }
        if (stackTrace != null) {
            element.setValue(stackTrace);
        }
        this.addOutputStreamElement(report.getStdout(), "system-out", testCase);
        this.addOutputStreamElement(report.getStdErr(), "system-err", testCase);
        return testCase;
    }

    private void addOutputStreamElement(String stdOut, String name, Xpp3Dom testCase) {
        if (stdOut != null && stdOut.trim().length() > 0) {
            this.createElement(testCase, name).setValue(stdOut);
        }
    }

    private Xpp3Dom createElement(Xpp3Dom element, String name) {
        Xpp3Dom component = new Xpp3Dom(name);
        element.addChild(component);
        return component;
    }

    private void showProperties(Xpp3Dom testSuite) {
        Xpp3Dom properties = this.createElement(testSuite, "properties");
        Properties systemProperties = System.getProperties();
        if (systemProperties != null) {
            Enumeration<?> propertyKeys = systemProperties.propertyNames();
            while (propertyKeys.hasMoreElements()) {
                String key = (String)propertyKeys.nextElement();
                String value = systemProperties.getProperty(key);
                if (value == null) {
                    value = "null";
                }
                Xpp3Dom property = this.createElement(properties, "property");
                property.setAttribute("name", key);
                property.setAttribute("value", value);
            }
        }
    }
}

