/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.resources;

public interface StringComparePolicy {
    public static final StringComparePolicy EXACT = new ComparePolicy(true, true);
    public static final StringComparePolicy SUBSTRING = new ComparePolicy(false, true);

    public boolean compare(String var1, String var2);

    public static class ComparePolicy
    implements StringComparePolicy {
        boolean ce;
        boolean cc;

        public ComparePolicy(boolean ce, boolean cc) {
            this.cc = cc;
            this.ce = ce;
        }

        @Override
        public boolean compare(String golden, String value) {
            String v;
            String g;
            if (value == null) {
                return golden == null;
            }
            if (golden == null) {
                return !this.ce;
            }
            if (this.cc) {
                g = golden;
                v = value;
            } else {
                g = golden.toUpperCase();
                v = value.toUpperCase();
            }
            if (this.ce) {
                return v.equals(g);
            }
            return v.contains(g);
        }

        public String toString() {
            return "case " + (!this.cc ? "in" : "") + "sensitive" + (!this.ce ? " as substring" : "");
        }
    }
}

