/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.image.pixel;

import org.jemmy.Dimension;
import org.jemmy.image.Image;
import org.jemmy.image.ImageComparator;

public abstract class ResizeComparator
implements ImageComparator {
    private ImageComparator subComparator;
    private Mode mode;

    public ResizeComparator(ImageComparator subComparator, Mode mode) {
        this.subComparator = subComparator;
        this.mode = mode;
    }

    public ResizeComparator(ImageComparator subComparator) {
        this(subComparator, Mode.MAX);
    }

    public ImageComparator getSubComparator() {
        return this.subComparator;
    }

    public void setSubComparator(ImageComparator subComparator) {
        this.subComparator = subComparator;
    }

    @Override
    public Image compare(Image image1, Image image2) {
        Dimension size;
        if (image1 == null || image2 == null) {
            return image1 == null ? image2 : image1;
        }
        switch (this.mode) {
            case LEFT: {
                size = this.getSize(image1);
                break;
            }
            case RIGTH: {
                size = this.getSize(image2);
                break;
            }
            case MAX: {
                Dimension size1 = this.getSize(image1);
                Dimension size2 = this.getSize(image2);
                size = new Dimension(Math.max(size1.width, size2.width), Math.max(size1.height, size2.height));
                break;
            }
            default: {
                throw new IllegalStateException("mode is not recognized");
            }
        }
        Image r1 = this.resize(image1, size);
        Image r2 = this.resize(image2, size);
        if (r1 == null) {
            return image1;
        }
        if (r2 == null) {
            return image2;
        }
        return this.subComparator.compare(r1, r2);
    }

    public abstract Image resize(Image var1, Dimension var2);

    public abstract Dimension getSize(Image var1);

    @Override
    public String getID() {
        return ResizeComparator.class.getName() + "(" + this.subComparator.getID() + ")";
    }

    public static enum Mode {
        LEFT,
        RIGTH,
        MAX;

    }
}

