/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.control;

import java.util.HashMap;
import org.jemmy.JemmyException;
import org.jemmy.control.AbstractWrapper;
import org.jemmy.control.Wrap;
import org.jemmy.env.Environment;

public class LazyWrapper
extends AbstractWrapper {
    private final HashMap<String, String> theWrappers = new HashMap();
    private final ClassLoader loader;

    public LazyWrapper(ClassLoader loader, Environment env) {
        super(env);
        this.loader = loader;
    }

    public <P> void add(String controlClass, String wrapperClass) {
        this.theWrappers.put(controlClass, wrapperClass);
    }

    @Override
    protected Class<Wrap> getWrapClass(Class controlClass) {
        String wrapClassName = this.theWrappers.get(controlClass.getName());
        if (wrapClassName == null) {
            return null;
        }
        try {
            return this.loader.loadClass(wrapClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new JemmyException("Unable to load wrap for " + controlClass.getName() + " which is " + wrapClassName, ex);
        }
    }
}

