/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy;

import java.io.Serializable;
import org.jemmy.Vector;

public class Point
implements Serializable {
    public int x;
    public int y;
    private static final long serialVersionUID = -5276940640259749850L;

    public Point() {
        this(0, 0);
    }

    public Point(Point p) {
        this(p.x, p.y);
    }

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Point(double x, double y) {
        this.x = (int)Math.round(x);
        this.y = (int)Math.round(y);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public Point setLocation(Point p) {
        this.setLocation(p.x, p.y);
        return this;
    }

    public Point setLocation(int x, int y) {
        this.move(x, y);
        return this;
    }

    public Point setLocation(double x, double y) {
        this.x = (int)Math.round(x);
        this.y = (int)Math.round(y);
        return this;
    }

    public Point move(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Point translate(int dx, int dy) {
        this.x += dx;
        this.y += dy;
        return this;
    }

    public Point translate(Vector v) {
        this.x = (int)Math.round((double)this.x + v.getX());
        this.y = (int)Math.round((double)this.y + v.getY());
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Point) {
            Point pt = (Point)obj;
            return this.x == pt.x && this.y == pt.y;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.x;
        hash = 89 * hash + this.y;
        return hash;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + "]";
    }
}

