/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import com.google.inject.ProvisionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.sonatype.guice.bean.inject.BeanListener;
import org.sonatype.guice.bean.inject.PropertyBinding;
import org.sonatype.guice.bean.reflect.BeanProperty;
import org.sonatype.guice.plexus.binders.PlexusBeanManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PlexusLifecycleManager
implements PlexusBeanManager {
    private static final ThreadLocal<List<Object>> lifecycleBeans = new ThreadLocal<List<Object>>(){

        @Override
        protected List<Object> initialValue() {
            return new ArrayList<Object>(4);
        }
    };
    private final List<Startable> startableBeans = Collections.synchronizedList(new ArrayList());
    private final List<Disposable> disposableBeans = Collections.synchronizedList(new ArrayList());
    private final AtomicInteger numDeferredBeans = new AtomicInteger();
    private final MutablePlexusContainer container;
    private final Context context;
    List<ILoggerFactory> loggerFactories;

    PlexusLifecycleManager(MutablePlexusContainer container, Context context) {
        this.container = container;
        this.context = context;
        try {
            this.loggerFactories = container.lookupList(ILoggerFactory.class);
        }
        catch (Throwable e) {
            this.loggerFactories = Collections.emptyList();
        }
    }

    @Override
    public boolean manage(Class<?> clazz) {
        return true;
    }

    public PropertyBinding manage(final BeanProperty property) {
        Class clazz = property.getType().getRawType();
        if ("org.slf4j.Logger".equals(clazz.getName())) {
            return new PropertyBinding(){

                public <B> void injectProperty(B bean) {
                    String name = bean.getClass().getName();
                    Iterator<ILoggerFactory> itr = PlexusLifecycleManager.this.loggerFactories.iterator();
                    if (itr.hasNext()) {
                        property.set(bean, (Object)itr.next().getLogger(name));
                    } else {
                        property.set(bean, (Object)LoggerFactory.getILoggerFactory().getLogger(name));
                    }
                }
            };
        }
        if (Logger.class.equals((Object)clazz)) {
            return new PropertyBinding(){

                public <B> void injectProperty(B bean) {
                    property.set(bean, (Object)PlexusLifecycleManager.this.getPlexusLogger(bean));
                }
            };
        }
        return null;
    }

    @Override
    public boolean manage(Object bean) {
        if (bean instanceof Disposable) {
            this.disposableBeans.add((Disposable)bean);
        }
        if (bean instanceof LogEnabled) {
            ((LogEnabled)bean).enableLogging(this.getPlexusLogger(bean));
        }
        if (this.numDeferredBeans.get() > 0 && !BeanListener.isInjecting()) {
            this.manageDeferredLifecycles();
        }
        if (bean instanceof Contextualizable || bean instanceof Initializable || bean instanceof Startable) {
            if (BeanListener.isInjecting()) {
                this.deferLifecycle(bean);
            } else {
                this.manageLifecycle(bean);
            }
        }
        return true;
    }

    @Override
    public synchronized boolean unmanage(Object bean) {
        if (this.startableBeans.remove(bean)) {
            this.stop((Startable)bean);
        }
        if (this.disposableBeans.remove(bean)) {
            this.dispose((Disposable)bean);
        }
        return true;
    }

    @Override
    public synchronized boolean unmanage() {
        while (!this.startableBeans.isEmpty()) {
            this.stop(this.startableBeans.remove(this.startableBeans.size() - 1));
        }
        while (!this.disposableBeans.isEmpty()) {
            this.dispose(this.disposableBeans.remove(this.disposableBeans.size() - 1));
        }
        return true;
    }

    public PlexusBeanManager manageChild() {
        return this;
    }

    Logger getPlexusLogger(Object bean) {
        return this.container.getLoggerManager().getLoggerForComponent(bean.getClass().getName(), null);
    }

    private void deferLifecycle(Object bean) {
        lifecycleBeans.get().add(bean);
        this.numDeferredBeans.incrementAndGet();
    }

    private void manageDeferredLifecycles() {
        ArrayList beans = new ArrayList(lifecycleBeans.get());
        this.numDeferredBeans.addAndGet(-beans.size());
        lifecycleBeans.remove();
        for (Object bean : beans) {
            this.manageLifecycle(bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageLifecycle(Object bean) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            for (Class<?> clazz = bean.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                ClassLoader loader = clazz.getClassLoader();
                if (!(loader instanceof ClassRealm)) continue;
                Thread.currentThread().setContextClassLoader(loader);
                break;
            }
            if (bean instanceof Contextualizable) {
                this.contextualize((Contextualizable)bean);
            }
            if (bean instanceof Initializable) {
                this.initialize((Initializable)bean);
            }
            if (bean instanceof Startable) {
                Startable startableBean = (Startable)bean;
                this.startableBeans.add(startableBean);
                this.start(startableBean);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private void contextualize(Contextualizable bean) {
        try {
            bean.contextualize(this.context);
        }
        catch (Throwable e) {
            String message = "Error contextualizing: " + bean.getClass();
            this.warn(message, e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ProvisionException(message, e);
        }
    }

    private void initialize(Initializable bean) {
        try {
            bean.initialize();
        }
        catch (Throwable e) {
            String message = "Error initializing: " + bean.getClass();
            this.warn(message, e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ProvisionException(message, e);
        }
    }

    private void start(Startable bean) {
        try {
            bean.start();
        }
        catch (Throwable e) {
            String message = "Error starting: " + bean.getClass();
            this.warn(message, e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ProvisionException(message, e);
        }
    }

    private void stop(Startable bean) {
        try {
            bean.stop();
        }
        catch (Throwable e) {
            this.warn("Problem stopping: " + bean.getClass(), e);
        }
    }

    private void dispose(Disposable bean) {
        try {
            bean.dispose();
        }
        catch (Throwable e) {
            this.warn("Problem disposing: " + bean.getClass(), e);
        }
    }

    private void warn(String message, Throwable cause) {
        try {
            this.container.getLogger().warn(message, cause);
        }
        catch (Throwable ignore) {
            System.err.println(message);
            cause.printStackTrace();
        }
    }
}

