/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.artifacts.TargetPlatformFilter;
import org.eclipse.tycho.core.DependencyResolverConfiguration;
import org.eclipse.tycho.core.resolver.shared.IncludeSourceMode;
import org.eclipse.tycho.core.resolver.shared.OptionalResolutionAction;
import org.eclipse.tycho.core.shared.TargetEnvironment;

public class TargetPlatformConfiguration
implements DependencyResolverConfiguration {
    private String resolver;
    private List<TargetEnvironment> environments = new ArrayList<TargetEnvironment>();
    private boolean implicitTargetEnvironment = true;
    private final List<File> targets = new ArrayList<File>();
    private IncludeSourceMode targetDefinitionIncludeSourceMode = IncludeSourceMode.honor;
    private PomDependencies pomDependencies = PomDependencies.ignore;
    private Boolean allowConflictingDependencies;
    private String executionEnvironment;
    private String executionEnvironmentDefault;
    private BREEHeaderSelectionPolicy breeHeaderSelectionPolicy = BREEHeaderSelectionPolicy.first;
    private boolean resolveWithEEConstraints = true;
    private List<TargetPlatformFilter> filters;
    private OptionalResolutionAction optionalAction = OptionalResolutionAction.REQUIRE;
    private final List<ArtifactKey> extraRequirements = new ArrayList<ArtifactKey>();
    private boolean includePackedArtifacts;
    private Map<String, String> resolverProfileProperties = new HashMap<String, String>();

    public List<TargetEnvironment> getEnvironments() {
        return this.environments;
    }

    public String getTargetPlatformResolver() {
        return this.resolver;
    }

    public List<File> getTargets() {
        return Collections.unmodifiableList(this.targets);
    }

    public void addEnvironment(TargetEnvironment environment) {
        this.environments.add(environment);
    }

    public void setResolver(String resolver) {
        this.resolver = resolver;
    }

    public void addTarget(File target) {
        this.targets.add(target);
    }

    public IncludeSourceMode getTargetDefinitionIncludeSourceMode() {
        return this.targetDefinitionIncludeSourceMode;
    }

    public void setTargetDefinitionIncludeSourceMode(IncludeSourceMode includeSourcesMode) {
        this.targetDefinitionIncludeSourceMode = includeSourcesMode;
    }

    public void setPomDependencies(PomDependencies pomDependencies) {
        this.pomDependencies = pomDependencies;
    }

    public PomDependencies getPomDependencies() {
        return this.pomDependencies;
    }

    public boolean isImplicitTargetEnvironment() {
        return this.implicitTargetEnvironment;
    }

    public void setImplicitTargetEnvironment(boolean implicitTargetEnvironment) {
        this.implicitTargetEnvironment = implicitTargetEnvironment;
    }

    public void setAllowConflictingDependencies(Boolean allow) {
        this.allowConflictingDependencies = allow;
    }

    public Boolean getAllowConflictingDependencies() {
        return this.allowConflictingDependencies;
    }

    public String getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public void setExecutionEnvironment(String executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
    }

    public String getExecutionEnvironmentDefault() {
        return this.executionEnvironmentDefault;
    }

    public void setExecutionEnvironmentDefault(String executionEnvironment) {
        this.executionEnvironmentDefault = executionEnvironment;
    }

    public BREEHeaderSelectionPolicy getBREEHeaderSelectionPolicy() {
        return this.breeHeaderSelectionPolicy;
    }

    public void setBREEHeaderSelectionPolicy(BREEHeaderSelectionPolicy breeHeaderSelectionPolicy) {
        this.breeHeaderSelectionPolicy = breeHeaderSelectionPolicy;
    }

    public boolean isResolveWithEEConstraints() {
        return this.resolveWithEEConstraints;
    }

    public void setResolveWithEEContraints(boolean value) {
        this.resolveWithEEConstraints = value;
    }

    public void setFilters(List<TargetPlatformFilter> filters) {
        this.filters = filters;
    }

    public List<TargetPlatformFilter> getFilters() {
        if (this.filters == null) {
            return Collections.emptyList();
        }
        return this.filters;
    }

    public DependencyResolverConfiguration getDependencyResolverConfiguration() {
        return this;
    }

    @Override
    public List<ArtifactKey> getExtraRequirements() {
        return this.extraRequirements;
    }

    @Override
    public OptionalResolutionAction getOptionalResolutionAction() {
        return this.optionalAction;
    }

    public void addExtraRequirement(ArtifactKey requirement) {
        this.extraRequirements.add(requirement);
    }

    public void setOptionalResolutionAction(OptionalResolutionAction optionalAction) {
        this.optionalAction = optionalAction;
    }

    public void setIncludePackedArtifacts(boolean include) {
        this.includePackedArtifacts = include;
    }

    public boolean isIncludePackedArtifacts() {
        return this.includePackedArtifacts;
    }

    public Map<String, String> getProfileProperties() {
        return this.resolverProfileProperties;
    }

    public void addProfileProperty(String key, String value) {
        this.resolverProfileProperties.put(key, value);
    }

    public static enum PomDependencies {
        ignore,
        consider,
        wrapAsBundle;

    }

    public static enum BREEHeaderSelectionPolicy {
        first,
        minimal;

    }
}

