/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jemmy.TimeoutExpiredException;
import org.jemmy.action.GetAction;
import org.jemmy.control.Wrap;
import org.jemmy.env.Timeout;
import org.jemmy.input.StringTree;
import org.jemmy.interfaces.Focusable;
import org.jemmy.interfaces.Keyboard;
import org.jemmy.interfaces.Modifier;
import org.jemmy.interfaces.TreeSelector;
import org.jemmy.lookup.LookupCriteria;
import org.jemmy.resources.StringComparePolicy;
import org.jemmy.swt.ItemWrap;
import org.jemmy.swt.Shells;
import org.jemmy.swt.TreeWrap;
import org.jemmy.swt.lookup.ByItemStringsLookup;
import org.jemmy.timing.State;

public class SWTTree
extends StringTree<TreeItem> {
    public static final Timeout WAIT_NODE_TIMEOUT = new Timeout(SWTTree.class.getName() + ".wait.node.timeout", 1000L);
    public static final Timeout WAIT_NODE_EXPANDED_TIMEOUT = new Timeout(SWTTree.class.getName() + ".wait.node.expanded.timeout", 100L);
    public static final Timeout AFTER_MOVE_SLEEP = new Timeout(SWTTree.class.getName() + ".after.move.sleep.timeout", 100L);
    public static final String EXPAND_BUTTON_PROP = SWTTree.class.getName() + ".expand.button";
    public static final String EXPAND_MODIFIER_PROP = SWTTree.class.getName() + ".expand.modifier";
    private static final int MAX_MOVE_TRIES = 5;
    final TreeWrap<? extends Tree> owner;
    SWTTreeSelector selector = null;
    private final Keyboard.KeyboardButton expandButton;
    private final Keyboard.KeyboardModifier[] expandModifier;

    public SWTTree(TreeWrap<? extends Tree> owner) {
        super(owner.getEnvironment());
        this.owner = owner;
        Keyboard.KeyboardButtons defaultExpandButton = System.getProperty("os.name").contains("Linux") ? Keyboard.KeyboardButtons.ADD : Keyboard.KeyboardButtons.RIGHT;
        Keyboard.KeyboardModifier[] defaultExpandModifier = new Keyboard.KeyboardModifier[]{};
        this.expandButton = (Keyboard.KeyboardButton)owner.getEnvironment().getProperty(Keyboard.KeyboardButtons.class, (Object)EXPAND_BUTTON_PROP, (Object)defaultExpandButton);
        this.expandModifier = (Keyboard.KeyboardModifier[])owner.getEnvironment().getProperty(Keyboard.KeyboardModifier[].class, (Object)EXPAND_MODIFIER_PROP, (Object)defaultExpandModifier);
    }

    protected LookupCriteria<TreeItem> createCriteria(String text, StringComparePolicy policy) {
        return new ByItemStringsLookup<TreeItem>(text, policy);
    }

    public TreeSelector<TreeItem> selector() {
        if (this.selector == null) {
            this.selector = new SWTTreeSelector();
        }
        return this.selector;
    }

    public Class<TreeItem> getType() {
        return TreeItem.class;
    }

    private boolean getExpanded(final TreeItem item) {
        return (Boolean)new GetAction<Boolean>(){

            public void run(Object ... parameters) throws Exception {
                this.setResult(item.getExpanded());
            }
        }.dispatch(this.owner.getEnvironment(), new Object[0]);
    }

    private LookupCriteria<TreeItem> thisCriteria(final TreeItem item) {
        return new LookupCriteria<TreeItem>(){

            public boolean check(TreeItem control) {
                return control == item;
            }
        };
    }

    static {
        Shells.SHELLS.getEnvironment().initTimeout(WAIT_NODE_TIMEOUT);
        Shells.SHELLS.getEnvironment().initTimeout(WAIT_NODE_EXPANDED_TIMEOUT);
        Shells.SHELLS.getEnvironment().initTimeout(AFTER_MOVE_SLEEP);
    }

    private class SWTTreeSelector
    implements TreeSelector<TreeItem> {
        private List<LookupCriteria<TreeItem>> criteriaList;

        private SWTTreeSelector() {
        }

        public Wrap<? extends TreeItem> select(LookupCriteria<TreeItem> ... criteria) {
            this.criteriaList = Arrays.asList(criteria);
            SWTTree.this.owner.as(Focusable.class).focuser().focus();
            TreeItem[] items = (TreeItem[])new GetAction<TreeItem[]>(){

                public void run(Object ... parameters) throws Exception {
                    this.setResult(((Tree)SWTTree.this.owner.getControl()).getItems());
                }
            }.dispatch(SWTTree.this.owner.getEnvironment(), new Object[0]);
            return new ItemWrap<TreeItem>(SWTTree.this.owner, this.waitAndExpand(Arrays.asList(items), Arrays.asList(criteria)));
        }

        protected TreeItem waitAndExpand(final List<TreeItem> items, final List<LookupCriteria<TreeItem>> criteria) {
            boolean isExpanded;
            final TreeItem next = (TreeItem)SWTTree.this.owner.getEnvironment().getWaiter(WAIT_NODE_TIMEOUT).ensureState((State)new State<TreeItem>(){

                public TreeItem reached() {
                    for (TreeItem ti : items) {
                        if (!((LookupCriteria)criteria.get(0)).check((Object)ti)) continue;
                        return ti;
                    }
                    return null;
                }

                public String toString() {
                    return SWTTreeSelector.this.getReadableCriteriaList();
                }
            });
            int numberOfTries = 0;
            boolean bl = isExpanded = criteria.size() > 1 && SWTTree.this.getExpanded(next);
            while (!next.equals(SWTTree.this.owner.getSelectedItem()) && !isExpanded) {
                int from = SWTTree.this.owner.getItems().indexOf(SWTTree.this.owner.getSelectedItem());
                int to = SWTTree.this.owner.getItems().indexOf(next);
                if (numberOfTries > 0) {
                    if (from == -1) {
                        SWTTree.this.owner.keyboard().pushKey((Keyboard.KeyboardButton)Keyboard.KeyboardButtons.SPACE);
                        SWTTree.this.owner.getEnvironment().getTimeout(AFTER_MOVE_SLEEP).sleep();
                    } else if (numberOfTries > 1) {
                        SWTTree.this.owner.keyboard().pushKey((Keyboard.KeyboardButton)Keyboard.KeyboardButtons.ESCAPE);
                        SWTTree.this.owner.getEnvironment().getTimeout(AFTER_MOVE_SLEEP).sleep();
                    }
                    from = SWTTree.this.owner.getItems().indexOf(SWTTree.this.owner.getSelectedItem());
                }
                Keyboard.KeyboardButtons btt = to > from ? Keyboard.KeyboardButtons.DOWN : Keyboard.KeyboardButtons.UP;
                for (int i = 0; i < Math.abs(to - from); ++i) {
                    SWTTree.this.owner.keyboard().pushKey((Keyboard.KeyboardButton)btt);
                    SWTTree.this.owner.getEnvironment().getTimeout(AFTER_MOVE_SLEEP).sleep();
                }
                if (++numberOfTries < 5) continue;
                if (next.equals(SWTTree.this.owner.getSelectedItem())) break;
                throw new TimeoutExpiredException("Unable to select the tree item with the following path " + this.getReadableCriteriaList());
            }
            if (criteria.size() > 1) {
                if (!SWTTree.this.getExpanded(next)) {
                    SWTTree.this.owner.keyboard().pushKey(SWTTree.this.expandButton, (Modifier[])SWTTree.this.expandModifier);
                    SWTTree.this.owner.getEnvironment().getTimeout(AFTER_MOVE_SLEEP).sleep();
                    SWTTree.this.owner.keyboard().pushKey((Keyboard.KeyboardButton)Keyboard.KeyboardButtons.DOWN);
                    SWTTree.this.owner.getEnvironment().getTimeout(AFTER_MOVE_SLEEP).sleep();
                }
                SWTTree.this.owner.getEnvironment().getWaiter(WAIT_NODE_EXPANDED_TIMEOUT).ensureValue((Object)true, (State)new State<Boolean>(){

                    public Boolean reached() {
                        return SWTTree.this.getExpanded(next);
                    }
                });
                return this.waitAndExpand(this.getItems(next), criteria.subList(1, criteria.size()));
            }
            return next;
        }

        protected List<TreeItem> getItems(final TreeItem next) {
            return (List)new GetAction<List<TreeItem>>(){

                public void run(Object ... parameters) throws Exception {
                    this.setResult(Arrays.asList(next.getItems()));
                }
            }.dispatch(SWTTree.this.owner.getEnvironment(), new Object[0]);
        }

        private String getReadableCriteriaList() {
            ArrayList result = new ArrayList();
            this.criteriaList.stream().forEach(lookupCriteria -> result.add(lookupCriteria.toString()));
            return ((Object)result).toString();
        }
    }
}

