/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.binders;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonatype.guice.bean.binders.QualifiedTypeBinder;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.scanners.ClassSpaceScanner;
import org.sonatype.guice.bean.scanners.ClassSpaceVisitor;
import org.sonatype.guice.bean.scanners.QualifiedTypeVisitor;
import org.sonatype.guice.bean.scanners.index.SisuIndexFinder;
import org.sonatype.inject.BeanScanning;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceModule
implements Module {
    private static Map<String, List<Element>> cachedElementsMap;
    final ClassSpace space;
    private final BeanScanning scanning;

    public SpaceModule(ClassSpace space) {
        this(space, BeanScanning.ON);
    }

    public SpaceModule(ClassSpace space, BeanScanning scanning) {
        this.space = space;
        this.scanning = scanning;
    }

    public final void configure(Binder binder) {
        ClassSpaceScanner scanner;
        binder.bind(ClassSpace.class).toInstance((Object)this.space);
        switch (this.scanning) {
            default: {
                scanner = new ClassSpaceScanner(this.space);
                break;
            }
            case INDEX: {
                scanner = new ClassSpaceScanner(new SisuIndexFinder(), this.space);
                break;
            }
            case CACHE: {
                binder.install(Elements.getModule(this.cachedScan()));
                return;
            }
            case OFF: {
                return;
            }
        }
        scanner.accept(this.visitor(binder));
    }

    protected ClassSpaceVisitor visitor(Binder binder) {
        return new QualifiedTypeVisitor(new QualifiedTypeBinder(binder));
    }

    private final synchronized List<Element> cachedScan() {
        List elements;
        String key = this.space.toString();
        if (null == cachedElementsMap) {
            cachedElementsMap = new HashMap<String, List<Element>>();
        }
        if (null == (elements = cachedElementsMap.get(key))) {
            elements = Elements.getElements((Module[])new Module[]{new Module(){

                public void configure(Binder binder) {
                    new ClassSpaceScanner(SpaceModule.this.space).accept(SpaceModule.this.visitor(binder));
                }
            }});
            cachedElementsMap.put(key, elements);
        }
        return elements;
    }
}

