/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Type;
import org.openjdk.jmc.flightrecorder.writer.api.TypedValue;
import org.openjdk.jmc.flightrecorder.writer.api.TypedValueBuilder;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

public final class TypedValueBuilderImpl
implements TypedValueBuilder {
    private final Type type;
    private final TypesImpl types;
    private final Map<String, TypedFieldImpl> fieldMap;
    private final Map<String, TypedFieldValueImpl> fieldValueMap;

    public TypedValueBuilderImpl(TypeImpl type) {
        this.type = type;
        this.types = type.getTypes();
        this.fieldMap = type.getFields().stream().collect(Collectors.toMap(TypedFieldImpl::getName, typeField -> typeField));
        this.fieldValueMap = new HashMap<String, TypedFieldValueImpl>();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public TypedValueBuilder putField(String name, byte value) {
        return this.putField(name, (TypedValue)this.types.getType(Types.Builtin.BYTE).asValue(value));
    }

    @Override
    public TypedValueBuilder putField(String name, byte[] values) {
        this.putArrayField(name, () -> {
            TypeImpl type = this.types.getType(Types.Builtin.BYTE);
            TypedValueImpl[] typedValues = new TypedValueImpl[values.length];
            for (int i = 0; i < values.length; ++i) {
                typedValues[i] = type.asValue(values[i]);
            }
            return typedValues;
        });
        return this;
    }

    @Override
    public TypedValueBuilder putField(String name, char value) {
        return this.putField(name, (TypedValue)this.types.getType(Types.Builtin.CHAR).asValue(value));
    }

    @Override
    public TypedValueBuilder putField(String name, char[] values) {
        this.putArrayField(name, () -> {
            TypeImpl type = this.types.getType(Types.Builtin.CHAR);
            TypedValueImpl[] typedValues = new TypedValueImpl[values.length];
            for (int i = 0; i < values.length; ++i) {
                typedValues[i] = type.asValue(values[i]);
            }
            return typedValues;
        });
        return this;
    }

    @Override
    public TypedValueBuilder putField(String name, short value) {
        return this.putField(name, (TypedValue)this.types.getType(Types.Builtin.SHORT).asValue(value));
    }

    @Override
    public TypedValueBuilder putField(String name, short[] values) {
        this.putArrayField(name, () -> {
            TypeImpl type = this.types.getType(Types.Builtin.SHORT);
            TypedValueImpl[] typedValues = new TypedValueImpl[values.length];
            for (int i = 0; i < values.length; ++i) {
                typedValues[i] = type.asValue(values[i]);
            }
            return typedValues;
        });
        return this;
    }

    @Override
    public TypedValueBuilder putField(String name, int value) {
        return this.putField(name, (TypedValue)this.types.getType(Types.Builtin.INT).asValue(value));
    }

    @Override
    public TypedValueBuilder putField(String name, int[] values) {
        this.putArrayField(name, () -> {
            TypeImpl type = this.types.getType(Types.Builtin.INT);
            TypedValueImpl[] typedValues = new TypedValueImpl[values.length];
            for (int i = 0; i < values.length; ++i) {
                typedValues[i] = type.asValue(values[i]);
            }
            return typedValues;
        });
        return this;
    }

    @Override
    public TypedValueBuilder putField(String name, long value) {
        return this.putField(name, (TypedValue)this.types.getType(Types.Builtin.LONG).asValue(value));
    }

    @Override
    public TypedValueBuilder putField(String name, long[] values) {
        this.putArrayField(name, () -> {
            TypeImpl type = this.types.getType(Types.Builtin.LONG);
            TypedValueImpl[] typedValues = new TypedValueImpl[values.length];
            for (int i = 0; i < values.length; ++i) {
                typedValues[i] = type.asValue(values[i]);
            }
            return typedValues;
        });
        return this;
    }

    @Override
    public TypedValueBuilder putField(String name, float value) {
        return this.putField(name, (TypedValue)this.types.getType(Types.Builtin.FLOAT).asValue(value));
    }

    @Override
    public TypedValueBuilder putField(String name, float[] values) {
        this.putArrayField(name, () -> {
            TypeImpl type = this.types.getType(Types.Builtin.FLOAT);
            TypedValueImpl[] typedValues = new TypedValueImpl[values.length];
            for (int i = 0; i < values.length; ++i) {
                typedValues[i] = type.asValue(values[i]);
            }
            return typedValues;
        });
        return this;
    }

    @Override
    public TypedValueBuilder putField(String name, double value) {
        return this.putField(name, (TypedValue)this.types.getType(Types.Builtin.DOUBLE).asValue(value));
    }

    @Override
    public TypedValueBuilder putField(String name, double[] values) {
        this.putArrayField(name, () -> {
            TypeImpl type = this.types.getType(Types.Builtin.DOUBLE);
            TypedValueImpl[] typedValues = new TypedValueImpl[values.length];
            for (int i = 0; i < values.length; ++i) {
                typedValues[i] = type.asValue(values[i]);
            }
            return typedValues;
        });
        return this;
    }

    @Override
    public TypedValueBuilder putField(String name, boolean value) {
        return this.putField(name, (TypedValue)this.types.getType(Types.Builtin.BOOLEAN).asValue(value));
    }

    @Override
    public TypedValueBuilderImpl putField(String name, boolean[] values) {
        this.putArrayField(name, () -> {
            TypeImpl type = this.types.getType(Types.Builtin.BOOLEAN);
            TypedValueImpl[] typedValues = new TypedValueImpl[values.length];
            for (int i = 0; i < values.length; ++i) {
                typedValues[i] = type.asValue(values[i]);
            }
            return typedValues;
        });
        return this;
    }

    @Override
    public TypedValueBuilder putField(String name, String value) {
        return this.putField(name, (TypedValue)this.types.getType(Types.Builtin.STRING).asValue(value));
    }

    @Override
    public TypedValueBuilder putField(String name, String[] values) {
        this.putArrayField(name, () -> {
            TypeImpl type = this.types.getType(Types.Builtin.STRING);
            TypedValueImpl[] typedValues = new TypedValueImpl[values.length];
            for (int i = 0; i < values.length; ++i) {
                typedValues[i] = type.asValue(values[i]);
            }
            return typedValues;
        });
        return this;
    }

    @Override
    public TypedValueBuilder putField(String name, TypedValueBuilder valueBuilder) {
        return this.putField(name, (TypedValue)new TypedValueImpl(valueBuilder));
    }

    @Override
    public TypedValueBuilder putField(String name, TypedValue ... values) {
        if (values.length > 0) {
            TypedValueImpl[] typedValues = new TypedValueImpl[values.length];
            System.arraycopy(values, 0, typedValues, 0, values.length);
            this.putArrayField(name, typedValues);
        }
        return this;
    }

    @Override
    public TypedValueBuilder putField(String name, TypedValue value) {
        TypedFieldImpl field = this.fieldMap.get(name);
        TypedValueImpl typedValue = (TypedValueImpl)value;
        if (field != null) {
            TypeImpl type = field.getType();
            if (type.isSimple()) {
                typedValue = TypedValueImpl.wrapSimpleValueField(type, typedValue);
            }
            if (field.getType().canAccept(typedValue)) {
                this.fieldValueMap.put(name, new TypedFieldValueImpl(field, typedValue));
            } else {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    @Override
    public TypedValueBuilder putField(String name, Consumer<TypedValueBuilder> fieldValueCallback) {
        TypedFieldImpl field = this.fieldMap.get(name);
        if (field != null) {
            this.fieldValueMap.put(name, new TypedFieldValueImpl(field, (TypedValueImpl)field.getType().asValue((Consumer)fieldValueCallback)));
        }
        return this;
    }

    @Override
    public TypedValueBuilder putFields(String name, Consumer<TypedValueBuilder> callback1, Consumer<TypedValueBuilder> callback2, Consumer<TypedValueBuilder> ... otherCallbacks) {
        this.buildArrayField(name, () -> {
            ArrayList<Consumer> callbacks = new ArrayList<Consumer>(2 + otherCallbacks.length);
            callbacks.add(callback1);
            callbacks.add(callback2);
            callbacks.addAll(Arrays.asList(otherCallbacks));
            return callbacks.toArray(new Consumer[0]);
        });
        return this;
    }

    public Map<String, TypedFieldValueImpl> build() {
        return Collections.unmodifiableMap(this.fieldValueMap);
    }

    private void putArrayField(String name, TypedValueImpl[] values) {
        TypedFieldImpl field = this.fieldMap.get(name);
        if (field == null) {
            throw new IllegalArgumentException();
        }
        this.putArrayField(field, values);
    }

    private void putArrayField(TypedFieldImpl field, TypedValueImpl[] values) {
        TypeImpl fieldType = field.getType();
        for (TypedValueImpl value : values) {
            if (fieldType.canAccept(value)) continue;
            throw new IllegalArgumentException();
        }
        this.fieldValueMap.put(field.getName(), new TypedFieldValueImpl(field, values));
    }

    private void putArrayField(String name, Supplier<TypedValueImpl[]> valueSupplier) {
        TypedFieldImpl field = this.fieldMap.get(name);
        if (field != null) {
            if (!field.isArray()) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.putArrayField(field, valueSupplier.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildArrayField(String name, Supplier<Consumer<TypedValueBuilder>[]> builderSupplier) {
        TypedFieldImpl field = this.fieldMap.get(name);
        if (field == null) throw new IllegalArgumentException();
        if (!field.isArray()) throw new IllegalArgumentException();
        Consumer<TypedValueBuilder>[] builders = builderSupplier.get();
        TypedValueImpl[] values = new TypedValueImpl[builders.length];
        TypeImpl fieldType = field.getType();
        for (int i = 0; i < builders.length; ++i) {
            values[i] = fieldType.asValue((Consumer)builders[i]);
        }
        this.fieldValueMap.put(field.getName(), new TypedFieldValueImpl(field, values));
    }
}

