/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Annotation;
import org.openjdk.jmc.flightrecorder.writer.api.TypedField;
import org.openjdk.jmc.flightrecorder.writer.util.NonZeroHashCode;

public final class TypedFieldImpl
implements TypedField {
    private int hashCode = 0;
    private final String name;
    private final TypeImpl type;
    private final boolean isArray;
    private final List<Annotation> annotations;

    public TypedFieldImpl(TypeImpl type, String name) {
        this(type, name, false, Collections.emptyList());
    }

    TypedFieldImpl(TypeImpl type, String name, boolean isArray) {
        this(type, name, isArray, Collections.emptyList());
    }

    TypedFieldImpl(TypeImpl type, String name, boolean isArray, List<Annotation> annotations) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(name);
        Objects.requireNonNull(annotations);
        this.name = name;
        this.type = type;
        this.isArray = isArray;
        this.annotations = Collections.unmodifiableList(annotations);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TypeImpl getType() {
        return this.type;
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypedFieldImpl that = (TypedFieldImpl)o;
        return this.isArray == that.isArray && this.name.equals(that.name) && this.type.equals(that.type) && this.annotations.equals(that.annotations);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = NonZeroHashCode.hash(this.name, this.type, this.isArray, this.annotations);
        }
        return this.hashCode;
    }

    public String toString() {
        return "TypedFieldImpl [hashCode=" + this.hashCode + ", name=" + this.name + ", type=" + this.type + ", isArray=" + this.isArray + ", annotations=" + this.annotations + "]";
    }
}

