/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.util.SortedHead;

public class SortedHeadTest {
    private final Comparator<Integer> COMPARATOR = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            return o1.compareTo(o2);
        }
    };

    @Test
    public void testAddIncreasing() {
        Object[] init = new Integer[]{9, 2, 6, 2, 8};
        SortedHead sh = new SortedHead(init, this.COMPARATOR);
        for (int i = 0; i < 10; ++i) {
            sh.addObject((Object)i);
        }
        Integer[] tail = (Integer[])sh.getTail();
        Assert.assertEquals((long)0L, (long)((Integer)init[0]).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)init[init.length - 1]).intValue());
        Assert.assertEquals((long)10L, (long)tail.length);
    }

    @Test
    public void testAddDecreasing() {
        Object[] init = new Integer[]{8, 2, 6, 2, 9};
        SortedHead sh = new SortedHead(init, this.COMPARATOR);
        for (int i = 9; i >= 0; --i) {
            sh.addObject((Object)i);
        }
        Integer[] tail = (Integer[])sh.getTail();
        Assert.assertEquals((long)0L, (long)((Integer)init[0]).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)init[init.length - 1]).intValue());
        Assert.assertEquals((long)10L, (long)tail.length);
    }

    @Test
    public void testRandom() {
        int valueCount = 1000000;
        Integer[] testArr = new Integer[valueCount];
        Random rand = new Random();
        for (int i = valueCount - 1; i >= 0; --i) {
            testArr[i] = rand.nextInt();
        }
        Object[] fastSortArray = new Integer[1000];
        System.arraycopy(testArr, 0, fastSortArray, 0, fastSortArray.length);
        long t = System.currentTimeMillis();
        SortedHead sh = new SortedHead(fastSortArray, this.COMPARATOR);
        for (int i = fastSortArray.length; i < testArr.length; ++i) {
            sh.addObject((Object)testArr[i]);
        }
        Integer[] tail = (Integer[])sh.getTail();
        System.out.println("SortedHead used " + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        Arrays.sort(testArr, this.COMPARATOR);
        System.out.println("Arrays.sort used " + (System.currentTimeMillis() - t));
        for (int i = 0; i < fastSortArray.length; ++i) {
            Assert.assertEquals((Object)testArr[i], (Object)fastSortArray[i]);
        }
        Assert.assertEquals((long)(valueCount - fastSortArray.length), (long)tail.length);
    }
}

