/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.shared.artifact.filter.StatisticsReportingArtifactFilter;
import org.codehaus.plexus.logging.Logger;

public class ScopeArtifactFilter
implements ArtifactFilter,
StatisticsReportingArtifactFilter {
    private boolean includeCompileScope;
    private boolean includeRuntimeScope;
    private boolean includeTestScope;
    private boolean includeProvidedScope;
    private boolean includeSystemScope;
    private boolean includeNullScope = true;
    private boolean nullScopeHit = false;
    private boolean compileScopeHit = false;
    private boolean runtimeScopeHit = false;
    private boolean testScopeHit = false;
    private boolean providedScopeHit = false;
    private boolean systemScopeHit = false;
    private List filteredArtifactIds = new ArrayList();

    public ScopeArtifactFilter() {
        this(null);
    }

    public ScopeArtifactFilter(String scope) {
        if ("compile".equals(scope)) {
            this.setIncludeCompileScopeWithImplications(true);
        } else if ("runtime".equals(scope)) {
            this.setIncludeRuntimeScopeWithImplications(true);
        } else if ("test".equals(scope)) {
            this.setIncludeTestScopeWithImplications(true);
        } else if ("provided".equals(scope)) {
            this.setIncludeProvidedScope(true);
        } else if ("system".equals(scope)) {
            this.setIncludeSystemScope(true);
        }
    }

    public boolean include(Artifact artifact) {
        boolean result = true;
        if (artifact.getScope() == null) {
            this.nullScopeHit = true;
            result = this.includeNullScope;
        } else if ("compile".equals(artifact.getScope())) {
            this.compileScopeHit = true;
            result = this.includeCompileScope;
        } else if ("runtime".equals(artifact.getScope())) {
            this.runtimeScopeHit = true;
            result = this.includeRuntimeScope;
        } else if ("test".equals(artifact.getScope())) {
            this.testScopeHit = true;
            result = this.includeTestScope;
        } else if ("provided".equals(artifact.getScope())) {
            this.providedScopeHit = true;
            result = this.includeProvidedScope;
        } else if ("system".equals(artifact.getScope())) {
            this.systemScopeHit = true;
            result = this.includeSystemScope;
        }
        if (!result) {
            String id = artifact.getVersionRange() != null ? artifact.getDependencyConflictId() + ":" + artifact.getVersionRange() : artifact.getId();
            this.filteredArtifactIds.add(id);
        }
        return result;
    }

    public String toString() {
        return "Scope filter [null-scope=" + this.includeNullScope + ", compile=" + this.includeCompileScope + ", runtime=" + this.includeRuntimeScope + ", test=" + this.includeTestScope + ", provided=" + this.includeProvidedScope + ", system=" + this.includeSystemScope + "]";
    }

    public void reportFilteredArtifacts(Logger logger) {
        if (!this.filteredArtifactIds.isEmpty() && logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer("The following artifacts were removed by this filter: ");
            Iterator it = this.filteredArtifactIds.iterator();
            while (it.hasNext()) {
                String artifactId = (String)it.next();
                buffer.append('\n').append(artifactId);
            }
            logger.debug(buffer.toString());
        }
    }

    public void reportMissedCriteria(Logger logger) {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            boolean report = false;
            if (!this.nullScopeHit) {
                buffer.append("\no [Null Scope]");
                report = true;
            }
            if (!this.compileScopeHit) {
                buffer.append("\no Compile");
                report = true;
            }
            if (!this.runtimeScopeHit) {
                buffer.append("\no Runtime");
                report = true;
            }
            if (!this.testScopeHit) {
                buffer.append("\no Test");
                report = true;
            }
            if (!this.providedScopeHit) {
                buffer.append("\no Provided");
                report = true;
            }
            if (!this.systemScopeHit) {
                buffer.append("\no System");
                report = true;
            }
            if (report) {
                logger.debug("The following scope filters were not used: " + buffer.toString());
            }
        }
    }

    public boolean hasMissedCriteria() {
        boolean report = false;
        if (!this.nullScopeHit) {
            report = true;
        }
        if (!this.compileScopeHit) {
            report = true;
        }
        if (!this.runtimeScopeHit) {
            report = true;
        }
        if (!this.testScopeHit) {
            report = true;
        }
        if (!this.providedScopeHit) {
            report = true;
        }
        if (!this.systemScopeHit) {
            report = true;
        }
        return report;
    }

    public boolean isIncludeCompileScope() {
        return this.includeCompileScope;
    }

    public ScopeArtifactFilter setIncludeCompileScope(boolean includeCompileScope) {
        this.includeCompileScope = includeCompileScope;
        return this;
    }

    public boolean isIncludeRuntimeScope() {
        return this.includeRuntimeScope;
    }

    public ScopeArtifactFilter setIncludeRuntimeScope(boolean includeRuntimeScope) {
        this.includeRuntimeScope = includeRuntimeScope;
        return this;
    }

    public boolean isIncludeTestScope() {
        return this.includeTestScope;
    }

    public ScopeArtifactFilter setIncludeTestScope(boolean includeTestScope) {
        this.includeTestScope = includeTestScope;
        return this;
    }

    public boolean isIncludeProvidedScope() {
        return this.includeProvidedScope;
    }

    public ScopeArtifactFilter setIncludeProvidedScope(boolean includeProvidedScope) {
        this.includeProvidedScope = includeProvidedScope;
        return this;
    }

    public boolean isIncludeSystemScope() {
        return this.includeSystemScope;
    }

    public ScopeArtifactFilter setIncludeSystemScope(boolean includeSystemScope) {
        this.includeSystemScope = includeSystemScope;
        return this;
    }

    public ScopeArtifactFilter setIncludeCompileScopeWithImplications(boolean enabled) {
        this.includeSystemScope = enabled;
        this.includeProvidedScope = enabled;
        this.includeCompileScope = enabled;
        return this;
    }

    public ScopeArtifactFilter setIncludeRuntimeScopeWithImplications(boolean enabled) {
        this.includeCompileScope = enabled;
        this.includeRuntimeScope = enabled;
        return this;
    }

    public ScopeArtifactFilter setIncludeTestScopeWithImplications(boolean enabled) {
        this.includeSystemScope = enabled;
        this.includeProvidedScope = enabled;
        this.includeCompileScope = enabled;
        this.includeRuntimeScope = enabled;
        this.includeTestScope = enabled;
        return this;
    }

    public ScopeArtifactFilter setIncludeNullScope(boolean enable) {
        this.includeNullScope = enable;
        return this;
    }

    public ScopeArtifactFilter reset() {
        this.compileScopeHit = false;
        this.runtimeScopeHit = false;
        this.testScopeHit = false;
        this.providedScopeHit = false;
        this.systemScopeHit = false;
        this.filteredArtifactIds.clear();
        return this;
    }
}

