/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.util.resolution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.Projector;
import org.eclipse.equinox.internal.p2.director.QueryableArray;
import org.eclipse.equinox.internal.p2.director.SimplePlanner;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.util.resolution.AbstractSlicerResolutionStrategy;
import org.eclipse.tycho.p2.util.resolution.ResolverDebugUtils;
import org.eclipse.tycho.p2.util.resolution.ResolverException;
import org.eclipse.tycho.repository.p2base.metadata.QueryableCollection;
import org.eclipse.tycho.repository.util.StatusTool;

public class ProjectorResolutionStrategy
extends AbstractSlicerResolutionStrategy {
    public ProjectorResolutionStrategy(MavenLogger logger) {
        super(logger);
    }

    @Override
    protected Slicer newSlicer(IQueryable<IInstallableUnit> availableUnits, Map<String, String> properties) {
        return new Slicer(availableUnits, properties, false);
    }

    @Override
    protected boolean isSlicerError(MultiStatus slicerStatus) {
        return slicerStatus.matches(12);
    }

    @Override
    public Collection<IInstallableUnit> resolve(Map<String, String> properties, IProgressMonitor monitor) throws ResolverException {
        Map newSelectionContext = SimplePlanner.createSelectionContext(properties);
        IQueryable<IInstallableUnit> slice = this.slice(properties, monitor);
        LinkedHashSet<IInstallableUnit> seedUnits = new LinkedHashSet<IInstallableUnit>(this.data.getRootIUs());
        ArrayList<IRequirement> seedRequires = new ArrayList<IRequirement>();
        if (this.data.getAdditionalRequirements() != null) {
            seedRequires.addAll(this.data.getAdditionalRequirements());
        }
        seedUnits.addAll(this.data.getEEResolutionHints().getMandatoryUnits());
        seedRequires.addAll(this.data.getEEResolutionHints().getMandatoryRequires());
        Projector projector = new Projector(slice, newSelectionContext, new HashSet(), false);
        projector.encode(ProjectorResolutionStrategy.createUnitRequiring("tycho", seedUnits, seedRequires), EMPTY_IU_ARRAY, (IQueryable)new QueryableArray(EMPTY_IU_ARRAY), seedUnits, monitor);
        IStatus s = projector.invokeSolver(monitor);
        if (s.getSeverity() == 4) {
            this.logger.debug(StatusTool.collectProblems((IStatus)s));
            Set explanation = projector.getExplanation((IProgressMonitor)new NullProgressMonitor());
            throw new ResolverException(explanation.stream().map(Object::toString).collect(Collectors.joining("\n")), newSelectionContext.toString(), StatusTool.findException((IStatus)s));
        }
        Collection newState = projector.extractSolution();
        newState.removeAll(this.data.getEEResolutionHints().getTemporaryAdditions());
        this.fixSWT(this.data.getAvailableIUs(), newState, newSelectionContext, monitor);
        if (this.logger.isExtendedDebugEnabled()) {
            this.logger.debug("Resolved IUs:\n" + ResolverDebugUtils.toDebugString(newState, false));
        }
        return newState;
    }

    void fixSWT(Collection<IInstallableUnit> availableIUs, Collection<IInstallableUnit> resolutionResult, Map<String, String> newSelectionContext, IProgressMonitor monitor) {
        IInstallableUnit swtHost = this.findSWTHostIU(resolutionResult);
        if (swtHost == null) {
            return;
        }
        if (swtHost.getVersion().compareTo((Object)Version.createOSGi((int)3, (int)104, (int)0)) >= 0) {
            return;
        }
        for (IInstallableUnit iu : this.data.getRootIUs()) {
            if ("org.eclipse.swt".equals(iu.getId())) {
                return;
            }
            for (IProvidedCapability provided : iu.getProvidedCapabilities()) {
                if (!"osgi.fragment".equals(provided.getNamespace()) || !"org.eclipse.swt".equals(provided.getName())) continue;
                return;
            }
        }
        IInstallableUnit swtFragment = null;
        block2: for (IInstallableUnit iu : new QueryableCollection(availableIUs).query(QueryUtil.ALL_UNITS, monitor)) {
            if (!iu.getId().startsWith("org.eclipse.swt") || !this.isApplicable(newSelectionContext, (IMatchExpression<IInstallableUnit>)iu.getFilter()) || !this.providesJavaPackages(iu)) continue;
            for (IProvidedCapability provided : iu.getProvidedCapabilities()) {
                if (!"osgi.fragment".equals(provided.getNamespace()) || !"org.eclipse.swt".equals(provided.getName())) continue;
                if (swtFragment != null && swtFragment.getVersion().compareTo((Object)iu.getVersion()) >= 0) continue block2;
                swtFragment = iu;
                continue block2;
            }
        }
        if (swtFragment == null) {
            throw new RuntimeException("Could not determine SWT implementation fragment bundle for environment " + newSelectionContext);
        }
        resolutionResult.add(swtFragment);
    }

    private IInstallableUnit findSWTHostIU(Collection<IInstallableUnit> ius) {
        for (IInstallableUnit iu : ius) {
            if (!"org.eclipse.swt".equals(iu.getId())) continue;
            return iu;
        }
        return null;
    }

    private boolean providesJavaPackages(IInstallableUnit iu) {
        for (IProvidedCapability capability : iu.getProvidedCapabilities()) {
            if (!"java.package".equals(capability.getNamespace())) continue;
            return true;
        }
        return false;
    }

    protected boolean isApplicable(Map<String, String> selectionContext, IMatchExpression<IInstallableUnit> filter) {
        if (filter == null) {
            return true;
        }
        return filter.isMatch((Object)InstallableUnit.contextIU(selectionContext));
    }
}

