/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.tycho.artifacts.TargetPlatformFilter;
import org.eclipse.tycho.artifacts.TargetPlatformFilterSyntaxException;
import org.eclipse.tycho.core.shared.MavenLogger;

public class TargetPlatformFilterEvaluator {
    private final List<TargetPlatformFilter> filters;
    final MavenLogger logger;
    private final FilterLogger filterLogger;

    public TargetPlatformFilterEvaluator(List<TargetPlatformFilter> filters, MavenLogger logger) {
        this.filters = Collections.unmodifiableList(new ArrayList<TargetPlatformFilter>(filters));
        this.logger = logger;
        this.filterLogger = new FilterLogger();
    }

    public void filterUnits(Collection<IInstallableUnit> targetPlatformUnits) throws TargetPlatformFilterSyntaxException {
        for (TargetPlatformFilter filter : this.filters) {
            this.applyFilter(filter, targetPlatformUnits);
        }
    }

    private void applyFilter(TargetPlatformFilter filter, Collection<IInstallableUnit> targetPlatformUnits) {
        switch (filter.getAction()) {
            case REMOVE_ALL: {
                this.applyRemoveAllFilter(filter, targetPlatformUnits);
                return;
            }
            case RESTRICT: {
                this.applyRestrictionFilter(filter, targetPlatformUnits);
                return;
            }
        }
    }

    private void applyRemoveAllFilter(TargetPlatformFilter filter, Collection<IInstallableUnit> targetPlatformUnits) {
        ParsedCapabilityPattern scopePattern = TargetPlatformFilterEvaluator.parsePattern(filter.getScopePattern(), null);
        Iterator<IInstallableUnit> unitIterator = targetPlatformUnits.iterator();
        while (unitIterator.hasNext()) {
            IInstallableUnit unit = unitIterator.next();
            if (!this.matches(unit, scopePattern)) continue;
            unitIterator.remove();
        }
    }

    private void applyRestrictionFilter(TargetPlatformFilter filter, Collection<IInstallableUnit> targetPlatformUnits) {
        ParsedCapabilityPattern scopePattern = TargetPlatformFilterEvaluator.parsePattern(filter.getScopePattern(), null);
        ParsedCapabilityPattern restrictionPattern = TargetPlatformFilterEvaluator.parsePattern(filter.getActionPattern(), scopePattern);
        this.filterLogger.beginEvaluation(filter);
        Iterator<IInstallableUnit> unitIterator = targetPlatformUnits.iterator();
        while (unitIterator.hasNext()) {
            IInstallableUnit unit = unitIterator.next();
            if (!this.matches(unit, scopePattern)) continue;
            if (!this.matches(unit, restrictionPattern)) {
                unitIterator.remove();
                this.filterLogger.unitRemoved(unit);
                continue;
            }
            this.filterLogger.unitKept(unit);
        }
        this.filterLogger.endEvaluation();
    }

    private boolean matches(IInstallableUnit unit, ParsedCapabilityPattern pattern) {
        switch (pattern.getType()) {
            case P2_INSTALLABLE_UNIT: {
                return pattern.matchesId(unit.getId()) && pattern.matchesVersion(unit.getVersion());
            }
            case OSGI_BUNDLE: {
                IProvidedCapability bundle = this.getBundleCapability(unit);
                if (bundle == null) {
                    return false;
                }
                return pattern.matchesId(bundle.getName()) && pattern.matchesVersion(bundle.getVersion());
            }
            case JAVA_PACKAGE: {
                for (IProvidedCapability exportedPackage : this.getPackageCapabilities(unit)) {
                    if (!pattern.matchesId(exportedPackage.getName()) || !pattern.matchesVersion(exportedPackage.getVersion())) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private IProvidedCapability getBundleCapability(IInstallableUnit unit) {
        for (IProvidedCapability capability : unit.getProvidedCapabilities()) {
            if (!"osgi.bundle".equals(capability.getNamespace())) continue;
            return capability;
        }
        return null;
    }

    private List<IProvidedCapability> getPackageCapabilities(IInstallableUnit unit) {
        Collection allCapabilities = unit.getProvidedCapabilities();
        ArrayList<IProvidedCapability> packageCapabilities = new ArrayList<IProvidedCapability>(allCapabilities.size());
        for (IProvidedCapability capability : allCapabilities) {
            if (!"java.package".equals(capability.getNamespace())) continue;
            packageCapabilities.add(capability);
        }
        return packageCapabilities;
    }

    private static ParsedCapabilityPattern parsePattern(TargetPlatformFilter.CapabilityPattern pattern, ParsedCapabilityPattern defaultValues) {
        return new ParsedCapabilityPattern(pattern, defaultValues);
    }

    private static Version parseVersion(String version) {
        if (version == null) {
            return null;
        }
        try {
            return Version.parseVersion((String)version);
        }
        catch (IllegalArgumentException e) {
            throw new TargetPlatformFilterSyntaxException("Failed to parse version: " + version, (Throwable)e);
        }
    }

    private static VersionRange parseVersionRange(String versionRange) {
        if (versionRange == null) {
            return null;
        }
        try {
            return new VersionRange(versionRange);
        }
        catch (IllegalArgumentException e) {
            throw new TargetPlatformFilterSyntaxException("Failed to parse version range: " + versionRange, (Throwable)e);
        }
    }

    private class FilterLogger {
        TargetPlatformFilter currentFilter;
        int unitsKept;
        int unitsRemoved;

        private FilterLogger() {
        }

        public void beginEvaluation(TargetPlatformFilter filter) {
            this.currentFilter = filter;
            this.unitsKept = 0;
            this.unitsRemoved = 0;
        }

        public void unitKept(IInstallableUnit unit) {
            ++this.unitsKept;
        }

        public void unitRemoved(IInstallableUnit unit) {
            ++this.unitsRemoved;
        }

        public void endEvaluation() {
            if (this.unitsRemoved > 0 && this.unitsKept == 0) {
                TargetPlatformFilterEvaluator.this.logger.warn("Removed all units from the target platform matching {" + this.currentFilter.getScopePattern().printMembers() + "} because none of the units passed the restriction filter {" + this.currentFilter.getActionPattern().printMembers() + "}");
            }
        }
    }

    static class ParsedCapabilityPattern {
        private TargetPlatformFilter.CapabilityType type;
        private String idRequirement;
        private Version versionReq;
        private VersionRange versionRangeReq;

        ParsedCapabilityPattern(TargetPlatformFilter.CapabilityPattern pattern, ParsedCapabilityPattern defaultValues) {
            this.type = pattern.getType();
            this.idRequirement = pattern.getId();
            this.versionReq = TargetPlatformFilterEvaluator.parseVersion(pattern.getVersion());
            this.versionRangeReq = TargetPlatformFilterEvaluator.parseVersionRange(pattern.getVersionRange());
            if (defaultValues != null && this.type == null) {
                this.type = defaultValues.type;
                if (this.idRequirement == null) {
                    this.idRequirement = defaultValues.idRequirement;
                }
            }
        }

        TargetPlatformFilter.CapabilityType getType() {
            return this.type;
        }

        boolean matchesId(String id) {
            if (this.idRequirement == null) {
                return true;
            }
            return this.idRequirement.equals(id);
        }

        boolean matchesVersion(Version version) {
            return this.exactVersionPatternMatches(version) && this.versionRangePatternMatches(version);
        }

        private boolean exactVersionPatternMatches(Version version) {
            if (this.versionReq == null) {
                return true;
            }
            return this.versionReq.equals(version);
        }

        private boolean versionRangePatternMatches(Version version) {
            if (this.versionRangeReq == null) {
                return true;
            }
            return this.versionRangeReq.isIncluded(version);
        }
    }
}

