/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.test.TestToolkit;
import org.openjdk.jmc.common.test.io.IOResource;
import org.openjdk.jmc.common.test.io.IOResourceSet;
import org.openjdk.jmc.common.util.StringToolkit;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrLoaderToolkit;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFormatToolkit;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFrame;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceModel;
import org.openjdk.jmc.flightrecorder.test.util.PrintoutsToolkit;
import org.openjdk.jmc.flightrecorder.test.util.RecordingToolkit;

public class StacktraceTestToolkit {
    private static final String STACKTRACE_DIRECTORY = "stacktraces";
    private static final String STACKTRACE_INDEXFILE = "index.txt";
    private static final FrameSeparator methodFrameSeparator = new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false);

    public static IOResourceSet[] getTestResources() throws IOException {
        IOResourceSet recordings = RecordingToolkit.getRecordings();
        IOResourceSet stacktraces = StacktraceTestToolkit.getStackTraceBaselines();
        if (recordings.getResources().size() != stacktraces.getResources().size()) {
            throw new RuntimeException("The number of stacktraces baselines ( " + stacktraces.getResources().size() + ") does not match the number of recording files (" + recordings.getResources().size());
        }
        ArrayList<IOResourceSet> list = new ArrayList<IOResourceSet>();
        for (IOResource recordingfile : recordings) {
            IOResource stacktraceFile = stacktraces.findWithPrefix(recordingfile.getName());
            if (stacktraceFile == null) {
                throw new RuntimeException("Could not find stacktrace baseline file for " + recordingfile);
            }
            list.add(new IOResourceSet(new IOResource[]{recordingfile, stacktraceFile}));
        }
        return list.toArray(new IOResourceSet[list.size()]);
    }

    public static File getStacktracesDirectory() throws IOException {
        return TestToolkit.getProjectDirectory(StacktraceTestToolkit.class, (String)STACKTRACE_DIRECTORY);
    }

    private static IOResourceSet getStackTraceBaselines() throws IOException {
        return TestToolkit.getResourcesInDirectory(StacktraceTestToolkit.class, (String)STACKTRACE_DIRECTORY, (String)STACKTRACE_INDEXFILE);
    }

    public static void printStacktraces(File sourceFile, File destinationFile) throws IOException, CouldNotLoadRecordingException {
        try (FileOutputStream output = new FileOutputStream(destinationFile);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, "UTF-8");){
            IItemCollection events = JfrLoaderToolkit.loadEvents((File)sourceFile);
            for (String e : StacktraceTestToolkit.getAggregatedStacktraceLines(events, methodFrameSeparator)) {
                ((Writer)writer).append(e).append('\n');
            }
        }
    }

    public static List<String> getStacktracesBaseline(IOResourceSet resourceSet) throws IOException, Exception {
        return StacktraceTestToolkit.getLines(PrintoutsToolkit.stripHeader(StringToolkit.readString((InputStream)resourceSet.getResource(1).open())));
    }

    public static List<String> getLines(String content) {
        ArrayList<String> result = new ArrayList<String>();
        Scanner scanner = new Scanner(content);
        while (scanner.hasNextLine()) {
            result.add(scanner.nextLine());
        }
        scanner.close();
        return result;
    }

    public static List<String> getAggregatedStacktraceLines(IItemCollection items) {
        return StacktraceTestToolkit.getAggregatedStacktraceLines(items, methodFrameSeparator);
    }

    private static List<String> getAggregatedStacktraceLines(IItemCollection items, FrameSeparator frameSeparator) {
        return StacktraceTestToolkit.walkStacktraceTree(items, frameSeparator);
    }

    private static List<String> walkStacktraceTree(IItemCollection items, FrameSeparator frameSeparator) {
        StacktraceModel sModel = new StacktraceModel(false, frameSeparator, items);
        StacktraceModel.Fork root = sModel.getRootFork();
        ArrayList<String> traces = new ArrayList<String>();
        return StacktraceTestToolkit.walkStacktraceTree(root, frameSeparator, "", traces);
    }

    private static List<String> walkStacktraceTree(StacktraceModel.Fork fork, FrameSeparator frameSeparator, String indent, List<String> traces) {
        for (StacktraceModel.Branch branch : fork.getBranches()) {
            StacktraceTestToolkit.handleBranch(branch, frameSeparator, indent, traces);
            StacktraceModel.Fork endFork = branch.getEndFork();
            StacktraceTestToolkit.walkStacktraceTree(endFork, frameSeparator, indent + "    ", traces);
            traces.add("");
        }
        return traces;
    }

    private static void handleBranch(StacktraceModel.Branch branch, FrameSeparator frameSeparator, String indent, List<String> traces) {
        StacktraceFrame sFrame = branch.getFirstFrame();
        traces.add(StacktraceTestToolkit.createFrameLine(frameSeparator, indent, sFrame));
        for (StacktraceFrame frame : branch.getTailFrames()) {
            traces.add(StacktraceTestToolkit.createFrameLine(frameSeparator, indent, frame));
        }
    }

    private static String createFrameLine(FrameSeparator frameSeparator, String indent, StacktraceFrame sFrame) {
        return indent + StacktraceFormatToolkit.formatFrame((IMCFrame)sFrame.getFrame(), (FrameSeparator)frameSeparator) + " (" + sFrame.getItemCount() + ")";
    }
}

