/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test;

import java.io.IOException;
import java.util.List;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.test.io.IOResourceSet;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.IParserStats;
import org.openjdk.jmc.flightrecorder.test.util.PrintoutsToolkit;
import org.openjdk.jmc.flightrecorder.test.util.RecordingToolkit;

public class RecordingTest {
    @Test
    public void testRecordings() throws IOException, CouldNotLoadRecordingException {
        for (IOResourceSet resourceSet : PrintoutsToolkit.getTestResources()) {
            IItemCollection items = RecordingToolkit.getFlightRecording(resourceSet);
            List<String> parsedEvents = PrintoutsToolkit.getEventsAsStrings(items);
            try {
                List<String> expectedEvents = PrintoutsToolkit.getEventsFromPrintout(resourceSet);
                Assert.assertEquals((long)expectedEvents.size(), (long)parsedEvents.size());
                for (int i = 0; i < expectedEvents.size(); ++i) {
                    Assert.assertEquals((String)(resourceSet.getResource(0).getName() + ": events did not match expected"), (Object)expectedEvents.get(i), (Object)parsedEvents.get(i));
                }
            }
            catch (Exception e) {
                Assert.fail((String)(resourceSet.getResource(0).getName() + ": Could not read baseline file: " + e.getMessage()));
            }
        }
    }

    @Test
    public void testParserStats() throws IOException, CouldNotLoadRecordingException {
        for (IOResourceSet resourceSet : PrintoutsToolkit.getTestResources()) {
            IItemCollection items = RecordingToolkit.getFlightRecording(resourceSet);
            IParserStats parserStats = (IParserStats)items;
            TreeSet eventStatsSet = new TreeSet((o1, o2) -> Long.compare(o1.getCount(), o2.getCount()));
            parserStats.forEachEventType(eventStats -> eventStatsSet.add(eventStats));
            List<String> statsLine = null;
            try {
                statsLine = RecordingToolkit.getStats(resourceSet);
            }
            catch (IOException ex) {
                continue;
            }
            int i = 0;
            for (IParserStats.IEventStats eventStats2 : eventStatsSet) {
                String[] cols = statsLine.get(i).split(";");
                Assert.assertEquals((Object)cols[0], (Object)eventStats2.getName());
                Assert.assertEquals((long)Long.parseLong(cols[1]), (long)eventStats2.getCount());
                Assert.assertEquals((long)Long.parseLong(cols[2]), (long)eventStats2.getTotalSize());
                ++i;
            }
        }
    }
}

