/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.lookup;

import java.io.PrintStream;
import java.util.List;
import org.jemmy.control.Wrap;
import org.jemmy.control.Wrapper;
import org.jemmy.env.Environment;
import org.jemmy.lookup.AbstractLookup;
import org.jemmy.lookup.ControlHierarchy;
import org.jemmy.lookup.Lookup;
import org.jemmy.lookup.LookupCriteria;

public class HierarchyLookup<CONTROL>
extends AbstractLookup<CONTROL> {
    ControlHierarchy hierarchy;

    public HierarchyLookup(Environment env, ControlHierarchy hierarchy, Wrapper wrapper, Class<CONTROL> controlClass, LookupCriteria<CONTROL> criteria) {
        super(env, controlClass, criteria, wrapper);
        this.hierarchy = hierarchy;
    }

    public HierarchyLookup(Environment env, ControlHierarchy hierarchy, Class<CONTROL> controlClass, LookupCriteria<CONTROL> criteria) {
        this(env, hierarchy, Wrap.getWrapper(), controlClass, criteria);
    }

    @Override
    List getChildren(Object subParent) {
        if (subParent != null) {
            return this.hierarchy.getChildren(subParent);
        }
        return this.hierarchy.getControls();
    }

    @Override
    protected void dump(PrintStream out, Lookup<? extends CONTROL> lookup) {
        int size = lookup.size();
        for (int i = 0; i < size; ++i) {
            CONTROL object = lookup.get(i);
            this.dumpOne(out, object, this.calcPrefix(object));
        }
    }

    private String calcPrefix(CONTROL child) {
        String res = "";
        Object sp = child;
        while ((sp = this.hierarchy.getParent(sp)) != null) {
            res = res + "| ";
        }
        return res;
    }
}

