/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.image.pixel;

import java.util.Arrays;
import org.jemmy.Dimension;
import org.jemmy.env.Environment;
import org.jemmy.image.Image;
import org.jemmy.image.ImageComparator;
import org.jemmy.image.pixel.PixelEqualityRasterComparator;
import org.jemmy.image.pixel.Raster;
import org.jemmy.image.pixel.RasterComparator;
import org.jemmy.image.pixel.WriteableRaster;

public abstract class PixelImageComparator
implements ImageComparator {
    private RasterComparator comparator = null;
    private Environment env = null;
    private static final Raster.Component[] diffComponents;

    public PixelImageComparator(RasterComparator comparator) {
        this.comparator = comparator;
    }

    public PixelImageComparator(Environment env) {
        this.env = env;
    }

    public synchronized RasterComparator getRasterComparator() {
        if (this.comparator == null) {
            return this.env.getProperty(RasterComparator.class);
        }
        return this.comparator;
    }

    public static Dimension computeDiffSize(Raster one, Raster two) {
        if (one.getSize().equals(two.getSize())) {
            return one.getSize();
        }
        return null;
    }

    @Override
    public Image compare(Image image1, Image image2) {
        Raster pi1 = this.toRaster(image1);
        Raster pi2 = this.toRaster(image2);
        if (!this.getRasterComparator().compare(pi1, pi2)) {
            return this.toImage(this.computeDifference(pi1, pi2));
        }
        return null;
    }

    public WriteableRaster computeDifference(Raster image1, Raster image2) {
        Dimension size = PixelImageComparator.computeDiffSize(image1, image2);
        if (size == null) {
            size = new Dimension(Math.max(image1.getSize().width, image2.getSize().width), Math.max(image1.getSize().height, image2.getSize().height));
        }
        WriteableRaster res = this.createDiffRaster(image1, image2);
        double[] colors1 = new double[image1.getSupported().length];
        double[] colors2 = new double[image2.getSupported().length];
        double[] colorsRes = new double[res.getSupported().length];
        for (int x = 0; x < size.width; ++x) {
            for (int y = 0; y < size.height; ++y) {
                if (x < image1.getSize().width && y < image1.getSize().height) {
                    image1.getColors(x, y, colors1);
                } else {
                    Arrays.fill(colors1, 0.0);
                }
                if (x < image2.getSize().width && y < image2.getSize().height) {
                    image2.getColors(x, y, colors2);
                } else {
                    Arrays.fill(colors2, 1.0);
                }
                this.calcDiffColor(image1.getSupported(), colors1, image2.getSupported(), colors2, res.getSupported(), colorsRes);
                res.setColors(x, y, colorsRes);
            }
        }
        return res;
    }

    protected void calcDiffColor(Raster.Component[] comps1, double[] colors1, Raster.Component[] comps2, double[] colors2, Raster.Component[] compsRes, double[] colorsRes) {
        double dist = 0.0;
        for (Raster.Component c : diffComponents) {
            double square1 = this.getComponentValue(comps1, colors1, c);
            double square2 = this.getComponentValue(comps2, colors2, c);
            dist += (square2 - square1) * (square2 - square1);
        }
        for (Raster.Component c : diffComponents) {
            colorsRes[PixelImageComparator.arrayIndexOf((Raster.Component[])compsRes, (Raster.Component)c)] = Math.sqrt(dist) / Math.sqrt(3.0);
        }
        colorsRes[PixelImageComparator.arrayIndexOf((Raster.Component[])compsRes, (Raster.Component)Raster.Component.ALPHA)] = 1.0;
    }

    @Override
    public String getID() {
        return this.getRasterComparator().getID();
    }

    protected abstract Image toImage(Raster var1);

    protected abstract Raster toRaster(Image var1);

    protected abstract WriteableRaster createDiffRaster(Raster var1, Raster var2);

    public static int arrayIndexOf(Raster.Component[] comps, Raster.Component comp) {
        for (int i = 0; i < comps.length; ++i) {
            if (comp != comps[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("Unknown component " + (Object)((Object)comp));
    }

    protected double getComponentValue(Raster.Component[] components, double[] colors, Raster.Component comp) {
        double result = colors[PixelImageComparator.arrayIndexOf(components, comp)];
        if (result < 0.0 || result > 1.0) {
            throw new IllegalStateException("Component value = " + result);
        }
        int idxAlpha = -1;
        try {
            idxAlpha = PixelImageComparator.arrayIndexOf(components, Raster.Component.ALPHA);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (idxAlpha != -1) {
            double alpha = colors[idxAlpha];
            if (alpha < 0.0 || alpha > 1.0) {
                throw new IllegalStateException("Alpha value = " + alpha);
            }
            if (alpha < 1.0) {
                result = Math.min(1.0, alpha * result + 1.0 - alpha);
            }
        }
        return result;
    }

    static {
        Environment.getEnvironment().setPropertyIfNotSet(RasterComparator.class, new PixelEqualityRasterComparator(0.0));
        diffComponents = new Raster.Component[]{Raster.Component.RED, Raster.Component.BLUE, Raster.Component.GREEN};
    }
}

