/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.image.pixel;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.jemmy.JemmyException;
import org.jemmy.image.pixel.PNGSaver;
import org.jemmy.image.pixel.PixelImageComparator;
import org.jemmy.image.pixel.Raster;
import org.jemmy.image.pixel.WriteableRaster;

public abstract class PNGLoader {
    InputStream in;

    public PNGLoader(InputStream in) {
        this.in = in;
    }

    byte read() throws IOException {
        byte b = (byte)this.in.read();
        return b;
    }

    int readInt() throws IOException {
        byte[] b = this.read(4);
        return ((b[0] & 0xFF) << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
    }

    byte[] read(int count) throws IOException {
        byte[] result = new byte[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.read();
        }
        return result;
    }

    void checkEquality(byte[] b1, byte[] b2) {
        if (!Arrays.equals(b1, b2)) {
            throw new JemmyException("Format error");
        }
    }

    public Raster decode() throws IOException {
        return this.decode(true);
    }

    protected abstract WriteableRaster createRaster(int var1, int var2);

    public Raster decode(boolean closeStream) throws IOException {
        int mode;
        byte[] id = this.read(12);
        this.checkEquality(id, new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13});
        byte[] ihdr = this.read(4);
        this.checkEquality(ihdr, "IHDR".getBytes());
        int width = this.readInt();
        int height = this.readInt();
        WriteableRaster result = this.createRaster(width, height);
        byte[] head = this.read(5);
        if (Arrays.equals(head, new byte[]{1, 0, 0, 0, 0})) {
            mode = 0;
        } else if (Arrays.equals(head, new byte[]{8, 0, 0, 0, 0})) {
            mode = 1;
        } else if (Arrays.equals(head, new byte[]{8, 2, 0, 0, 0})) {
            mode = 2;
        } else {
            throw new JemmyException("Format error");
        }
        this.readInt();
        int size = this.readInt();
        byte[] idat = this.read(4);
        this.checkEquality(idat, "IDAT".getBytes());
        byte[] data = this.read(size);
        Inflater inflater = new Inflater();
        inflater.setInput(data, 0, size);
        int[] colors = new int[3];
        int[] black = new int[]{0, 0, 0};
        int[] white = new int[]{1, 1, 1};
        try {
            switch (mode) {
                case 0: {
                    int bytes = width / 8;
                    if (width % 8 != 0) {
                        ++bytes;
                    }
                    byte[] row = new byte[bytes];
                    for (int y = 0; y < height; ++y) {
                        inflater.inflate(new byte[1]);
                        inflater.inflate(row);
                        for (int x = 0; x < bytes; ++x) {
                            byte colorset = row[x];
                            for (int sh = 0; sh < 8 && x * 8 + sh < width; ++sh) {
                                if ((colorset & 0x80) == 128) {
                                    this.setColors(result, x * 8 + sh, y, white);
                                } else {
                                    this.setColors(result, x * 8 + sh, y, black);
                                }
                                colorset = (byte)(colorset << 1);
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    byte[] row = new byte[width];
                    for (int y = 0; y < height; ++y) {
                        inflater.inflate(new byte[1]);
                        inflater.inflate(row);
                        for (int x = 0; x < width; ++x) {
                            colors[0] = row[x];
                            colors[1] = colors[0];
                            colors[2] = colors[0];
                            this.setColors(result, x, y, colors);
                        }
                    }
                    break;
                }
                case 2: {
                    byte[] row = new byte[width * 3];
                    for (int y = 0; y < height; ++y) {
                        inflater.inflate(new byte[1]);
                        inflater.inflate(row);
                        for (int x = 0; x < width; ++x) {
                            colors[0] = row[x * 3 + 0] & 0xFF;
                            colors[1] = row[x * 3 + 1] & 0xFF;
                            colors[2] = row[x * 3 + 2] & 0xFF;
                            this.setColors(result, x, y, colors);
                        }
                    }
                    break;
                }
            }
        }
        catch (DataFormatException e) {
            throw new JemmyException("ZIP error", e);
        }
        this.readInt();
        this.readInt();
        byte[] iend = this.read(4);
        this.checkEquality(iend, "IEND".getBytes());
        this.readInt();
        if (closeStream) {
            this.in.close();
        }
        return result;
    }

    private void setColors(WriteableRaster raster, int x, int y, int[] colors) {
        Raster.Component[] supported = raster.getSupported();
        double[] imageColors = new double[supported.length];
        for (int i = 0; i < supported.length; ++i) {
            imageColors[i] = supported[i] == Raster.Component.ALPHA ? 1.0 : (double)colors[PixelImageComparator.arrayIndexOf(PNGSaver.RGB, supported[i])] / 255.0;
        }
        raster.setColors(x, y, imageColors);
    }
}

