/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.item.Attribute;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.JfrLoaderToolkit;
import org.openjdk.jmc.flightrecorder.writer.api.Recording;
import org.openjdk.jmc.flightrecorder.writer.api.Recordings;
import org.openjdk.jmc.flightrecorder.writer.api.Type;
import org.openjdk.jmc.flightrecorder.writer.api.TypedField;
import org.openjdk.jmc.flightrecorder.writer.api.TypedValue;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

class ChunkComplexTest {
    private Recording recording;
    private Path jfrPath;
    public static final String EVENT_NAME = "sample event";
    public static final String EVENT_MSG = "Hello world";

    ChunkComplexTest() {
    }

    @BeforeEach
    void setup() throws Exception {
        this.jfrPath = Files.createTempFile("jfr-writer-test-", ".jfr", new FileAttribute[0]);
        this.recording = Recordings.newRecording((Path)this.jfrPath);
    }

    @AfterEach
    void teardown() throws Exception {
        this.recording.close();
        Files.deleteIfExists(this.jfrPath);
    }

    @Test
    void writeEvent() throws Exception {
        Types types = this.recording.getTypes();
        TypedField nameField = types.fieldBuilder("name", Types.Builtin.STRING).build();
        Type customSimpleType = this.recording.registerType("com.datadog.types.Simple", b -> b.addField("message", (Types.Predefined)Types.Builtin.STRING));
        TypedField messageField = types.fieldBuilder("message", customSimpleType).build();
        Type eventType = this.recording.registerEventType("dd.SampleEvent", eventTypeBuilder -> eventTypeBuilder.addFields(nameField, messageField, new TypedField[0]).addAnnotation((Types.Predefined)Types.JDK.ANNOTATION_CATEGORY, builder -> builder.putField("value", new String[]{"cat1", "cat2", "cat3"})));
        TypedValue eventValue = eventType.asValue(access -> access.putField("startTime", System.nanoTime()).putField("name", EVENT_NAME).putField("message", EVENT_MSG).putField("eventThread", threadAccess -> threadAccess.putField("osName", "Java AWT-0").putField("osThreadId", 41953L).putField("javaName", "AWT-0").putField("javaThreadId", 11L).putField("group", groupAcess -> groupAcess.putField("name", "Main AWT Group"))).putField("stackTrace", builder -> builder.putField("truncated", false).putFields("frames", frame1 -> frame1.putField("type", "Interpreted").putField("method", method -> method.putField("type", classType -> classType.putField("name", "com.datadoghq.test.Main").putField("package", pkg -> pkg.putField("name", "com.datadoghq.test")).putField("modifiers", 17)).putField("name", "main").putField("descriptor", "([Ljava/lang/String;)V").putField("modifiers", 25)), frame2 -> frame2.putField("type", "JIT compiled").putField("method", method -> method.putField("type", classType -> classType.putField("name", "com.datadoghq.test.Main").putField("package", pkg -> pkg.putField("name", "com.datadoghq.test")).putField("modifiers", 17)).putField("name", "doit").putField("descriptor", "(Ljava/lang/String;)V").putField("modifiers", 26)), new Consumer[0])));
        this.recording.writeEvent(eventValue).rotateChunk().writeEvent(eventValue).close();
        IItemCollection events = JfrLoaderToolkit.loadEvents((File)this.jfrPath.toFile());
        IAttribute nameAttr = Attribute.attr((String)"name", (String)"name", (ContentType)UnitLookup.PLAIN_TEXT);
        IAttribute msgAttr = Attribute.attr((String)"message", (String)"message", (ContentType)UnitLookup.PLAIN_TEXT);
        Assertions.assertTrue((boolean)events.hasItems());
        int[] eventCount = new int[]{0};
        events.forEach(iitem -> {
            IMemberAccessor stackTraceAccessor = JfrAttributes.EVENT_STACKTRACE.getAccessor(iitem.getType());
            IMemberAccessor nameAcessor = nameAttr.getAccessor(iitem.getType());
            IMemberAccessor msgAcessor = msgAttr.getAccessor(iitem.getType());
            IMemberAccessor eventThreadAccessor = JfrAttributes.EVENT_THREAD.getAccessor(iitem.getType());
            IMemberAccessor startTimeAccessor = JfrAttributes.START_TIME.getAccessor(iitem.getType());
            iitem.forEach(item -> {
                eventCount[0] = eventCount[0] + 1;
                Assertions.assertEquals((Object)EVENT_NAME, (Object)nameAcessor.getMember(item));
                Assertions.assertEquals((Object)EVENT_MSG, (Object)msgAcessor.getMember(item));
                Assertions.assertNotNull((Object)eventThreadAccessor.getMember(item));
                IMCStackTrace stackTrace = (IMCStackTrace)stackTraceAccessor.getMember(item);
                Assertions.assertEquals((int)2, (int)stackTrace.getFrames().size());
                System.out.println(((IQuantity)startTimeAccessor.getMember(item)).interactiveFormat());
            });
        });
        Assertions.assertEquals((int)2, (int)eventCount[0]);
    }
}

