/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test;

import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.test.mock.item.MockCollections;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceModel;
import org.openjdk.jmc.flightrecorder.test.util.MockStacktraceGenerator;

public class StacktraceModelTest {
    private static final boolean TRUNCATED_FALSE = false;
    private static final boolean TRUNCATED_TRUE = true;
    private static final boolean RECURSIVE_FALSE = false;
    private static final boolean RECURSIVE_TRUE = true;
    private static final boolean THREAD_ROOT_ON_TOP_FALSE = false;
    private static final boolean THREAD_ROOT_ON_TOP_TRUE = true;
    private static final boolean DISTINGUISH_FRAMES_BY_OPTIMIZATION_FALSE = false;
    private static final boolean DISTINGUISH_FRAMES_BY_OPTIMIZATION_TRUE = true;
    private static final FrameSeparator.FrameCategorization NO_FRAME_CATEGORIZATION = null;

    @Test
    public void testSingleFrame() {
        IItemCollection items = MockCollections.getStackTraceCollection((IMCStackTrace[])MockStacktraceGenerator.generateTraces(false, false, 0, NO_FRAME_CATEGORIZATION, false));
        StacktraceModel smModel = new StacktraceModel(false, new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false), items);
        StacktraceModel.Fork root = smModel.getRootFork();
        Assert.assertEquals((long)1L, (long)root.getBranchCount());
        StacktraceModel.Branch branch = root.getBranch(0);
        Assert.assertEquals((Object)branch.getFirstFrame(), (Object)branch.getLastFrame());
    }

    @Test
    public void testTwoFrames() {
        IItemCollection items = MockCollections.getStackTraceCollection((IMCStackTrace[])MockStacktraceGenerator.generateTraces(false, false, 1, NO_FRAME_CATEGORIZATION, false));
        StacktraceModel smModel = new StacktraceModel(false, new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false), items);
        StacktraceModel.Fork root = smModel.getRootFork();
        Assert.assertEquals((long)1L, (long)root.getBranchCount());
        StacktraceModel.Branch branch = root.getBranch(0);
        Assert.assertTrue((boolean)branch.hasTail());
        Assert.assertEquals((long)1L, (long)branch.getTailFrames().length);
        Assert.assertNotEquals((Object)branch.getFirstFrame(), (Object)branch.getLastFrame());
    }

    @Test
    public void testManyFrames() {
        IItemCollection items = MockCollections.getStackTraceCollection((IMCStackTrace[])MockStacktraceGenerator.generateTraces(false, false, 1000, NO_FRAME_CATEGORIZATION, false));
        StacktraceModel smModel = new StacktraceModel(false, new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false), items);
        StacktraceModel.Fork root = smModel.getRootFork();
        Assert.assertEquals((long)1L, (long)root.getBranchCount());
        StacktraceModel.Branch branch = root.getBranch(0);
        Assert.assertTrue((boolean)branch.hasTail());
        Assert.assertEquals((long)1000L, (long)branch.getTailFrames().length);
    }

    @Test
    public void testTruncated() {
        IItemCollection items = MockCollections.getStackTraceCollection((IMCStackTrace[])MockStacktraceGenerator.generateTraces(true, false, 0, NO_FRAME_CATEGORIZATION, false));
        StacktraceModel smModel = new StacktraceModel(true, new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false), items);
        StacktraceModel.Fork root = smModel.getRootFork();
        Assert.assertEquals((long)1L, (long)root.getBranchCount());
        StacktraceModel.Branch branch = root.getBranch(0);
        Assert.assertEquals((Object)StacktraceModel.UNKNOWN_FRAME, (Object)branch.getLastFrame().getFrame());
    }

    @Test
    public void testRecursive() {
        IItemCollection items = MockCollections.getStackTraceCollection((IMCStackTrace[])MockStacktraceGenerator.generateTraces(false, true, 0, FrameSeparator.FrameCategorization.METHOD, false));
        StacktraceModel smModel = new StacktraceModel(true, new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false), items);
        StacktraceModel.Fork root = smModel.getRootFork();
        Assert.assertEquals((long)1L, (long)root.getBranchCount());
        StacktraceModel.Branch branch = root.getBranch(0);
        Assert.assertNotEquals((Object)branch.getFirstFrame(), (Object)branch.getLastFrame());
        Assert.assertEquals((Object)branch.getFirstFrame().getFrame(), (Object)branch.getLastFrame().getFrame());
    }

    @Test
    public void testDifferentBCIDontSeparate() {
        IItemCollection items = MockCollections.getStackTraceCollection((IMCStackTrace[])MockStacktraceGenerator.generateTraces(false, false, 0, FrameSeparator.FrameCategorization.BCI, false));
        StacktraceModel smModel = new StacktraceModel(false, new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false), items);
        StacktraceModel.Fork root = smModel.getRootFork();
        Assert.assertEquals((long)1L, (long)root.getBranchCount());
    }

    @Test
    public void testDifferentBCISeparate() {
        IItemCollection items = MockCollections.getStackTraceCollection((IMCStackTrace[])MockStacktraceGenerator.generateTraces(false, false, 0, FrameSeparator.FrameCategorization.BCI, false));
        StacktraceModel smModel = new StacktraceModel(false, new FrameSeparator(FrameSeparator.FrameCategorization.BCI, false), items);
        StacktraceModel.Fork root = smModel.getRootFork();
        Assert.assertEquals((long)2L, (long)root.getBranchCount());
    }

    @Test
    public void testDifferentLineNumberSeparate() {
        IItemCollection items = MockCollections.getStackTraceCollection((IMCStackTrace[])MockStacktraceGenerator.generateTraces(false, false, 0, FrameSeparator.FrameCategorization.LINE, false));
        StacktraceModel smModel = new StacktraceModel(false, new FrameSeparator(FrameSeparator.FrameCategorization.LINE, false), items);
        StacktraceModel.Fork root = smModel.getRootFork();
        Assert.assertEquals((long)2L, (long)root.getBranchCount());
    }

    @Test
    public void testDifferentFrameTypeDontSeparate() {
        IItemCollection items = MockCollections.getStackTraceCollection((IMCStackTrace[])MockStacktraceGenerator.generateTraces(false, false, 0, NO_FRAME_CATEGORIZATION, true));
        StacktraceModel smModel = new StacktraceModel(false, new FrameSeparator(FrameSeparator.FrameCategorization.LINE, false), items);
        StacktraceModel.Fork root = smModel.getRootFork();
        Assert.assertEquals((long)1L, (long)root.getBranchCount());
    }

    @Test
    public void testDifferentFrameTypeSeparate() {
        IItemCollection items = MockCollections.getStackTraceCollection((IMCStackTrace[])MockStacktraceGenerator.generateTraces(false, false, 0, FrameSeparator.FrameCategorization.LINE, true));
        StacktraceModel smModel = new StacktraceModel(false, new FrameSeparator(FrameSeparator.FrameCategorization.LINE, true), items);
        StacktraceModel.Fork root = smModel.getRootFork();
        Assert.assertEquals((long)2L, (long)root.getBranchCount());
    }
}

