/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.provisioning;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sisu.equinox.launching.BundleStartLevel;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationDescription;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.DefaultArtifactDescriptor;

public class ProvisionedInstallationDescription
implements EquinoxInstallationDescription {
    private File location;
    private ArtifactDescriptor systemBundleDescriptor;
    private BundleReader bundleReader;

    ProvisionedInstallationDescription(File location, BundleReader bundleReader) {
        this.location = location;
        this.bundleReader = bundleReader;
    }

    public ArtifactDescriptor getSystemBundle() {
        if (this.systemBundleDescriptor != null) {
            return this.systemBundleDescriptor;
        }
        File pluginsDir = new File(this.location, "plugins");
        File[] systemBundles = pluginsDir.listFiles(file -> file.isFile() && file.getName().startsWith("org.eclipse.osgi_"));
        if (systemBundles.length == 0) {
            throw new IllegalArgumentException("No framework bundle org.eclipse.osgi found in " + pluginsDir);
        }
        if (systemBundles.length > 1) {
            throw new IllegalArgumentException("Multiple versions of the framework bundle org.eclipse.osgi found in " + pluginsDir);
        }
        File systemBundle = systemBundles[0];
        String version = this.bundleReader.loadManifest(systemBundle).getBundleVersion();
        DefaultArtifactKey systemBundleKey = new DefaultArtifactKey("eclipse-plugin", "org.eclipse.osgi", version);
        this.systemBundleDescriptor = new DefaultArtifactDescriptor((ArtifactKey)systemBundleKey, systemBundle, null, null, null);
        return this.systemBundleDescriptor;
    }

    public List<File> getFrameworkExtensions() {
        return Collections.emptyList();
    }

    public Set<String> getBundlesToExplode() {
        return Collections.emptySet();
    }

    public Map<String, BundleStartLevel> getBundleStartLevel() {
        return Collections.emptyMap();
    }

    public Map<String, String> getPlatformProperties() {
        return Collections.emptyMap();
    }

    public Map<String, String> getDevEntries() {
        return Collections.emptyMap();
    }

    public List<ArtifactDescriptor> getBundles() {
        throw new UnsupportedOperationException();
    }

    public ArtifactDescriptor getBundle(String symbolicName, String highestVersion) {
        throw new UnsupportedOperationException();
    }

    public void addBundle(ArtifactKey key, File basedir) {
        throw new UnsupportedOperationException();
    }

    public void addBundle(ArtifactKey key, File basedir, boolean override) {
        throw new UnsupportedOperationException();
    }

    public void addBundle(ArtifactDescriptor artifact) {
        throw new UnsupportedOperationException();
    }

    public void addFrameworkExtensions(List<File> frameworkExtensions) {
        throw new UnsupportedOperationException();
    }

    public void addBundlesToExplode(List<String> bundlesToExplode) {
        throw new UnsupportedOperationException();
    }

    public void addBundleStartLevel(BundleStartLevel level) {
        throw new UnsupportedOperationException();
    }

    public void addPlatformProperty(String property, String value) {
        throw new UnsupportedOperationException();
    }

    public void addDevEntries(String id, String entries) {
        throw new UnsupportedOperationException();
    }

    public BundleStartLevel getDefaultBundleStartLevel() {
        return null;
    }

    public void setDefaultBundleStartLevel(BundleStartLevel defaultBundleStartLevel) {
        throw new UnsupportedOperationException();
    }
}

