/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.provisioning;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;

public class BundlesPublisher {
    private P2ApplicationLauncher launcher;
    private List<File> bundles = new ArrayList<File>();
    private File workingDir;
    private int timeoutInSeconds = 300;
    private Logger log;

    public BundlesPublisher(P2ApplicationLauncher launcher, Logger log) {
        this.launcher = launcher;
        this.log = log;
    }

    public void addBundle(File bundle) {
        this.bundles.add(bundle);
    }

    public void setTimeout(int timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public URI publishBundles(File targetDirectory) throws IOException, MojoFailureException, MojoExecutionException {
        if (this.bundles.isEmpty()) {
            throw new MojoExecutionException("No bundles to be published");
        }
        File pluginsDir = new File(targetDirectory, "plugins");
        pluginsDir.mkdirs();
        for (File bundle : this.bundles) {
            FileUtils.copyFileToDirectory((File)bundle, (File)pluginsDir);
        }
        this.log.info("Publishing " + this.bundles.size() + " bundles to " + targetDirectory);
        this.launcher.setWorkingDirectory(this.workingDir);
        this.launcher.setApplicationName("org.eclipse.equinox.p2.publisher.FeaturesAndBundlesPublisher");
        this.launcher.addArguments(new String[]{"-artifactRepository", targetDirectory.toURI().toString(), "-metadataRepository", targetDirectory.toURI().toString(), "-compress", "-publishArtifacts", "-source", targetDirectory.toString()});
        int result = this.launcher.execute(this.timeoutInSeconds);
        if (result != 0) {
            throw new MojoFailureException("P2 publisher return code was " + result);
        }
        return targetDirectory.toURI();
    }
}

