/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.IDescribable;
import org.openjdk.jmc.common.item.IAccessorKey;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.MemberAccessorToolkit;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class TimeRangeFilterTest {
    @Test
    public void intersects() {
        long start1 = System.currentTimeMillis();
        long end1 = start1 + 1000L;
        MockEventItem item1 = new MockEventItem((IQuantity)UnitLookup.EPOCH_MS.quantity(start1), (IQuantity)UnitLookup.EPOCH_MS.quantity(end1));
        IItemFilter timeRange = RulesToolkit.createRangeFilter((IItem)item1);
        long start2 = start1 - 100L;
        long end2 = start2 + 1000L;
        MockEventItem item2 = new MockEventItem((IQuantity)UnitLookup.EPOCH_MS.quantity(start2), (IQuantity)UnitLookup.EPOCH_MS.quantity(end2));
        Assert.assertTrue((boolean)timeRange.getPredicate((IType)item2).test(item2));
        start2 = start1 + 100L;
        end2 = start2 + 1000L;
        item2 = new MockEventItem((IQuantity)UnitLookup.EPOCH_MS.quantity(start2), (IQuantity)UnitLookup.EPOCH_MS.quantity(end2));
        Assert.assertTrue((boolean)timeRange.getPredicate((IType)item2).test(item2));
    }

    private static class MockEventItem
    implements IItem,
    IType<IItem> {
        private IQuantity startTime;
        private IQuantity endTime;

        public MockEventItem(IQuantity startTime, IQuantity endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public IType<IItem> getType() {
            return this;
        }

        public String getName() {
            return "MockEventItem";
        }

        public String getDescription() {
            return "MockEventItem";
        }

        public List<IAttribute<?>> getAttributes() {
            return Collections.emptyList();
        }

        public Map<IAccessorKey<?>, ? extends IDescribable> getAccessorKeys() {
            return Collections.emptyMap();
        }

        public boolean hasAttribute(ICanonicalAccessorFactory<?> attribute) {
            return false;
        }

        public <M> IMemberAccessor<M, IItem> getAccessor(IAccessorKey<M> attribute) {
            if (attribute.getIdentifier().equals(JfrAttributes.START_TIME.getIdentifier())) {
                return MemberAccessorToolkit.constant((Object)this.startTime);
            }
            if (attribute.getIdentifier().equals(JfrAttributes.END_TIME.getIdentifier())) {
                return MemberAccessorToolkit.constant((Object)this.endTime);
            }
            return null;
        }

        public String getIdentifier() {
            return null;
        }
    }
}

