/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.openjdk.jmc.flightrecorder.writer.BuiltinType;
import org.openjdk.jmc.flightrecorder.writer.CompositeTypeImpl;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.LEB128Writer;
import org.openjdk.jmc.flightrecorder.writer.ResolvableType;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeStructureImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Annotation;
import org.openjdk.jmc.flightrecorder.writer.api.NamedType;
import org.openjdk.jmc.flightrecorder.writer.api.TypedFieldValue;
import org.openjdk.jmc.flightrecorder.writer.api.TypedValue;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

final class MetadataImpl {
    private static final String CLASS_KEY = "class";
    private static final String FIELD_KEY = "field";
    private static final String NAME_KEY = "name";
    private static final String ID_KEY = "id";
    private static final String VALUE_KEY = "value";
    private static final String SUPER_TYPE_KEY = "superType";
    private static final String CONSTANT_POOL_KEY = "constantPool";
    private static final String SIMPLE_TYPE_KEY = "simpleType";
    private static final String ROOT_KEY = "root";
    private static final String METADATA_KEY = "metadata";
    private static final String TRUE_VALUE = "true";
    private static final String REGION_KEY = "region";
    private static final String DIMENSION_KEY = "dimension";
    private static final String ANNOTATION_KEY = "annotation";
    private static final String VAL_1_VALUE = "1";
    private final AtomicLong typeCounter = new AtomicLong(1L);
    private final ConstantPools constantPools;
    private final Map<String, TypeImpl> metadata = new ConcurrentHashMap<String, TypeImpl>();
    private final Map<String, Integer> stringTable = new ConcurrentHashMap<String, Integer>();
    private final Map<Integer, String> reverseStringTable = new ConcurrentSkipListMap<Integer, String>();
    private final Set<ResolvableType> unresolvedTypes = new CopyOnWriteArraySet<ResolvableType>();
    private volatile TypesImpl types = null;

    MetadataImpl(ConstantPools constantPools) {
        this.constantPools = constantPools;
        this.fillStrings();
    }

    void setTypes(TypesImpl types) {
        this.types = types;
    }

    ConstantPools getConstantPools() {
        return this.constantPools;
    }

    private void fillStrings() {
        this.storeString(VAL_1_VALUE);
        this.storeString(CLASS_KEY);
        this.storeString(FIELD_KEY);
        this.storeString(NAME_KEY);
        this.storeString(ID_KEY);
        this.storeString(VALUE_KEY);
        this.storeString(SUPER_TYPE_KEY);
        this.storeString(CONSTANT_POOL_KEY);
        this.storeString(SIMPLE_TYPE_KEY);
        this.storeString(ROOT_KEY);
        this.storeString(METADATA_KEY);
        this.storeString(TRUE_VALUE);
        this.storeString(REGION_KEY);
        this.storeString(DIMENSION_KEY);
        this.storeString(ANNOTATION_KEY);
    }

    public void registerBuiltin(Types.Builtin typeDef) {
        TypeImpl type = this.metadata.computeIfAbsent(typeDef.getTypeName(), this::createBuiltinType);
        this.storeTypeStrings(type);
    }

    TypeImpl registerType(String typeName, String supertype, Supplier<TypeStructureImpl> typeStructureProvider) {
        return this.registerType(typeName, supertype, true, typeStructureProvider);
    }

    TypeImpl registerType(String typeName, String supertype, boolean withConstantPool, Supplier<TypeStructureImpl> typeStructureProvider) {
        TypeImpl registered = this.metadata.computeIfAbsent(typeName, k -> new ResolvableType((String)k, this));
        if (!registered.isResolved()) {
            TypeStructureImpl structure = typeStructureProvider != null ? typeStructureProvider.get() : TypeStructureImpl.EMPTY;
            TypeImpl concreteType = this.createCustomType(typeName, supertype, structure, withConstantPool);
            this.storeTypeStrings(concreteType);
            this.metadata.replace(typeName, registered, concreteType);
            ((ResolvableType)registered).resolve();
            registered = concreteType;
        }
        return registered;
    }

    TypeImpl registerType(String typeName, String supertype, TypeStructureImpl compositeType) {
        return this.registerType(typeName, supertype, true, compositeType);
    }

    TypeImpl registerType(String typeName, String supertype, boolean withConstantPool, TypeStructureImpl compositeType) {
        return this.metadata.computeIfAbsent(typeName, name -> {
            TypeImpl t = this.createCustomType((String)name, supertype, compositeType, withConstantPool);
            this.storeTypeStrings(t);
            return t;
        });
    }

    TypeImpl getType(String name, boolean asResolvable) {
        TypeImpl found = this.metadata.get(name);
        if (found == null && asResolvable) {
            found = new ResolvableType(name, this);
        }
        return found;
    }

    TypeImpl createBuiltinType(String name) {
        if (!Types.Builtin.hasType(name)) {
            throw new IllegalArgumentException();
        }
        Types.Builtin type = Types.Builtin.ofName(name);
        return new BuiltinType(this.typeCounter.getAndIncrement(), type, type == Types.Builtin.STRING ? this.constantPools : null, this.types);
    }

    TypeImpl createCustomType(String name, String supertype, TypeStructureImpl structure, boolean withConstantPool) {
        if (Types.Builtin.hasType(name)) {
            throw new IllegalArgumentException();
        }
        return new CompositeTypeImpl(this.typeCounter.getAndIncrement(), name, supertype, structure, withConstantPool && !"jdk.jfr.Event".equals(supertype) ? this.constantPools : null, this.types);
    }

    TypeImpl getType(NamedType type, boolean asResolvable) {
        return this.getType(type.getTypeName(), asResolvable);
    }

    void addUnresolved(ResolvableType type) {
        this.unresolvedTypes.add(type);
    }

    void resolveTypes() {
        this.unresolvedTypes.removeIf(ResolvableType::resolve);
    }

    private void storeTypeStrings(TypeImpl type) {
        this.storeString(type.getTypeName());
        if (type.getSupertype() != null) {
            this.storeString(type.getSupertype());
        }
        this.storeString(String.valueOf(type.getId()));
        for (TypedFieldImpl field : type.getFields()) {
            this.storeString(field.getName());
            this.storeAnnotationStrings(field.getAnnotations());
        }
        this.storeAnnotationStrings(type.getAnnotations());
    }

    private void storeAnnotationStrings(List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            for (Map.Entry<String, ? extends TypedFieldValue> entry : annotation.getAttributes().entrySet()) {
                TypedFieldValue typedValue = entry.getValue();
                if (typedValue.getField().isArray()) {
                    TypedValue[] vals = typedValue.getValues();
                    for (int i = 0; i < vals.length; ++i) {
                        TypedValue val = vals[i];
                        this.storeString(entry.getKey() + "-" + i);
                        this.storeString(Objects.toString(val.getValue()));
                    }
                    continue;
                }
                Object val = typedValue.getValue() != null ? typedValue.getValue().getValue() : null;
                this.storeString(entry.getKey());
                this.storeString(Objects.toString(val));
            }
        }
    }

    private void storeString(String value) {
        this.stringTable.computeIfAbsent(value, k -> {
            int pointer = this.stringTable.size();
            this.reverseStringTable.put(pointer, (String)k);
            return pointer;
        });
    }

    int stringIndex(String value) {
        Objects.requireNonNull(value);
        return this.stringTable.get(value);
    }

    void writeMetaEvent(LEB128Writer writer, long startTs, long duration) {
        LEB128Writer metaWriter = LEB128Writer.getInstance();
        this.writeMetadataHeader(startTs, duration, metaWriter);
        this.writeStringConstants(metaWriter);
        this.writeTypes(metaWriter);
        this.writeRegion(metaWriter);
        this.writeMetaEventWithSize(metaWriter, writer);
    }

    private void writeMetaEventWithSize(LEB128Writer metaWriter, LEB128Writer writer) {
        int len = metaWriter.length();
        writer.writeInt(len);
        writer.writeBytes(metaWriter.export());
    }

    private void writeRegion(LEB128Writer metaWriter) {
        metaWriter.writeInt(this.stringIndex(REGION_KEY)).writeInt(0).writeInt(0);
    }

    private void writeTypes(LEB128Writer metaWriter) {
        metaWriter.writeInt(this.stringIndex(ROOT_KEY)).writeInt(0).writeInt(2).writeInt(this.stringIndex(METADATA_KEY)).writeInt(0).writeInt(this.metadata.size());
        for (TypeImpl type : this.metadata.values()) {
            this.writeType(metaWriter, type);
        }
    }

    private void writeStringConstants(LEB128Writer metaWriter) {
        for (String text : this.reverseStringTable.values()) {
            metaWriter.writeCompactUTF(text);
        }
    }

    private void writeMetadataHeader(long startTs, long duration, LEB128Writer metaWriter) {
        metaWriter.writeLong(0L).writeLong(startTs).writeLong(duration).writeLong(0L).writeInt(this.stringTable.size());
    }

    private void writeType(LEB128Writer writer, TypeImpl type) {
        int attributes = 2;
        if (type.getSupertype() != null) {
            ++attributes;
        }
        if (type.isSimple()) {
            ++attributes;
        }
        writer.writeInt(this.stringIndex(CLASS_KEY)).writeInt(attributes).writeInt(this.stringIndex(NAME_KEY)).writeInt(this.stringIndex(type.getTypeName())).writeInt(this.stringIndex(ID_KEY)).writeInt(this.stringIndex(String.valueOf(type.getId())));
        if (type.getSupertype() != null) {
            writer.writeInt(this.stringIndex(SUPER_TYPE_KEY)).writeInt(this.stringIndex(type.getSupertype()));
        }
        if (type.isSimple()) {
            writer.writeInt(this.stringIndex(SIMPLE_TYPE_KEY)).writeInt(this.stringIndex(TRUE_VALUE));
        }
        writer.writeInt(type.getFields().size() + type.getAnnotations().size());
        this.writeTypeFields(writer, type);
        this.writeTypeAnnotations(writer, type);
    }

    private void writeTypeFields(LEB128Writer writer, TypeImpl type) {
        for (TypedFieldImpl field : type.getFields()) {
            this.writeField(writer, field);
        }
    }

    private void writeTypeAnnotations(LEB128Writer writer, TypeImpl type) {
        for (Annotation annotation : type.getAnnotations()) {
            this.writeAnnotation(writer, annotation);
        }
    }

    private void writeField(LEB128Writer writer, TypedFieldImpl field) {
        boolean withConstantPool;
        writer.writeInt(this.stringIndex(FIELD_KEY));
        int attrCount = 2;
        boolean bl = withConstantPool = !field.getType().isSame(Types.Builtin.STRING) && field.getType().hasConstantPool();
        if (withConstantPool) {
            ++attrCount;
        }
        if (field.isArray()) {
            ++attrCount;
        }
        writer.writeInt(attrCount).writeInt(this.stringIndex(NAME_KEY)).writeInt(this.stringIndex(field.getName())).writeInt(this.stringIndex(CLASS_KEY)).writeInt(this.stringIndex(String.valueOf(field.getType().getId())));
        if (field.isArray()) {
            writer.writeInt(this.stringIndex(DIMENSION_KEY)).writeInt(this.stringIndex(VAL_1_VALUE));
        }
        if (withConstantPool) {
            writer.writeInt(this.stringIndex(CONSTANT_POOL_KEY)).writeInt(this.stringIndex(TRUE_VALUE));
        }
        this.writeFieldAnnotations(writer, field);
    }

    private void writeFieldAnnotations(LEB128Writer writer, TypedFieldImpl field) {
        writer.writeInt(field.getAnnotations().size());
        for (Annotation annotation : field.getAnnotations()) {
            this.writeAnnotation(writer, annotation);
        }
    }

    private void writeAnnotation(LEB128Writer writer, Annotation annotation) {
        writer.writeInt(this.stringIndex(ANNOTATION_KEY));
        int len = 1 + annotation.getAttributes().size();
        for (TypedFieldValue typedFieldValue : annotation.getAttributes().values()) {
            if (!typedFieldValue.getField().isArray()) continue;
            len += typedFieldValue.getValues().length - 1;
        }
        writer.writeInt(len).writeInt(this.stringIndex(CLASS_KEY)).writeInt(this.stringIndex(String.valueOf(annotation.getType().getId())));
        for (Map.Entry entry : annotation.getAttributes().entrySet()) {
            TypedFieldValue typedValue = (TypedFieldValue)entry.getValue();
            if (typedValue.getField().isArray()) {
                TypedValue[] vals = typedValue.getValues();
                for (int i = 0; i < vals.length; ++i) {
                    TypedValue val = vals[i];
                    writer.writeInt(this.stringIndex((String)entry.getKey() + "-" + i)).writeInt(this.stringIndex(Objects.toString(val.getValue())));
                }
                continue;
            }
            Object val = typedValue.getValue() != null ? typedValue.getValue().getValue() : null;
            writer.writeInt(this.stringIndex((String)entry.getKey())).writeInt(this.stringIndex(Objects.toString(val)));
        }
        writer.writeInt(0);
    }
}

