/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openjdk.jmc.flightrecorder.writer.ConstantPool;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Type;
import org.openjdk.jmc.flightrecorder.writer.util.TypeByUsageComparator;

public final class ConstantPools
implements Iterable<ConstantPool> {
    private final Map<TypeImpl, ConstantPool> constantPoolMap = new ConcurrentHashMap<TypeImpl, ConstantPool>();

    public ConstantPool forType(TypeImpl type) {
        if (!type.hasConstantPool()) {
            throw new IllegalArgumentException();
        }
        return this.constantPoolMap.computeIfAbsent(type, this::newConstantPool);
    }

    public int size() {
        return this.constantPoolMap.size();
    }

    @Override
    public Iterator<ConstantPool> iterator() {
        return this.getOrderedPools().iterator();
    }

    @Override
    public void forEach(Consumer<? super ConstantPool> action) {
        this.getOrderedPoolsStream().forEach(action);
    }

    @Override
    public Spliterator<ConstantPool> spliterator() {
        return this.getOrderedPools().spliterator();
    }

    private Stream<ConstantPool> getOrderedPoolsStream() {
        return this.constantPoolMap.entrySet().stream().sorted((e1, e2) -> TypeByUsageComparator.INSTANCE.compare((Type)e1.getKey(), (Type)e2.getKey())).map(Map.Entry::getValue);
    }

    private List<ConstantPool> getOrderedPools() {
        return this.getOrderedPoolsStream().collect(Collectors.toList());
    }

    private ConstantPool newConstantPool(TypeImpl type) {
        return new ConstantPool(type);
    }

    public String toString() {
        return "ConstantPools [constantPoolMap=" + this.constantPoolMap + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constantPoolMap == null ? 0 : this.constantPoolMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantPools other = (ConstantPools)obj;
        return !(this.constantPoolMap == null ? other.constantPoolMap != null : !this.constantPoolMap.equals(other.constantPoolMap));
    }
}

