/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.jpms;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.languages.java.jpms.CmdModuleNameExtractor;

public class MainClassModuleNameExtractor {
    private final Path jdkHome;

    public MainClassModuleNameExtractor(Path jdkHome) {
        this.jdkHome = jdkHome;
    }

    public <T> Map<T, String> extract(Map<T, Path> files) throws IOException {
        Path workDir = Files.createTempDirectory("plexus-java_jpms-", new FileAttribute[0]);
        String classResourcePath = CmdModuleNameExtractor.class.getName().replace('.', '/') + ".class";
        try (InputStream is = MainClassModuleNameExtractor.class.getResourceAsStream("/META-INF/versions/9/" + classResourcePath);){
            if (is == null) {
                Map map = Collections.emptyMap();
                return map;
            }
            Path target = workDir.resolve(classResourcePath);
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(is, target, new CopyOption[0]);
        }
        var5_5 = null;
        try (BufferedWriter argsWriter = Files.newBufferedWriter(workDir.resolve("args"), Charset.defaultCharset(), new OpenOption[0]);){
            argsWriter.append("--class-path");
            argsWriter.newLine();
            argsWriter.append(".");
            argsWriter.newLine();
            argsWriter.append(CmdModuleNameExtractor.class.getName());
            argsWriter.newLine();
            for (Path p : files.values()) {
                argsWriter.append('\"');
                argsWriter.append(p.toAbsolutePath().toString().replace("\\", "\\\\"));
                argsWriter.append('\"');
                argsWriter.newLine();
            }
        }
        catch (Throwable target) {
            var5_5 = target;
            throw target;
        }
        ProcessBuilder builder = new ProcessBuilder(this.jdkHome.resolve("bin/java").toAbsolutePath().toString(), "@args").directory(workDir.toFile());
        Process p = builder.start();
        Properties output = new Properties();
        InputStream is = p.getInputStream();
        Object object = null;
        try {
            output.load(is);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                MainClassModuleNameExtractor.$closeResource((Throwable)object, is);
            }
        }
        HashMap moduleNames = new HashMap(files.size());
        for (Map.Entry entry : files.entrySet()) {
            moduleNames.put(entry.getKey(), output.getProperty(((Path)entry.getValue()).toAbsolutePath().toString(), null));
        }
        try {
            Files.walkFileTree(workDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return moduleNames;
    }
}

