/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.artifacts.TargetPlatform;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.model.IU;
import org.eclipse.tycho.packaging.AbstractTychoPackagingMojo;
import org.eclipse.tycho.packaging.IUXmlTransformer;

@Mojo(name="package-iu", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class PackageIUMojo
extends AbstractTychoPackagingMojo {
    private static final Object LOCK = new Object();
    @Parameter(property="project.build.directory", required=true, readonly=true)
    protected File outputDirectory;
    @Parameter(property="project.build.outputDirectory")
    private String artifactContentFolder;
    @Parameter(property="project.basedir", required=true, readonly=true)
    private File basedir;
    @Component
    private IUXmlTransformer iuTransformer;
    @Component(role=Archiver.class, hint="zip")
    private ZipArchiver zipArchiver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Object object = LOCK;
        synchronized (object) {
            this.outputDirectory.mkdirs();
            IU iu = IU.loadIU((File)this.basedir);
            File iuXML = new File(this.outputDirectory, "p2iu.xml");
            try {
                this.addSelfCapability(iu);
                this.addArtifactReference(iu);
                this.addMavenProperties(iu);
                this.expandVersions(iu);
                IU.write((IU)iu, (File)iuXML);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error updating p2iu.xml", (Exception)e);
            }
            File artifactForIU = this.createArtifact();
            this.project.getArtifact().setFile(artifactForIU);
        }
    }

    private void addMavenProperties(IU iu) {
        this.iuTransformer.injectMavenProperties(iu, this.project);
    }

    private void addSelfCapability(IU iu) {
        this.iuTransformer.addSelfCapability(iu);
    }

    private void addArtifactReference(IU iu) {
        if (!this.hasPayload()) {
            return;
        }
        if (this.hasArtifactReference(iu)) {
            return;
        }
        iu.addArtifact("binary", iu.getId(), iu.getVersion());
    }

    private void expandVersions(IU iu) throws MojoFailureException {
        this.iuTransformer.replaceSelfQualifiers(iu, DefaultReactorProject.adapt((MavenProject)this.project).getExpandedVersion(), DefaultReactorProject.adapt((MavenProject)this.project).getBuildQualifier());
        this.iuTransformer.replaceQualifierInCapabilities(iu.getProvidedCapabilites(), DefaultReactorProject.adapt((MavenProject)this.project).getBuildQualifier());
        TargetPlatform targetPlatform = TychoProjectUtils.getTargetPlatformIfAvailable((ReactorProject)DefaultReactorProject.adapt((MavenProject)this.project));
        if (targetPlatform == null) {
            this.getLog().warn((CharSequence)"Skipping version reference expansion in p2iu project using the deprecated -Dtycho.targetPlatform configuration");
            return;
        }
        this.iuTransformer.replaceZerosInRequirements(iu, targetPlatform);
        this.iuTransformer.replaceQualifierInRequirements(iu, targetPlatform);
    }

    private boolean hasPayload() {
        return this.getPayloadDir().isDirectory();
    }

    private File createArtifact() throws MojoExecutionException {
        try {
            File payload = this.getPayloadDir();
            File newArtifact = new File(this.outputDirectory, this.project.getArtifactId() + "-" + this.project.getVersion() + ".zip");
            if (newArtifact.exists()) {
                newArtifact.delete();
            }
            if (this.hasPayload()) {
                DefaultFileSet fs = new DefaultFileSet();
                fs.setDirectory(payload);
                this.zipArchiver.addFileSet((FileSet)fs);
                this.zipArchiver.setDestFile(newArtifact);
                this.zipArchiver.setCompress(true);
                this.zipArchiver.createArchive();
            } else {
                newArtifact.createNewFile();
            }
            return newArtifact;
        }
        catch (IOException | ArchiverException e) {
            throw new MojoExecutionException("Error assembling ZIP", (Exception)e);
        }
    }

    private File getPayloadDir() {
        return new File(this.artifactContentFolder);
    }

    private boolean hasArtifactReference(IU iu) {
        return iu.getSelfArtifact() != null;
    }
}

