/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.listeners.discovery;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.listeners.discovery.AbortOnFailureLauncherDiscoveryListener;
import org.junit.platform.launcher.listeners.discovery.CompositeLauncherDiscoveryListener;
import org.junit.platform.launcher.listeners.discovery.LoggingLauncherDiscoveryListener;

@API(status=API.Status.EXPERIMENTAL, since="1.6")
public class LauncherDiscoveryListeners {
    private LauncherDiscoveryListeners() {
    }

    public static LauncherDiscoveryListener abortOnFailure() {
        return new AbortOnFailureLauncherDiscoveryListener();
    }

    public static LauncherDiscoveryListener logging() {
        return new LoggingLauncherDiscoveryListener();
    }

    @API(status=API.Status.INTERNAL, since="1.6")
    public static LauncherDiscoveryListener composite(List<LauncherDiscoveryListener> listeners) {
        Preconditions.notEmpty(listeners, "listeners must not be empty");
        Preconditions.containsNoNullElements(listeners, "listeners must not contain any null elements");
        if (listeners.size() == 1) {
            return listeners.get(0);
        }
        return new CompositeLauncherDiscoveryListener(listeners);
    }

    @API(status=API.Status.INTERNAL, since="1.6")
    public static LauncherDiscoveryListener fromConfigurationParameter(String key, String value) {
        return Arrays.stream(LauncherDiscoveryListenerType.values()).filter(type -> ((LauncherDiscoveryListenerType)type).parameterValue.equalsIgnoreCase(value)).findFirst().map(type -> (LauncherDiscoveryListener)((LauncherDiscoveryListenerType)type).creator.get()).orElseThrow(() -> LauncherDiscoveryListeners.newInvalidConfigurationParameterException(key, value));
    }

    private static JUnitException newInvalidConfigurationParameterException(String key, String value) {
        String allowedValues = Arrays.stream(LauncherDiscoveryListenerType.values()).map(type -> ((LauncherDiscoveryListenerType)type).parameterValue).collect(Collectors.joining("', '", "'", "'"));
        return new JUnitException("Invalid value of configuration parameter '" + key + "': " + value + " (allowed are " + allowedValues + ")");
    }

    private static enum LauncherDiscoveryListenerType {
        LOGGING("logging", LauncherDiscoveryListeners::logging),
        ABORT_ON_FAILURE("abortOnFailure", LauncherDiscoveryListeners::abortOnFailure);

        private final String parameterValue;
        private final Supplier<LauncherDiscoveryListener> creator;

        private LauncherDiscoveryListenerType(String parameterValue, Supplier<LauncherDiscoveryListener> creator) {
            this.parameterValue = parameterValue;
            this.creator = creator;
        }
    }
}

