/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.command.add;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AbstractAddCommand;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.starteam.command.StarteamCommand;
import org.apache.maven.scm.provider.starteam.command.StarteamCommandLineUtils;
import org.apache.maven.scm.provider.starteam.command.add.StarteamAddConsumer;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class StarteamAddCommand
extends AbstractAddCommand
implements StarteamCommand {
    protected ScmResult executeAddCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, boolean binary) throws ScmException {
        String issue = System.getProperty("maven.scm.issue");
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Working directory: " + fileSet.getBasedir().getAbsolutePath());
        }
        StarteamScmProviderRepository repository = (StarteamScmProviderRepository)repo;
        StarteamAddConsumer consumer = new StarteamAddConsumer(this.getLogger(), fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        for (File fileToBeAdded : fileSet.getFileList()) {
            ScmFileSet scmFile = new ScmFileSet(fileSet.getBasedir(), fileToBeAdded);
            Commandline cl = StarteamAddCommand.createCommandLine(repository, scmFile, issue);
            int exitCode = StarteamCommandLineUtils.executeCommandline(cl, consumer, stderr, this.getLogger());
            if (exitCode == 0) continue;
            return new AddScmResult(cl.toString(), "The starteam command failed.", stderr.getOutput(), false);
        }
        return new AddScmResult(null, consumer.getAddedFiles());
    }

    static Commandline createCommandLine(StarteamScmProviderRepository repo, ScmFileSet scmFileSet, String issue) {
        ArrayList<String> args = new ArrayList<String>();
        if (issue != null && issue.length() != 0) {
            args.add("-cr");
            args.add(issue);
        }
        StarteamCommandLineUtils.addEOLOption(args);
        return StarteamCommandLineUtils.createStarteamCommandLine("add", args, scmFileSet, repo);
    }
}

