/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback2;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackResult;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffSource;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgRemoteMergeEditor
implements ISVNEditor {
    private final ISvnDiffCallback2 processor;
    private long targetRevision;
    private long revision;
    private SvnDiffCallbackResult mergeResult;
    private DirectoryBaton currentDirectory;
    private FileBaton currentFile;
    private SVNRepository repository;
    private boolean textDeltas;
    private final Collection<File> tmpFiles;
    private File emptyFile;
    private boolean pureRemoteDiff;
    private File globalTmpDir;
    private SVNWCContext context;
    private File target;

    public SvnNgRemoteMergeEditor(File target, SVNWCContext context, SVNRepository repository, long revision, ISvnDiffCallback2 processor, boolean textDeltas) {
        this.target = target;
        this.context = context;
        this.repository = repository;
        this.revision = revision;
        this.processor = processor;
        this.textDeltas = textDeltas;
        this.mergeResult = new SvnDiffCallbackResult();
        this.tmpFiles = new HashSet<File>();
        this.pureRemoteDiff = target == null;
    }

    public void targetRevision(long revision) throws SVNException {
        this.targetRevision = revision;
    }

    public void openRoot(long revision) throws SVNException {
        DirectoryBaton db = new DirectoryBaton("", null, false, revision);
        db.leftSource = new SvnDiffSource(this.revision);
        db.rightSource = new SvnDiffSource(this.targetRevision);
        this.mergeResult.reset();
        this.processor.dirOpened(this.mergeResult, SVNFileUtil.createFilePath(""), db.leftSource, db.rightSource, null, null);
        db.skip = this.mergeResult.skip;
        db.skipChildren = this.mergeResult.skipChildren;
        db.pdb = this.mergeResult.newBaton;
        this.currentDirectory = db;
    }

    private void diffDeletedFile(String path, DirectoryBaton db) throws SVNException {
        FileBaton fb = new FileBaton(path, db, false);
        boolean skip = false;
        SvnDiffSource leftSource = new SvnDiffSource(this.revision);
        this.checkCancelled();
        this.mergeResult.reset();
        this.processor.fileOpened(this.mergeResult, SVNFileUtil.createFilePath(path), leftSource, null, null, false, db.pdb);
        skip = this.mergeResult.skip;
        this.checkCancelled();
        if (skip) {
            return;
        }
        this.getFileFromRepository(fb, !this.textDeltas);
        this.mergeResult.reset();
        this.processor.fileDeleted(this.mergeResult, SVNFileUtil.createFilePath(fb.path), leftSource, fb.pathStartRevision, fb.pristineProps);
    }

    private void diffDeletedDirectory(String path, DirectoryBaton parentBaton) throws SVNException {
        SvnDiffSource leftSource = new SvnDiffSource(this.revision);
        DirectoryBaton db = new DirectoryBaton(path, parentBaton, false, -1L);
        assert (SVNRevision.isValidRevisionNumber(this.revision));
        this.checkCancelled();
        this.mergeResult.reset();
        this.processor.dirOpened(this.mergeResult, SVNFileUtil.createFilePath(path), leftSource, null, null, parentBaton.pdb);
        boolean skip = this.mergeResult.skip;
        boolean skipChildren = this.mergeResult.skipChildren;
        db.pdb = this.mergeResult.newBaton;
        SVNProperties leftProps = null;
        ArrayList dirEntries = null;
        if (!skip || !skipChildren) {
            dirEntries = skipChildren ? null : new ArrayList();
            leftProps = skip ? null : new SVNProperties();
            this.repository.getDir(path, this.revision, leftProps, 1, dirEntries);
        }
        if (!skipChildren) {
            for (SVNDirEntry dirEntry : dirEntries) {
                String name = dirEntry.getName();
                String childPath = SVNPathUtil.append(path, name);
                if (dirEntry.getKind() == SVNNodeKind.FILE) {
                    this.diffDeletedFile(childPath, db);
                    continue;
                }
                if (dirEntry.getKind() != SVNNodeKind.DIR) continue;
                this.diffDeletedDirectory(childPath, db);
            }
        }
        if (!skip) {
            this.mergeResult.reset();
            this.processor.dirDeleted(this.mergeResult, SVNFileUtil.createFilePath(path), leftSource, leftProps, db.pdb);
        }
    }

    private void checkCancelled() throws SVNCancelException {
        ISVNEventHandler eventHandler = this.context.getEventHandler();
        if (eventHandler != null) {
            eventHandler.checkCancelled();
        }
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        DirectoryBaton parentBaton = this.currentDirectory;
        if (parentBaton.skipChildren) {
            return;
        }
        SVNNodeKind kind = this.repository.checkPath(path, this.revision);
        if (kind == SVNNodeKind.FILE) {
            this.diffDeletedFile(path, parentBaton);
        } else if (kind == SVNNodeKind.DIR) {
            this.diffDeletedDirectory(path, parentBaton);
        }
    }

    public void absentDir(String path) throws SVNException {
        this.mergeResult.reset();
        this.processor.nodeAbsent(this.mergeResult, SVNFileUtil.createFilePath(path), this.currentDirectory.pdb);
    }

    public void absentFile(String path) throws SVNException {
        this.mergeResult.reset();
        this.processor.nodeAbsent(this.mergeResult, SVNFileUtil.createFilePath(path), this.currentDirectory.pdb);
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        DirectoryBaton db;
        DirectoryBaton pb = this.currentDirectory;
        this.currentDirectory = db = new DirectoryBaton(path, pb, true, -1L);
        if (pb.skipChildren) {
            db.skip = true;
            db.skipChildren = true;
            return;
        }
        db.rightSource = new SvnDiffSource(this.targetRevision);
        this.mergeResult.reset();
        this.processor.dirOpened(this.mergeResult, SVNFileUtil.createFilePath(db.path), null, db.rightSource, null, pb.pdb);
        db.skip = this.mergeResult.skip;
        db.skipChildren = this.mergeResult.skipChildren;
        db.pdb = this.mergeResult.newBaton;
    }

    public void openDir(String path, long revision) throws SVNException {
        DirectoryBaton db;
        DirectoryBaton pb = this.currentDirectory;
        this.currentDirectory = db = new DirectoryBaton(path, pb, false, revision);
        if (pb.skipChildren) {
            db.skip = true;
            db.skipChildren = true;
            return;
        }
        db.leftSource = new SvnDiffSource(this.revision);
        db.rightSource = new SvnDiffSource(this.targetRevision);
        this.mergeResult.reset();
        this.processor.dirOpened(this.mergeResult, SVNFileUtil.createFilePath(path), db.leftSource, db.rightSource, null, pb != null ? pb.pdb : null);
        db.skip = this.mergeResult.skip;
        db.skipChildren = this.mergeResult.skipChildren;
        db.pdb = this.mergeResult.newBaton;
    }

    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        DirectoryBaton db = this.currentDirectory;
        if (db.skip) {
            return;
        }
        if (SVNProperty.isWorkingCopyProperty(name)) {
            return;
        }
        if (SVNProperty.isRegularProperty(name)) {
            db.hasPropChange = true;
        }
        if (db.propChanges == null) {
            db.propChanges = new SVNProperties();
        }
        db.propChanges.put(name, value);
    }

    public void closeDir() throws SVNException {
        DirectoryBaton db = this.currentDirectory;
        boolean sendChanged = false;
        if ((db.hasPropChange || db.added) && !db.skip) {
            SVNProperties pristineProps;
            if (db.added) {
                pristineProps = new SVNProperties();
            } else {
                pristineProps = new SVNProperties();
                this.repository.getDir(db.path, db.baseRevision, pristineProps, 0, (Collection)null);
            }
            if (db.propChanges.size() > 0) {
                this.removeNonPropChanges(pristineProps, db.propChanges);
            }
            if (db.propChanges.size() > 0 || db.added) {
                SVNProperties rightProps = new SVNProperties(pristineProps);
                rightProps.putAll(db.propChanges);
                rightProps.removeNullValues();
                if (db.added) {
                    this.mergeResult.reset();
                    this.processor.dirAdded(this.mergeResult, SVNFileUtil.createFilePath(db.path), null, db.rightSource, null, rightProps, db.pdb);
                } else {
                    this.mergeResult.reset();
                    this.processor.dirChanged(this.mergeResult, SVNFileUtil.createFilePath(db.path), db.leftSource, db.rightSource, pristineProps, rightProps, db.propChanges, db.pdb);
                }
                sendChanged = true;
            }
        }
        if (!db.skip && !sendChanged) {
            this.mergeResult.reset();
            this.processor.dirClosed(this.mergeResult, SVNFileUtil.createFilePath(db.path), db.leftSource, db.rightSource, db.pdb);
        }
        this.currentDirectory = this.currentDirectory.parentBaton;
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        FileBaton fb;
        DirectoryBaton pb = this.currentDirectory;
        this.currentFile = fb = new FileBaton(path, pb, true);
        if (pb.skipChildren) {
            fb.skip = true;
            return;
        }
        fb.pristineProps = new SVNProperties();
        fb.rightSource = new SvnDiffSource(this.targetRevision);
        this.mergeResult.reset();
        this.processor.fileOpened(this.mergeResult, SVNFileUtil.createFilePath(path), null, fb.rightSource, null, false, pb.pdb);
        fb.skip = this.mergeResult.skip;
    }

    public void openFile(String path, long revision) throws SVNException {
        FileBaton fb;
        DirectoryBaton pb = this.currentDirectory;
        this.currentFile = fb = new FileBaton(path, pb, false);
        if (pb.skipChildren) {
            fb.skip = true;
            return;
        }
        fb.baseRevision = revision;
        fb.leftSource = new SvnDiffSource(this.revision);
        fb.rightSource = new SvnDiffSource(this.targetRevision);
        this.mergeResult.reset();
        this.processor.fileOpened(this.mergeResult, SVNFileUtil.createFilePath(path), fb.leftSource, fb.rightSource, null, false, pb.pdb);
        fb.skip = this.mergeResult.skip;
    }

    public void changeFileProperty(String path, String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        FileBaton fb = this.currentFile;
        if (fb.skip) {
            return;
        }
        if (SVNProperty.isWorkingCopyProperty(propertyName)) {
            return;
        }
        if (SVNProperty.isRegularProperty(propertyName)) {
            fb.hasPropChange = true;
        }
        if (fb.propChanges == null) {
            fb.propChanges = new SVNProperties();
        }
        fb.propChanges.put(propertyName, propertyValue);
    }

    public void closeFile(String path, String expectedChecksum) throws SVNException {
        FileBaton fb = this.currentFile;
        if (fb.skip) {
            return;
        }
        if (expectedChecksum != null && this.textDeltas && fb.resultChecksum != null && !expectedChecksum.equals(fb.resultChecksum)) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''", (Object)fb.path);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        if (fb.added || fb.pathEndRevision != null || fb.hasPropChange) {
            if (!fb.added && fb.pristineProps == null) {
                this.getFileFromRepository(fb, true);
            }
            if (fb.pristineProps != null) {
                this.removeNonPropChanges(fb.pristineProps, fb.propChanges);
            }
            SVNProperties rightProps = fb.pristineProps == null ? new SVNProperties() : new SVNProperties(fb.pristineProps);
            rightProps.putAll(fb.propChanges);
            rightProps.removeNullValues();
            if (fb.added) {
                this.mergeResult.reset();
                this.processor.fileAdded(this.mergeResult, SVNFileUtil.createFilePath(fb.path), null, fb.rightSource, null, fb.pathEndRevision, null, rightProps);
            } else {
                this.mergeResult.reset();
                boolean contentChanged = fb.baseChecksum == null || !fb.baseChecksum.equals(expectedChecksum);
                File leftFile = fb.pathEndRevision != null && contentChanged ? fb.pathStartRevision : null;
                File pathEndRevision = contentChanged ? fb.pathEndRevision : null;
                this.processor.fileChanged(this.mergeResult, SVNFileUtil.createFilePath(fb.path), fb.leftSource, fb.rightSource, leftFile, pathEndRevision, fb.pristineProps, rightProps, fb.pathEndRevision != null, fb.propChanges);
            }
        }
        this.currentFile = null;
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        this.cleanup();
        return null;
    }

    public void abortEdit() throws SVNException {
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        if (this.currentFile.skip) {
            return;
        }
        this.currentFile.deltaProcessor = new SVNDeltaProcessor();
        if (!this.currentFile.added) {
            this.getFileFromRepository(this.currentFile, false);
        } else {
            this.currentFile.pathStartRevision = this.getEmptyFile();
        }
        this.currentFile.pathEndRevision = this.createUniqueFile(SVNPathUtil.tail(path));
        this.tmpFiles.add(this.currentFile.pathEndRevision);
        this.currentFile.baseChecksum = baseChecksum;
        this.currentFile.deltaProcessor.applyTextDelta(this.currentFile.pathStartRevision, this.currentFile.pathEndRevision, true);
    }

    private File getEmptyFile() throws SVNException {
        if (this.emptyFile == null) {
            this.emptyFile = this.createUniqueFile("empty");
            this.tmpFiles.add(this.emptyFile);
        }
        return this.emptyFile;
    }

    private File createUniqueFile(String name) throws SVNException {
        File tmpDir = this.pureRemoteDiff ? this.getGlobalTmpDir() : this.context.getDb().getWCRootTempDir(this.target);
        return SVNFileUtil.createUniqueFile(tmpDir, name, ".tmp", false);
    }

    public File getGlobalTmpDir() throws SVNException {
        if (this.globalTmpDir == null) {
            this.globalTmpDir = SVNFileUtil.createTempDirectory("svndiff");
        }
        return this.globalTmpDir;
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        if (this.currentFile.deltaProcessor != null) {
            return this.currentFile.deltaProcessor.textDeltaChunk(diffWindow);
        }
        return SVNFileUtil.DUMMY_OUT;
    }

    public void textDeltaEnd(String path) throws SVNException {
        if (this.currentFile.deltaProcessor != null) {
            String checksum;
            this.currentFile.resultChecksum = checksum = this.currentFile.deltaProcessor.textDeltaEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFileFromRepository(FileBaton fileBaton, boolean propsOnly) throws SVNException {
        block3: {
            if (!propsOnly) {
                fileBaton.pathStartRevision = this.createUniqueFile(SVNPathUtil.tail(fileBaton.path));
                OutputStream outputStream = SVNFileUtil.openFileForWriting(fileBaton.pathStartRevision);
                try {
                    fileBaton.pristineProps = new SVNProperties();
                    this.repository.getFile(fileBaton.path, fileBaton.baseRevision, fileBaton.pristineProps, outputStream);
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    SVNFileUtil.closeFile(outputStream);
                    throw throwable;
                }
                SVNFileUtil.closeFile(outputStream);
                {
                    break block3;
                }
            }
            fileBaton.pristineProps = new SVNProperties();
            this.repository.getFile(fileBaton.path, fileBaton.baseRevision, fileBaton.pristineProps, null);
        }
    }

    private void removeNonPropChanges(SVNProperties pristineProps, SVNProperties propChanges) {
        Iterator<String> iterator = propChanges.nameSet().iterator();
        while (iterator.hasNext()) {
            SVNPropertyValue oldValue;
            String propName = iterator.next();
            SVNPropertyValue propertyValue = propChanges.getSVNPropertyValue(propName);
            if (propertyValue == null || (oldValue = pristineProps.getSVNPropertyValue(propName)) == null || !oldValue.equals(propertyValue)) continue;
            iterator.remove();
        }
    }

    public void cleanup() {
        for (File tmpFile : this.tmpFiles) {
            try {
                SVNFileUtil.deleteFile(tmpFile);
            }
            catch (SVNException sVNException) {}
        }
        if (this.globalTmpDir != null) {
            SVNFileUtil.deleteAll(this.globalTmpDir, true);
        }
    }

    private class FileBaton {
        private String path;
        private DirectoryBaton parentBaton;
        private boolean added;
        private boolean treeConflicted;
        private boolean skip;
        private File pathStartRevision;
        private File pathEndRevision;
        private SVNProperties pristineProps;
        private long baseRevision;
        private SvnDiffSource leftSource;
        private SvnDiffSource rightSource;
        public boolean hasPropChange;
        public SVNProperties propChanges;
        public String baseChecksum;
        public String resultChecksum;
        public SVNDeltaProcessor deltaProcessor;

        private FileBaton(String path, DirectoryBaton parentBaton, boolean added) {
            this.path = path;
            this.parentBaton = parentBaton;
            this.added = added;
            this.baseRevision = SvnNgRemoteMergeEditor.this.revision;
        }
    }

    private class DirectoryBaton {
        private String path;
        private boolean added;
        private boolean treeConflicted;
        private boolean skip;
        private boolean skipChildren;
        private DirectoryBaton parentBaton;
        private SVNProperties propChanges;
        private boolean hasPropChange;
        private SvnDiffSource leftSource;
        private SvnDiffSource rightSource;
        private long baseRevision;
        private Object pdb;

        private DirectoryBaton(String path, DirectoryBaton parentBaton, boolean added, long baseRevision) {
            this.path = path;
            this.parentBaton = parentBaton;
            this.added = added;
            this.baseRevision = baseRevision;
            this.skip = false;
            this.skipChildren = false;
            this.propChanges = new SVNProperties();
            this.baseRevision = SvnNgRemoteMergeEditor.this.revision;
        }
    }
}

