/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNAmbientDepthFilterEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNReporter17;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback2;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackWrapper;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffEditor;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffStatusReceiver;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnFilterDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgDiffUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemoteDiffEditor2;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnReverseOrderDiffCallback;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnDiff;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgDiff
extends SvnNgOperationRunner<Void, SvnDiff> {
    @Override
    public SvnWcGeneration getWcGeneration() {
        return SvnWcGeneration.NOT_DETECTED;
    }

    @Override
    public boolean isApplicable(SvnDiff operation, SvnWcGeneration wcGeneration) throws SVNException {
        if (operation.getSource() != null) {
            return !operation.getSource().isFile() || wcGeneration == SvnWcGeneration.V17;
        }
        if (operation.getFirstSource().isFile() && wcGeneration != SvnWcGeneration.V17) {
            return false;
        }
        return !operation.getSecondSource().isFile() || wcGeneration == SvnWcGeneration.V17;
    }

    @Override
    protected Void run(SVNWCContext context) throws SVNException {
        if (this.isPeggedDiff()) {
            SvnTarget target = ((SvnDiff)this.getOperation()).getSource();
            SVNRevision revision1 = ((SvnDiff)this.getOperation()).getStartRevision();
            SVNRevision revision2 = ((SvnDiff)this.getOperation()).getEndRevision();
            SVNRevision pegRevision = target.getPegRevision();
            this.doDiff(target, revision1, pegRevision, target, revision2);
        } else {
            SvnTarget target1 = ((SvnDiff)this.getOperation()).getFirstSource();
            SvnTarget target2 = ((SvnDiff)this.getOperation()).getSecondSource();
            SVNRevision revision1 = target1.getPegRevision();
            SVNRevision revision2 = target2.getPegRevision();
            SVNRevision pegRevision = SVNRevision.UNDEFINED;
            this.doDiff(target1, revision1, pegRevision, target2, revision2);
        }
        return null;
    }

    private void doDiff(SvnTarget target1, SVNRevision revision1, SVNRevision pegRevision, SvnTarget target2, SVNRevision revision2) throws SVNException {
        boolean isRepos2;
        boolean isRepos1;
        boolean isLocalRev2;
        if (revision1 == SVNRevision.UNDEFINED || revision2 == SVNRevision.UNDEFINED) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all required revisions are specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        boolean isLocalRev1 = revision1 == SVNRevision.BASE || revision1 == SVNRevision.WORKING;
        boolean bl = isLocalRev2 = revision2 == SVNRevision.BASE || revision2 == SVNRevision.WORKING;
        if (pegRevision != SVNRevision.UNDEFINED) {
            if (isLocalRev1 && isLocalRev2) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "At least one revision must be non-local for a pegged diff");
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            isRepos1 = !isLocalRev1;
            isRepos2 = !isLocalRev2;
        } else {
            isRepos1 = !isLocalRev1 || target1.isURL();
            boolean bl2 = isRepos2 = !isLocalRev2 || target2.isURL();
        }
        if (isRepos1) {
            if (isRepos2) {
                this.doDiffReposRepos(target1, revision1, pegRevision, target2, revision2);
            } else {
                this.doDiffReposWC(target1, revision1, pegRevision, target2, revision2, false);
            }
        } else if (isRepos2) {
            this.doDiffReposWC(target2, revision2, pegRevision, target1, revision1, true);
        } else if (revision1 == SVNRevision.WORKING && revision2 == SVNRevision.WORKING) {
            ISvnDiffGenerator generator = this.getDiffGenerator();
            generator.setOriginalTargets(target1, target2);
            generator.setAnchors(target1, target2);
            SvnNgDiffUtil.doArbitraryNodesDiff(target1, target2, ((SvnDiff)this.getOperation()).getDepth(), this.getWcContext(), this.createDiffCallback(generator, false, -1L, -1L), ((SvnDiff)this.getOperation()).getEventHandler());
        } else {
            this.doDiffWCWC(target1, revision1, target2, revision2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffReposRepos(SvnTarget svnTarget1, SVNRevision revision1, SVNRevision pegRevision, SvnTarget svnTarget2, SVNRevision revision2) throws SVNException {
        boolean isRepos2;
        boolean isRepos1;
        SVNErrorMessage err;
        boolean isLocalRev2;
        SVNURL url1 = svnTarget1.getURL();
        SVNURL url2 = svnTarget2.getURL();
        File path1 = svnTarget1.getFile();
        File path2 = svnTarget2.getFile();
        if (revision1 == SVNRevision.UNDEFINED || revision2 == SVNRevision.UNDEFINED) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all revisions are specified");
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        boolean isLocalRev1 = revision1 == SVNRevision.BASE || revision1 == SVNRevision.WORKING;
        boolean bl = isLocalRev2 = revision2 == SVNRevision.BASE || revision2 == SVNRevision.WORKING;
        if (pegRevision != SVNRevision.UNDEFINED) {
            if (isLocalRev1 && isLocalRev2) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "At least one revision must be non-local for a pegged diff");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            isRepos1 = !isLocalRev1;
            isRepos2 = !isLocalRev2;
        } else {
            isRepos1 = !isLocalRev1 || url1 != null;
            boolean bl2 = isRepos2 = !isLocalRev2 || url2 != null;
        }
        if (!isRepos1 || !isRepos2) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Summarizing diff can only compare repository to repository");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        File basePath = null;
        if (path1 != null) {
            basePath = path1;
        }
        if (path2 != null) {
            basePath = path2;
        }
        if (pegRevision.isValid()) {
            url2 = this.resolvePeggedDiffTargetUrl(url2, path2, pegRevision, revision2);
            url1 = this.resolvePeggedDiffTargetUrl(url1, path1, pegRevision, revision1);
            if (url2 != null && url1 == null) {
                url1 = url2;
            }
            if (url1 != null && url2 == null) {
                url2 = url1;
            }
        } else {
            url1 = url1 == null ? this.getURL(path1) : url1;
            url2 = url2 == null ? this.getURL(path2) : url2;
        }
        SVNRepository repository1 = this.getRepositoryAccess().createRepository(url1, null, true);
        SVNRepository repository2 = this.getRepositoryAccess().createRepository(url2, null, false);
        long rev1 = this.getRevisionNumber(revision1, repository1, svnTarget1);
        long rev2 = -1L;
        SVNNodeKind kind1 = null;
        SVNNodeKind kind2 = null;
        SVNURL anchor1 = url1;
        SVNURL anchor2 = url2;
        String target1 = "";
        String target2 = "";
        try {
            rev2 = this.getRevisionNumber(revision2, repository2, svnTarget2);
            kind1 = repository1.checkPath("", rev1);
            kind2 = repository2.checkPath("", rev2);
            if (kind1 == SVNNodeKind.NONE && kind2 == SVNNodeKind.NONE) {
                SVNErrorMessage errorMessage;
                if (url1.equals(url2)) {
                    errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff target ''{0}'' was not found in the repository at revisions ''{1}'' and ''{2}''", url1, rev1, rev2);
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                } else {
                    errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff targets ''{0}'' and ''{1}'' were not found in the repository at revisions ''{2}'' and ''{3}''");
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
            } else if (kind1 == SVNNodeKind.NONE) {
                this.checkDiffTargetExists(url1, rev2, rev1, repository1);
            } else if (kind2 == SVNNodeKind.NONE) {
                this.checkDiffTargetExists(url2, rev1, rev2, repository2);
            }
            SVNURL repositoryRoot = repository1.getRepositoryRoot(true);
            if (!url1.equals(repositoryRoot) && !url2.equals(repositoryRoot)) {
                anchor1 = url1.removePathTail();
                anchor2 = url2.removePathTail();
                target1 = SVNPathUtil.tail(url1.toDecodedString());
                target2 = SVNPathUtil.tail(url2.toDecodedString());
            }
            Object var29_28 = null;
            repository2.closeSession();
        }
        catch (Throwable throwable) {
            Object var29_29 = null;
            repository2.closeSession();
            throw throwable;
        }
        boolean nonDir = kind1 != SVNNodeKind.DIR || kind2 != SVNNodeKind.DIR;
        SVNURL repositoryRoot = null;
        ISvnDiffGenerator generator = this.getDiffGenerator();
        generator.setOriginalTargets(SvnTarget.fromURL(url1), SvnTarget.fromURL(url2));
        generator.setAnchors(SvnTarget.fromURL(kind1 == SVNNodeKind.FILE ? anchor1 : url1), SvnTarget.fromURL(kind2 == SVNNodeKind.FILE ? anchor2 : url2));
        if (((SvnDiff)this.getOperation()).isUseGitDiffFormat()) {
            if (repositoryRoot == null) {
                repositoryRoot = repository1.getRepositoryRoot(true);
            }
            generator.setRepositoryRoot(SvnTarget.fromURL(repositoryRoot));
        }
        SvnDiffCallback oldCallback = this.createDiffCallback(generator, false, rev1, rev2);
        ISvnDiffCallback2 callback = new SvnDiffCallbackWrapper(oldCallback, true, basePath != null ? (nonDir ? basePath.getParentFile() : basePath) : new File("").getAbsoluteFile());
        if (kind2 == SVNNodeKind.NONE) {
            SVNURL tmpUrl = url1;
            url1 = url2;
            url2 = tmpUrl;
            long tmpRev = rev1;
            rev1 = rev2;
            rev2 = tmpRev;
            tmpUrl = anchor1;
            anchor1 = anchor2;
            anchor2 = tmpUrl;
            String tmpTarget = target1;
            target1 = target2;
            target2 = tmpTarget;
            callback = new SvnReverseOrderDiffCallback(callback, null);
        }
        if (kind1 != SVNNodeKind.FILE && kind2 != SVNNodeKind.FILE && target1.length() > 0) {
            callback = new SvnFilterDiffCallback(SVNFileUtil.createFilePath(target1), callback);
        }
        repository1.setLocation(anchor1, true);
        repository2.setLocation(anchor1, true);
        SvnNgRemoteDiffEditor2 editor = null;
        try {
            editor = new SvnNgRemoteDiffEditor2(rev1, true, repository2, callback);
            final long finalRev1 = rev1;
            ISVNReporterBaton reporter = new ISVNReporterBaton(){

                public void report(ISVNReporter reporter) throws SVNException {
                    reporter.setPath("", null, finalRev1, SVNDepth.INFINITY, false);
                    reporter.finishReport();
                }
            };
            repository1.diff(url2, rev2, rev1, target1, ((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).getDepth(), true, reporter, SVNCancellableEditor.newInstance(editor, this, SVNDebugLog.getDefaultLog()));
            Object var37_37 = null;
            repository2.closeSession();
            if (editor != null) {
                editor.cleanup();
            }
        }
        catch (Throwable throwable) {
            Object var37_38 = null;
            repository2.closeSession();
            if (editor != null) {
                editor.cleanup();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffReposWC(SvnTarget target1, SVNRevision revision1, SVNRevision pegRevision, SvnTarget target2, SVNRevision revision2, boolean reverse) throws SVNException {
        SvnDiffEditor svnDiffEditor;
        assert (!target2.isURL());
        SVNURL url1 = this.getRepositoryAccess().getTargetURL(target1);
        String target = this.getWcContext().getActualTarget(target2.getFile());
        File anchor = target == null || target.length() == 0 ? target2.getFile() : SVNFileUtil.getParentFile(target2.getFile());
        SVNURL anchorUrl = this.getWcContext().getNodeUrl(anchor);
        if (anchorUrl == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Directory ''{0}'' has no URL", (Object)anchor);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        ISvnDiffGenerator generator = this.getDiffGenerator();
        if (pegRevision != SVNRevision.UNDEFINED) {
            url1 = (SVNURL)this.getRepositoryAccess().getLocations(null, target1, pegRevision, revision1, SVNRevision.UNDEFINED).get(SvnRepositoryAccess.LocationsInfo.startUrl);
            if (!reverse) {
                generator.setOriginalTargets(SvnTarget.fromURL(url1), SvnTarget.fromURL(anchorUrl.appendPath(target, false)));
                generator.setAnchors(SvnTarget.fromURL(url1), SvnTarget.fromURL(anchorUrl.appendPath(target, false)));
            } else {
                generator.setOriginalTargets(SvnTarget.fromURL(anchorUrl.appendPath(target, false)), SvnTarget.fromURL(url1));
                generator.setAnchors(SvnTarget.fromURL(anchorUrl.appendPath(target, false)), SvnTarget.fromURL(url1));
            }
        } else if (!reverse) {
            generator.setOriginalTargets(target1, target2);
            generator.setAnchors(target1, target2);
        } else {
            generator.setOriginalTargets(target2, target1);
            generator.setAnchors(target2, target1);
        }
        SVNRepository repository2 = this.getRepositoryAccess().createRepository(anchorUrl, null, true);
        if (((SvnDiff)this.getOperation()).isUseGitDiffFormat()) {
            File wcRoot = this.getWcContext().getDb().getWCRoot(anchor);
            generator.setRepositoryRoot(SvnTarget.fromFile(wcRoot));
        }
        boolean serverSupportsDepth = repository2.hasCapability(SVNCapability.DEPTH);
        long revisionNumber1 = this.getRepositoryAccess().getRevisionNumber(repository2, url1.equals(target1.getURL()) ? null : target1, revision1, null).lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        SvnDiffCallback callback = this.createDiffCallback(generator, reverse, revisionNumber1, -1L);
        SVNReporter17 reporter = new SVNReporter17(target2.getFile(), this.getWcContext(), false, !serverSupportsDepth, ((SvnDiff)this.getOperation()).getDepth(), false, false, true, false, SVNDebugLog.getDefaultLog());
        boolean revisionIsBase = this.isRevisionBase(revision2);
        ISVNUpdateEditor updateEditor = svnDiffEditor = new SvnDiffEditor(anchor, target, callback, ((SvnDiff)this.getOperation()).getDepth(), this.getWcContext(), reverse, revisionIsBase, ((SvnDiff)this.getOperation()).isShowCopiesAsAdds(), ((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).getApplicableChangelists(), ((SvnDiff)this.getOperation()).isUseGitDiffFormat(), this);
        if (!serverSupportsDepth && ((SvnDiff)this.getOperation()).getDepth() == SVNDepth.UNKNOWN) {
            updateEditor = new SVNAmbientDepthFilterEditor17(updateEditor, this.getWcContext(), anchor, target, revisionIsBase);
        }
        ISVNEditor editor = SVNCancellableEditor.newInstance(updateEditor, this, SVNDebugLog.getDefaultLog());
        try {
            repository2.diff(url1, revisionNumber1, revisionNumber1, target, ((SvnDiff)this.getOperation()).isIgnoreAncestry(), this.getDiffDepth(((SvnDiff)this.getOperation()).getDepth()), true, (ISVNReporterBaton)reporter, editor);
            Object var23_22 = null;
            svnDiffEditor.cleanup();
        }
        catch (Throwable throwable) {
            Object var23_23 = null;
            svnDiffEditor.cleanup();
            throw throwable;
        }
    }

    private void doDiffWCWC(SvnTarget target1, SVNRevision revision1, SvnTarget target2, SVNRevision revision2) throws SVNException {
        long revisionNumber1;
        File path2;
        assert (!target1.isURL());
        assert (!target2.isURL());
        File path1 = target1.getFile();
        if (!path1.equals(path2 = target2.getFile()) || revision1 != SVNRevision.BASE || revision2 != SVNRevision.WORKING) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Summarized diffs are only supported between a path's text-base and its working files at this time");
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        try {
            revisionNumber1 = this.getRepositoryAccess().getRevisionNumber(null, target1, revision1, null).lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.CLIENT_BAD_REVISION) {
                revisionNumber1 = 0L;
            }
            throw e;
        }
        SVNNodeKind kind = SVNFileType.getNodeKind(SVNFileType.getType(path1));
        String targetString1 = kind == SVNNodeKind.DIR ? "" : SVNFileUtil.getFileName(path1);
        ISvnDiffGenerator generator = this.getDiffGenerator();
        generator.setOriginalTargets(target1, target2);
        generator.setAnchors(target1, target2);
        if (((SvnDiff)this.getOperation()).isUseGitDiffFormat()) {
            generator.setRepositoryRoot(SvnTarget.fromFile(this.getWcContext().getDb().getWCRoot(target1.getFile())));
        }
        SvnDiffCallback callback = this.createDiffCallback(generator, false, revisionNumber1, -1L);
        SvnNgDiffUtil.doDiffWCWC(path1, this.getRepositoryAccess(), this.getWcContext(), ((SvnDiff)this.getOperation()).getDepth(), !((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).getApplicableChangelists(), ((SvnDiff)this.getOperation()).isShowCopiesAsAdds(), ((SvnDiff)this.getOperation()).isUseGitDiffFormat(), generator, callback, ((SvnDiff)this.getOperation()).getEventHandler());
    }

    private void doDiffWC(File localAbspath, ISvnDiffCallback callback) throws SVNException {
        boolean getAll = ((SvnDiff)this.getOperation()).isShowCopiesAsAdds() || ((SvnDiff)this.getOperation()).isUseGitDiffFormat();
        boolean diffIgnored = false;
        SvnDiffStatusReceiver statusHandler = new SvnDiffStatusReceiver(this.getWcContext(), localAbspath, this.getWcContext().getDb(), callback, ((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).isShowCopiesAsAdds(), ((SvnDiff)this.getOperation()).isUseGitDiffFormat(), ((SvnDiff)this.getOperation()).getApplicableChangelists());
        SVNStatusEditor17 statusEditor = new SVNStatusEditor17(localAbspath, this.getWcContext(), ((SvnDiff)this.getOperation()).getOptions(), true, getAll, ((SvnDiff)this.getOperation()).getDepth(), statusHandler);
        statusEditor.walkStatus(localAbspath, ((SvnDiff)this.getOperation()).getDepth(), getAll, true, false, ((SvnDiff)this.getOperation()).getApplicableChangelists());
    }

    private SVNURL resolvePeggedDiffTargetUrl(SVNURL url, File path, SVNRevision pegRevision, SVNRevision revision) throws SVNException {
        try {
            Structure<SvnRepositoryAccess.LocationsInfo> locationsInfo = this.getRepositoryAccess().getLocations(null, url == null ? SvnTarget.fromFile(path) : SvnTarget.fromURL(url), pegRevision, revision, SVNRevision.UNDEFINED);
            return (SVNURL)locationsInfo.get(SvnRepositoryAccess.LocationsInfo.startUrl);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.CLIENT_UNRELATED_RESOURCES || e.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                return null;
            }
            throw e;
        }
    }

    private void checkDiffTargetExists(SVNURL url, long revision, long otherRevision, SVNRepository repository) throws SVNException {
        repository.setLocation(url, false);
        SVNNodeKind kind = repository.checkPath("", revision);
        if (kind == SVNNodeKind.NONE) {
            if (revision == otherRevision) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff target ''{0}'' was not found in the repository at revision ''{1}''", url, new Long(revision));
                SVNErrorManager.error(err, SVNLogType.WC);
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff target ''{0}'' was not found in the repository at revisions ''{1}'' and ''{2}''", url, new Long(revision), new Long(otherRevision));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
    }

    private SVNURL getURL(File path1) throws SVNException {
        return (SVNURL)this.getRepositoryAccess().getURLFromPath(SvnTarget.fromFile(path1), SVNRevision.UNDEFINED, null).get(SvnRepositoryAccess.UrlInfo.url);
    }

    private long getRevisionNumber(SVNRevision revision, SVNRepository repository, SvnTarget target) throws SVNException {
        Structure<SvnRepositoryAccess.RevisionsPair> revisionNumber = this.getRepositoryAccess().getRevisionNumber(repository, target, revision, null);
        return revisionNumber.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
    }

    private boolean isPeggedDiff() {
        return ((SvnDiff)this.getOperation()).getSource() != null;
    }

    private boolean isRevisionBase(SVNRevision revision2) {
        return revision2 == SVNRevision.BASE;
    }

    private SVNDepth getDiffDepth(SVNDepth depth) {
        return depth != SVNDepth.INFINITY ? depth : SVNDepth.UNKNOWN;
    }

    private SvnDiffCallback createDiffCallback(ISvnDiffGenerator generator, boolean reverse, long revisionNumber1, long revisionNumber2) {
        return new SvnDiffCallback(generator, reverse ? revisionNumber2 : revisionNumber1, reverse ? revisionNumber1 : revisionNumber2, ((SvnDiff)this.getOperation()).isShowCopiesAsAdds(), false, ((SvnDiff)this.getOperation()).getOutput());
    }

    private ISvnDiffGenerator getDiffGenerator() {
        ISvnDiffGenerator diffGenerator = ((SvnDiff)this.getOperation()).getDiffGenerator();
        if (diffGenerator == null) {
            diffGenerator = new SvnDiffGenerator();
        }
        diffGenerator.setUseGitFormat(((SvnDiff)this.getOperation()).isUseGitDiffFormat());
        if (((SvnDiff)this.getOperation()).getRelativeToDirectory() != null) {
            if (diffGenerator instanceof SvnDiffGenerator) {
                ((SvnDiffGenerator)diffGenerator).setRelativeToTarget(SvnTarget.fromFile(((SvnDiff)this.getOperation()).getRelativeToDirectory()));
            } else {
                diffGenerator.setBaseTarget(SvnTarget.fromFile(((SvnDiff)this.getOperation()).getRelativeToDirectory()));
            }
        }
        return diffGenerator;
    }
}

